/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename.logic;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.php.internal.core.ast.nodes.Expression;
import org.eclipse.php.internal.core.ast.nodes.Identifier;
import org.eclipse.php.internal.core.ast.nodes.Include;
import org.eclipse.php.internal.core.ast.nodes.ParenthesisExpression;
import org.eclipse.php.internal.core.ast.nodes.Scalar;
import org.eclipse.php.internal.core.filenetwork.FileNetworkUtility;
import org.eclipse.php.refactoring.core.PhpRefactoringCoreMessages;
import org.eclipse.php.refactoring.core.rename.logic.RenameClass;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class RenameIncludeAndClassName
extends RenameClass {
    private boolean updateClassName;
    private boolean updateReference;
    private IResource changingResouce;

    public RenameIncludeAndClassName(IFile file, String oldName, String newName, boolean searchTextual, boolean updateClassName, boolean updateReference, IResource resource) {
        super(file, null, oldName, newName, searchTextual, null);
        this.updateClassName = updateClassName;
        this.updateReference = updateReference;
        this.changingResouce = resource;
    }

    public boolean visit(Include include) {
        if (this.updateReference) {
            Expression expression;
            Expression exp = include.getExpression();
            Scalar scalar = null;
            if (exp instanceof ParenthesisExpression && (expression = ((ParenthesisExpression)exp).getExpression()) instanceof Scalar) {
                scalar = (Scalar)expression;
            }
            if (exp instanceof Scalar) {
                scalar = (Scalar)exp;
            }
            if (scalar == null) {
                return super.visit(include);
            }
            String stringValue = scalar.getStringValue();
            if (this.isScalarNeedChange(scalar, stringValue)) {
                this.addChange(scalar, PhpRefactoringCoreMessages.getString("RenameIncludeAndClassName.1"));
            }
        }
        return false;
    }

    @Override
    protected void checkIdentifier(Identifier identifier) {
        if (this.updateClassName) {
            super.checkIdentifier(identifier);
        }
    }

    private void addChange(Scalar scalar, String description) {
        String stringValue = scalar.getStringValue();
        int index = stringValue.lastIndexOf(this.oldName);
        this.addChange(scalar.getStart() + index, description);
    }

    @Override
    protected void addChange(int start, String description) {
        TextEditGroup textEditGroup = new TextEditGroup(description);
        ReplaceEdit replaceEdit = new ReplaceEdit(start, this.oldName.length(), this.newName);
        textEditGroup.addTextEdit((TextEdit)replaceEdit);
        this.groups.add(textEditGroup);
    }

    private boolean isScalarNeedChange(Scalar scalar, String stringValue) {
        IPath path = this.getPath(stringValue);
        return scalar.getScalarType() == 2 && this.changingResouce.getFullPath().equals((Object)path);
    }

    private IPath getPath(String includeString) {
        if (includeString.startsWith("\"") || includeString.startsWith("'")) {
            includeString = includeString.substring(1, includeString.length() - 1);
        }
        Path path = null;
        if (includeString.startsWith(".")) {
            path = new Path(includeString);
            if (!path.isAbsolute()) {
                path = this.changedFile.getParent().getFullPath().append((IPath)path);
            }
        } else {
            ISourceModule findSourceModule = FileNetworkUtility.findSourceModule((ISourceModule)DLTKCore.createSourceModuleFrom((IFile)this.changedFile), (String)includeString);
            if (findSourceModule != null) {
                path = findSourceModule.getPath();
            }
        }
        return path;
    }
}

