/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.tests.selection;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.SourceRange;
import org.eclipse.php.core.tests.PHPCoreTests;
import org.eclipse.php.core.tests.codeassist.CodeAssistPdttFile;
import org.eclipse.php.core.tests.runner.PDTTList;
import org.eclipse.php.internal.core.PHPVersion;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=PDTTList.class)
public class SelectionEngineTests {
    protected static final char SELECTION_CHAR = '|';
    @PDTTList.Parameters
    public static final Map<PHPVersion, String[]> TESTS = new LinkedHashMap<PHPVersion, String[]>();
    protected IProject project;
    protected IFile testFile;
    protected PHPVersion version;

    static {
        TESTS.put(PHPVersion.PHP5, new String[]{"/workspace/selection/php5"});
        TESTS.put(PHPVersion.PHP5_3, new String[]{"/workspace/selection/php5", "/workspace/selection/php53"});
        TESTS.put(PHPVersion.PHP5_4, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54"});
        TESTS.put(PHPVersion.PHP5_5, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54", "/workspace/selection/php55"});
        TESTS.put(PHPVersion.PHP5_6, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54", "/workspace/selection/php55", "/workspace/selection/php56"});
        TESTS.put(PHPVersion.PHP7_0, new String[]{"/workspace/selection/php5", "/workspace/selection/php53", "/workspace/selection/php54", "/workspace/selection/php55", "/workspace/selection/php56", "/workspace/selection/php7"});
    }

    public SelectionEngineTests(PHPVersion version, String[] fileNames) {
        this.version = version;
    }

    @PDTTList.BeforeList
    public void setUpSuite() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject("AutoSelectionEngine_" + this.version.toString());
        if (this.project.exists()) {
            return;
        }
        this.project.create(null);
        this.project.open(null);
        IProjectDescription desc = this.project.getDescription();
        desc.setNatureIds(new String[]{"org.eclipse.php.core.PHPNature"});
        this.project.setDescription(desc, null);
        PHPCoreTests.setProjectPhpVersion(this.project, this.version);
    }

    @PDTTList.AfterList
    public void tearDownSuite() throws Exception {
        this.project.close(null);
        this.project.delete(true, true, null);
        this.project = null;
    }

    @Test
    public void selection(String fileName) throws Exception {
        int n;
        CodeAssistPdttFile pdttFile = new CodeAssistPdttFile(fileName);
        IModelElement[] elements = this.getSelection(pdttFile.getFile());
        CodeAssistPdttFile.ExpectedProposal[] expectedProposals = pdttFile.getExpectedProposals();
        boolean proposalsEqual = true;
        if (elements.length == expectedProposals.length) {
            CodeAssistPdttFile.ExpectedProposal[] expectedProposalArray = pdttFile.getExpectedProposals();
            n = expectedProposalArray.length;
            int n2 = 0;
            while (n2 < n) {
                CodeAssistPdttFile.ExpectedProposal expectedProposal = expectedProposalArray[n2];
                boolean found = false;
                IModelElement[] iModelElementArray = elements;
                int n3 = elements.length;
                int n4 = 0;
                while (n4 < n3) {
                    IModelElement modelElement = iModelElementArray[n4];
                    if (modelElement.getElementType() == expectedProposal.type && modelElement.getElementName().equalsIgnoreCase(expectedProposal.name)) {
                        found = true;
                        break;
                    }
                    ++n4;
                }
                if (!found) {
                    proposalsEqual = false;
                    break;
                }
                ++n2;
            }
        } else {
            proposalsEqual = false;
        }
        if (!proposalsEqual) {
            StringBuilder errorBuf = new StringBuilder();
            errorBuf.append("\nEXPECTED ELEMENTS LIST:\n-----------------------------\n");
            errorBuf.append(pdttFile.getExpected());
            errorBuf.append("\nACTUAL ELEMENTS LIST:\n-----------------------------\n");
            IModelElement[] iModelElementArray = elements;
            int n5 = elements.length;
            n = 0;
            while (n < n5) {
                IModelElement modelElement = iModelElementArray[n];
                switch (modelElement.getElementType()) {
                    case 8: {
                        errorBuf.append("field");
                        break;
                    }
                    case 9: {
                        errorBuf.append("method");
                        break;
                    }
                    case 7: {
                        errorBuf.append("type");
                    }
                }
                errorBuf.append('(').append(modelElement.getElementName()).append(")\n");
                ++n;
            }
            Assert.fail((String)errorBuf.toString());
        }
    }

    @After
    public void after() throws Exception {
        if (this.testFile != null) {
            this.testFile.delete(true, null);
            this.testFile = null;
        }
    }

    protected ISourceRange createFile(String data) throws Exception {
        int left = data.indexOf(124);
        if (left == -1) {
            throw new IllegalArgumentException("Selection characters are not set");
        }
        int right = (data = String.valueOf(data.substring(0, left)) + data.substring(left + 1)).indexOf(124);
        if (right == -1) {
            throw new IllegalArgumentException("Selection is not closed");
        }
        data = String.valueOf(data.substring(0, right)) + data.substring(right + 1);
        this.testFile = this.project.getFile("test.php");
        this.testFile.create((InputStream)new ByteArrayInputStream(data.getBytes()), true, null);
        this.project.refreshLocal(2, null);
        this.project.build(6, null);
        PHPCoreTests.waitForIndexer();
        return new SourceRange(left, right - left);
    }

    protected ISourceModule getSourceModule() {
        return DLTKCore.createSourceModuleFrom((IFile)this.testFile);
    }

    protected IModelElement[] getSelection(String data) throws Exception {
        ISourceRange range = this.createFile(data);
        ISourceModule sourceModule = this.getSourceModule();
        IModelElement[] elements = sourceModule.codeSelect(range.getOffset(), range.getLength());
        return elements;
    }
}

