/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.debug.ui.views;

import org.eclipse.ptp.internal.debug.ui.views.CTable;
import org.eclipse.ptp.internal.debug.ui.views.ICTableModel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractCTableCellEditor {
    protected CTable m_Table;
    protected Rectangle m_Rect;
    protected int m_Row;
    protected int m_Col;
    protected Control m_Control;
    protected String toolTip;
    protected ICTableModel m_Model;

    public void dispose() {
        if (this.m_Control != null) {
            this.m_Control.dispose();
            this.m_Control = null;
        }
    }

    public void open(CTable table, int col, int row, Rectangle rect) {
        this.m_Table = table;
        this.m_Model = table.getModel();
        this.m_Rect = rect;
        this.m_Row = row;
        this.m_Col = col;
        if (this.m_Control == null) {
            this.m_Control = this.createControl();
            this.m_Control.setToolTipText(this.toolTip);
            this.m_Control.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent arg0) {
                    AbstractCTableCellEditor.this.close(true);
                }
            });
        }
        this.setBounds(this.m_Rect);
        GC gc = new GC((Drawable)this.m_Table);
        this.m_Table.drawCell(gc, this.m_Col, this.m_Row);
        gc.dispose();
    }

    public void close(boolean save) {
        this.m_Table.m_CellEditor = null;
        GC gc = new GC((Drawable)this.m_Table);
        this.m_Table.drawCell(gc, this.m_Col, this.m_Row);
        gc.dispose();
        this.dispose();
    }

    public boolean isFocused() {
        if (this.m_Control == null) {
            return false;
        }
        return this.m_Control.isFocusControl();
    }

    public void setBounds(Rectangle rect) {
        if (this.m_Control != null) {
            this.m_Control.setBounds(rect);
        }
    }

    protected void onKeyPressed(KeyEvent e) {
        if (e.character == '\r' && (e.stateMask & 0x20000) == 0) {
            this.close(true);
        } else if (e.character == '\u001b') {
            this.close(false);
        } else {
            this.m_Table.scrollToFocus();
        }
    }

    protected void onTraverse(TraverseEvent e) {
        this.close(true);
    }

    public void setToolTipText(String toolTip) {
        this.toolTip = toolTip;
    }

    protected abstract Control createControl();
}

