/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.remote.terminal;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ptp.internal.remote.terminal.Activator;
import org.eclipse.ptp.internal.remote.terminal.MachineManager;
import org.eclipse.ptp.internal.remote.terminal.Util;
import org.eclipse.ptp.internal.remote.terminal.messages.Messages;
import org.eclipse.remote.core.IRemoteCommandShellService;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.core.IRemoteConnectionHostService;
import org.eclipse.remote.core.IRemoteFileService;
import org.eclipse.remote.core.IRemoteProcess;
import org.eclipse.remote.core.IRemoteProcessBuilder;
import org.eclipse.remote.core.IRemoteProcessService;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.terminal.connector.remote.IRemoteTerminalParser;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class RemoteTerminalParser
implements IRemoteTerminalParser {
    private static final Pattern pattern = Pattern.compile("~~EPTP:(\\w*)~~(?:EDID=([\\w\\.]+)~~)?(.*)");
    private static final String BASH_STARTUP_SCRIPT = ".ptprc.sh";
    private static final String CSH_STARTUP_SCRIPT = ".ptprc.csh";
    private IRemoteConnection fRemoteConnection;
    private IRemoteProcess fProcess;

    protected static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    private void doAction(String type, String str, String arg) {
        if (type.equals("Radio")) {
            this.doRadioAction(str);
        } else if (type.equals("Choice")) {
            this.doChoiceAction(str, arg);
        } else if (type.equals("OpenFile")) {
            this.openFile(str, arg);
        }
    }

    private void doChoiceAction(String str, final String arg) {
        final String[] choices = str.split("\\s*~~\\s*");
        RemoteTerminalParser.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Dialog dialog = new Dialog(RemoteTerminalParser.getStandardDisplay().getActiveShell()){
                        private Combo combo;
                        private String[] comboChoices;

                        public void buttonPressed(int buttonId) {
                            int n = this.combo.getSelectionIndex();
                            if (buttonId == 0 && n >= 0 && n < this.comboChoices.length) {
                                RemoteTerminalParser.this.openFile(this.comboChoices[n], arg);
                            }
                            this.close();
                        }

                        protected void configureShell(Shell shell) {
                            shell.setText(Messages.CHOOSE_FILE);
                            super.configureShell(shell);
                        }

                        protected Control createDialogArea(Composite parent) {
                            Composite container = (Composite)super.createDialogArea(parent);
                            this.combo = new Combo(container, 0);
                            this.combo.setItems(choices);
                            this.comboChoices = choices;
                            Point pt = this.combo.computeSize(-1, -1);
                            this.combo.setSize(pt.x, 5 * pt.y);
                            return container;
                        }
                    };
                    dialog.open();
                }
                catch (Exception t) {
                    Activator.log(t);
                }
            }
        });
    }

    private void doRadioAction(String str) {
        final String[] choices = str.split("\\s*~~\\s*");
        RemoteTerminalParser.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    Dialog dialog = new Dialog(RemoteTerminalParser.getStandardDisplay().getActiveShell()){
                        private final Map<String, String> smap;
                        private final List<Button> buttons;
                        {
                            super($anonymous0);
                            this.smap = new HashMap<String, String>();
                            this.buttons = new ArrayList<Button>();
                        }

                        public void buttonPressed(int buttonId) {
                            if (buttonId == 0) {
                                for (Button b : this.buttons) {
                                    if (!b.getSelection()) continue;
                                    String value = this.smap.get(b.getText());
                                    try {
                                        OutputStream out = RemoteTerminalParser.this.fProcess.getOutputStream();
                                        out.write((String.valueOf(value) + "\n").getBytes());
                                        out.flush();
                                    }
                                    catch (IOException iOException) {
                                        // empty catch block
                                    }
                                }
                            }
                            this.close();
                        }

                        protected void configureShell(Shell shell) {
                            shell.setText(Messages.CHOOSE_FILE);
                            super.configureShell(shell);
                        }

                        protected Control createDialogArea(Composite parent) {
                            Composite container = (Composite)super.createDialogArea(parent);
                            String[] stringArray = choices;
                            int n = choices.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String choice = stringArray[n2];
                                String[] keyvalue = choice.split("::~");
                                if (keyvalue.length == 2) {
                                    Button b = new Button(container, 16);
                                    b.setText(keyvalue[0]);
                                    this.smap.put(keyvalue[0], keyvalue[1]);
                                    this.buttons.add(b);
                                }
                                ++n2;
                            }
                            return container;
                        }
                    };
                    dialog.open();
                }
                catch (Exception t) {
                    Activator.log(t);
                }
            }
        });
    }

    public IRemoteProcess initialize(IRemoteConnection connection) throws IOException {
        this.fRemoteConnection = connection;
        MachineManager.MachineInfo minfo = MachineManager.initializeMachine(connection);
        if (connection.hasService(IRemoteCommandShellService.class)) {
            IRemoteCommandShellService shellSvc = (IRemoteCommandShellService)connection.getService(IRemoteCommandShellService.class);
            this.fProcess = shellSvc.getCommandShell(1);
        } else {
            ArrayList<String> shellCommand = new ArrayList<String>();
            shellCommand.add(minfo.shell);
            shellCommand.add("-l");
            IRemoteProcessService procSvc = (IRemoteProcessService)connection.getService(IRemoteProcessService.class);
            IRemoteProcessBuilder processBuilder = procSvc.getProcessBuilder(shellCommand);
            this.fProcess = processBuilder.start(1);
        }
        OutputStream outputStream = this.fProcess.getOutputStream();
        IRemoteConnectionHostService hostSvc = (IRemoteConnectionHostService)connection.getService(IRemoteConnectionHostService.class);
        MachineManager.setOutputStream(hostSvc.getHostname(), outputStream);
        IRemoteFileService fileSvc = (IRemoteFileService)connection.getService(IRemoteFileService.class);
        if (fileSvc != null && (minfo.isBash || minfo.isCsh)) {
            IFileStore startupPath;
            String startup = minfo.isBash ? BASH_STARTUP_SCRIPT : CSH_STARTUP_SCRIPT;
            String homeDir = connection.getProperty("user.home");
            if (homeDir != null && (startupPath = fileSvc.getResource(homeDir).getChild(startup)).fetchInfo().exists()) {
                outputStream.write(("source " + startupPath.toURI().getPath() + "\n").getBytes());
                outputStream.flush();
            }
        }
        return this.fProcess;
    }

    public void openFile(final String file, final String suffix) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            final IProject prj = iProjectArray[n2];
            final URI remoteURI = Util.getLocationURI(prj);
            if (remoteURI != null && file.startsWith(remoteURI.getPath())) {
                RemoteTerminalParser.getStandardDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        try {
                            String loc = file.substring(remoteURI.getPath().length() + 1);
                            IFile file2 = prj.getFile(loc);
                            IDE.openEditor((IWorkbenchPage)page, (IFile)file2);
                        }
                        catch (PartInitException e) {
                            Activator.log(e);
                        }
                    }
                });
                return;
            }
            ++n2;
        }
        RemoteTerminalParser.getStandardDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IEditorDescriptor suffixDesc;
                    String autoEditorId;
                    IEditorDescriptor editorDesc = IDE.getEditorDescriptor((String)file, (boolean)true, (boolean)true);
                    IRemoteFileService fileSvc = (IRemoteFileService)RemoteTerminalParser.this.fRemoteConnection.getService(IRemoteFileService.class);
                    URI uri = fileSvc.toURI(file);
                    String editorId = autoEditorId = editorDesc.getId();
                    if (suffix != null && (suffixDesc = IDE.getEditorDescriptor((String)("file." + suffix), (boolean)true, (boolean)true)) != null) {
                        editorId = suffixDesc.getId();
                    }
                    try {
                        IDE.openEditor((IWorkbenchPage)page, (URI)uri, (String)editorId, (boolean)true);
                    }
                    catch (Exception e) {
                        IEditorDescriptor suffixDesc2 = IDE.getEditorDescriptor((String)"file.txt", (boolean)true, (boolean)true);
                        if (suffixDesc2 != null) {
                            editorId = suffixDesc2.getId();
                        }
                        IDE.openEditor((IWorkbenchPage)page, (URI)uri, (String)editorId, (boolean)true);
                    }
                }
                catch (PartInitException e) {
                    Activator.log(e);
                }
            }
        });
    }

    public boolean parse(byte[] buf) {
        String str = new String(buf);
        Matcher match = pattern.matcher(str);
        if (match.find()) {
            String cmd = match.group(1);
            if (match.groupCount() == 3) {
                String location = match.group(3);
                String suffix = match.group(2);
                this.doAction(cmd, location, suffix);
            } else {
                String location = match.group(2);
                this.doAction(cmd, location, null);
            }
            return false;
        }
        return true;
    }
}

