/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.local;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.tcf.core.AbstractChannel;
import org.eclipse.tcf.core.UserDefPeer;
import org.eclipse.tcf.internal.core.LocalPeer;
import org.eclipse.tcf.internal.core.LoggingUtil;
import org.eclipse.tcf.internal.core.RemotePeer;
import org.eclipse.tcf.internal.core.ServiceManager;
import org.eclipse.tcf.internal.services.local.ChannelProxy;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IServiceProvider;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ILocator;

public class LocatorService
implements ILocator {
    private static final int DISCOVERY_PORT = 1534;
    private static final int MAX_PACKET_SIZE = 8952;
    private static final int PREF_PACKET_SIZE = 1452;
    private static LocatorService locator;
    private static LocalPeer local_peer;
    private static final Map<String, IPeer> peers;
    private static final ArrayList<ILocator.LocatorListener> listeners;
    private static final HashSet<String> error_log;
    private final HashSet<SubNet> subnets = new HashSet();
    private final ArrayList<Slave> slaves = new ArrayList();
    private final byte[] inp_buf = new byte[8952];
    private final byte[] out_buf = new byte[8952];
    private InetAddress loopback_addr;
    private static boolean TRACE_DISCOVERY;
    private static final HashMap<String, AddressCacheItem> addr_cache;
    private static boolean addr_request;
    private DatagramSocket socket;
    private long last_master_packet_time;
    private final Thread timer_thread = new Thread(){

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        final HashSet set = LocatorService.this.getSubNetList();
                        Protocol.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LocatorService.this.refresh_timer(set);
                            }
                        });
                        1.sleep(15000L);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    return;
                }
                catch (Throwable x) {
                    LocatorService.this.log("Unhandled exception in TCF discovery timer thread", x);
                    continue;
                }
                break;
            }
        }
    };
    private Thread dns_lookup_thread = new Thread(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            while (true) {
                try lbl-1000:
                // 2 sources

                {
                    while (true) {
                        set = null;
                        var4_4 = LocatorService.access$3();
                        synchronized (var4_4) {
                            if (!LocatorService.access$4()) {
                                LocatorService.access$3().wait(60000L);
                            }
                            time = System.currentTimeMillis();
                            i = LocatorService.access$3().values().iterator();
                            while (true) {
                                if (!i.hasNext()) {
                                    LocatorService.access$5(false);
                                    break;
                                }
                                a = (AddressCacheItem)i.next();
                                if (a.time_stamp + 600000L >= time) continue;
                                if (a.used) {
                                    if (set == null) {
                                        set = new HashSet<AddressCacheItem>();
                                    }
                                    set.add(a);
                                    continue;
                                }
                                i.remove();
                            }
                        }
                        if (set == null) continue;
                        var5_5 = set.iterator();
                        if (true) ** GOTO lbl51
                        break;
                    }
                }
                catch (Throwable x) {
                    LocatorService.access$2(LocatorService.this, "Unhandled exception in TCF discovery DNS lookup thread", x);
                    continue;
                }
                break;
            }
            do {
                a = (AddressCacheItem)var5_5.next();
                addr = null;
                try {
                    addr = InetAddress.getByName(a.host);
                }
                catch (UnknownHostException v1) {}
                var7_7 = LocatorService.access$3();
                synchronized (var7_7) {
                    a.address = addr;
                    a.time_stamp = time;
                    a.used = false;
                }
lbl51:
                // 2 sources

            } while (var5_5.hasNext());
            ** while (true)
        }
    };
    private final Thread input_thread = new Thread(){

        /*
         * Unable to fully structure code
         */
        @Override
        public void run() {
            try {
                while (true) lbl-1000:
                // 4 sources

                {
                    socket = LocatorService.access$6(LocatorService.this);
                    try {
                        p = new InputPacket(new DatagramPacket(LocatorService.access$7(LocatorService.this), LocatorService.access$7(LocatorService.this).length));
                        socket.receive(p.getPacket());
                        Protocol.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                LocatorService.this.handleDatagramPacket(p);
                            }
                        });
                    }
                    catch (IllegalStateException v0) {
                        return;
                    }
                    catch (Exception x) {
                        if (socket != LocatorService.access$6(LocatorService.this)) ** GOTO lbl-1000
                        LocatorService.access$2(LocatorService.this, "Cannot read from datagram socket at port " + socket.getLocalPort(), x);
                        3.sleep(2000L);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable x) {
                LocatorService.access$2(LocatorService.this, "Unhandled exception in socket reading thread", x);
                return;
            }
            ** GOTO lbl-1000
        }
    };
    private static String[] packetTypes;

    static {
        peers = new HashMap<String, IPeer>();
        listeners = new ArrayList();
        error_log = new HashSet();
        TRACE_DISCOVERY = System.getProperty("org.eclipse.tcf.core.tracing.discovery") != null;
        addr_cache = new HashMap();
        ServiceManager.addServiceProvider(new IServiceProvider(){

            @Override
            public IService[] getLocalService(final IChannel channel) {
                channel.addCommandServer(locator, new IChannel.ICommandServer(){

                    @Override
                    public void command(IToken token, String name, byte[] data) {
                        locator.command((AbstractChannel)channel, token, name, data);
                    }
                });
                return new IService[]{locator};
            }

            @Override
            public IService getServiceProxy(IChannel channel, String service_name) {
                return null;
            }
        });
        boolean isWin = System.getProperty("os.name", "").toLowerCase().startsWith("windows");
        if (isWin && System.getProperty("java.net.preferIPv4Stack") == null) {
            System.setProperty("java.net.preferIPv4Stack", "true");
        }
        String[] stringArray = new String[6];
        stringArray[1] = "CONF_REQ_INFO";
        stringArray[2] = "CONF_PEER_INFO";
        stringArray[3] = "CONF_REQ_SLAVES";
        stringArray[4] = "CONF_SLAVES_INFO";
        stringArray[5] = "CONF_PEER_REMOVE";
        packetTypes = stringArray;
    }

    private static DatagramSocket createSocket(boolean slave) throws SocketException {
        DatagramSocket socket = null;
        if (slave) {
            socket = new DatagramSocket();
        } else {
            socket = new DatagramSocket(null);
            socket.setReuseAddress(false);
            socket.bind(new InetSocketAddress(1534));
        }
        socket.setBroadcast(true);
        return socket;
    }

    public static void createLocalInstance() {
        local_peer = new LocalPeer();
        locator = new LocatorService();
    }

    public LocatorService() {
        try {
            block5: {
                this.loopback_addr = InetAddress.getByName(null);
                this.out_buf[0] = 84;
                this.out_buf[1] = 67;
                this.out_buf[2] = 70;
                this.out_buf[3] = 50;
                this.out_buf[4] = 0;
                this.out_buf[5] = 0;
                this.out_buf[6] = 0;
                this.out_buf[7] = 0;
                try {
                    this.socket = LocatorService.createSocket(false);
                    if (TRACE_DISCOVERY) {
                        LoggingUtil.trace("Became the master agent (bound to port " + this.socket.getLocalPort() + ")");
                    }
                }
                catch (SocketException socketException) {
                    this.socket = LocatorService.createSocket(true);
                    if (!TRACE_DISCOVERY) break block5;
                    LoggingUtil.trace("Became a slave agent (bound to port " + this.socket.getLocalPort() + ")");
                }
            }
            this.input_thread.setName("TCF Locator Receiver");
            this.timer_thread.setName("TCF Locator Timer");
            this.dns_lookup_thread.setName("TCF Locator DNS Lookup");
            this.input_thread.setDaemon(true);
            this.timer_thread.setDaemon(true);
            this.dns_lookup_thread.setDaemon(true);
            Protocol.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LocatorService.this.input_thread.start();
                    LocatorService.this.timer_thread.start();
                    LocatorService.this.dns_lookup_thread.start();
                }
            });
            listeners.add(new ILocator.LocatorListener(){

                @Override
                public void peerAdded(IPeer peer) {
                    LocatorService.this.sendPeerInfo(peer, null, 0);
                }

                @Override
                public void peerChanged(IPeer peer) {
                    LocatorService.this.sendPeerInfo(peer, null, 0);
                }

                @Override
                public void peerHeartBeat(String id) {
                }

                @Override
                public void peerRemoved(String id) {
                }
            });
        }
        catch (Exception x) {
            this.log("Cannot open UDP socket for TCF discovery protocol", x);
        }
    }

    public static LocalPeer getLocalPeer() {
        return local_peer;
    }

    public static ILocator.LocatorListener[] getListeners() {
        return listeners.toArray(new ILocator.LocatorListener[listeners.size()]);
    }

    private Map<String, Object> makeErrorReport(int code, String msg) {
        HashMap<String, Object> err = new HashMap<String, Object>();
        err.put("Time", System.currentTimeMillis());
        err.put("Code", code);
        err.put("Format", msg);
        return err;
    }

    private void command(AbstractChannel channel, IToken token, String name, byte[] data) {
        try {
            if (name.equals("redirect")) {
                String peer_id = (String)JSON.parseSequence(data)[0];
                IPeer peer = peers.get(peer_id);
                if (peer == null) {
                    channel.sendResult(token, JSON.toJSONSequence(new Object[]{this.makeErrorReport(7, "Unknown peer ID")}));
                    return;
                }
                channel.sendResult(token, JSON.toJSONSequence(new Object[1]));
                if (peer instanceof LocalPeer) {
                    channel.sendEvent(Protocol.getLocator(), "Hello", JSON.toJSONSequence(new Object[]{channel.getLocalServices()}));
                    return;
                }
                new ChannelProxy(channel, peer.openChannel());
            } else if (name.equals("sync")) {
                channel.sendResult(token, null);
            } else if (name.equals("getPeers")) {
                int i = 0;
                Object[] arr = new Object[peers.size()];
                for (IPeer p : peers.values()) {
                    arr[i++] = p.getAttributes();
                }
                Object[] objectArray = new Object[2];
                objectArray[1] = arr;
                channel.sendResult(token, JSON.toJSONSequence(objectArray));
            } else {
                channel.rejectCommand(token);
            }
        }
        catch (Throwable x) {
            channel.terminate(x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(String msg, Throwable x) {
        HashSet<String> hashSet = error_log;
        synchronized (hashSet) {
            if (error_log.contains(msg)) {
                return;
            }
            error_log.add(msg);
        }
        Protocol.log(msg, x);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InetAddress getInetAddress(String host) {
        if (host == null || host.length() == 0) {
            return null;
        }
        HashMap<String, AddressCacheItem> hashMap = addr_cache;
        synchronized (hashMap) {
            AddressCacheItem i = addr_cache.get(host);
            if (i == null) {
                i = new AddressCacheItem(host);
                char ch = host.charAt(0);
                if (ch == '[' || ch == ':' || ch >= '0' && ch <= '9') {
                    try {
                        i.address = InetAddress.getByName(host);
                    }
                    catch (UnknownHostException unknownHostException) {}
                    i.time_stamp = System.currentTimeMillis();
                } else {
                    addr_request = true;
                    addr_cache.notify();
                }
                addr_cache.put(host, i);
            }
            i.used = true;
            return i.address;
        }
    }

    private void refresh_timer(HashSet<SubNet> nets) {
        long time = System.currentTimeMillis();
        if (this.slaves.size() > 0) {
            int i = 0;
            while (i < this.slaves.size()) {
                Slave slave = this.slaves.get(i);
                if (slave.last_packet_time + 60000L < time) {
                    this.slaves.remove(i);
                    continue;
                }
                ++i;
            }
        }
        ArrayList<RemotePeer> stale_peers = null;
        for (IPeer iPeer : peers.values()) {
            RemotePeer r;
            if (!(iPeer instanceof RemotePeer) || (r = (RemotePeer)iPeer).getLastUpdateTime() + 60000L >= time) continue;
            if (stale_peers == null) {
                stale_peers = new ArrayList<RemotePeer>();
            }
            stale_peers.add(r);
        }
        if (stale_peers != null) {
            for (RemotePeer remotePeer : stale_peers) {
                remotePeer.dispose();
            }
        }
        if (this.socket.getLocalPort() != 1534 && this.last_master_packet_time + 30000L <= time) {
            try {
                DatagramSocket datagramSocket = this.socket;
                this.socket = LocatorService.createSocket(false);
                if (TRACE_DISCOVERY) {
                    LoggingUtil.trace("Became the master agent (bound to port " + this.socket.getLocalPort() + ")");
                }
                datagramSocket.close();
            }
            catch (Throwable throwable) {}
        }
        if (this.refreshSubNetList(nets)) {
            this.sendPeersRequest(null, 0);
        }
        if (this.socket.getLocalPort() != 1534) {
            for (SubNet subNet : this.subnets) {
                this.addSlave(subNet.address, this.socket.getLocalPort(), time);
            }
        }
        this.sendAll(null, 0, null, time);
    }

    private Slave addSlave(InetAddress addr, int port, long timestamp) {
        Slave s2;
        for (final Slave s2 : this.slaves) {
            if (s2.port != port || !s2.address.equals(addr)) continue;
            if (s2.last_packet_time < timestamp) {
                s2.last_packet_time = timestamp;
            }
            return s2;
        }
        s2 = new Slave(addr, port);
        s2.last_packet_time = timestamp;
        this.slaves.add(s2);
        Protocol.invokeLater(new Runnable(){

            @Override
            public void run() {
                long time_now = System.currentTimeMillis();
                LocatorService.this.sendPeersRequest(s2.address, s2.port);
                LocatorService.this.sendAll(s2.address, s2.port, s2, time_now);
                LocatorService.this.sendSlaveInfo(s2, time_now);
            }
        });
        return s2;
    }

    private boolean refreshSubNetList(HashSet<SubNet> set) {
        if (set == null) {
            return false;
        }
        Iterator<SubNet> i = this.subnets.iterator();
        while (i.hasNext()) {
            SubNet s = i.next();
            if (set.contains(s)) continue;
            i.remove();
        }
        boolean new_nets = false;
        for (SubNet s : set) {
            if (this.subnets.contains(s)) continue;
            this.subnets.add(s);
            new_nets = true;
        }
        if (TRACE_DISCOVERY) {
            StringBuilder str = new StringBuilder("Refreshed subnet list:");
            for (SubNet subnet : this.subnets) {
                str.append("\n\t* address=" + subnet.address + ", broadcast=" + subnet.broadcast);
            }
            LoggingUtil.trace(str.toString());
        }
        return new_nets;
    }

    private HashSet<SubNet> getSubNetList() {
        HashSet<SubNet> set = new HashSet<SubNet>();
        try {
            String osname = System.getProperty("os.name", "");
            if (osname.startsWith("Windows")) {
                this.getWindowsSubNetList(set);
            } else {
                this.getSubNetList(set);
            }
        }
        catch (Exception x) {
            this.log("Cannot get list of network interfaces", x);
            return null;
        }
        return set;
    }

    private void getSubNetList(HashSet<SubNet> set) throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface f = e.nextElement();
            for (InterfaceAddress ia : f.getInterfaceAddresses()) {
                int network_prefix_len = ia.getNetworkPrefixLength();
                InetAddress address = ia.getAddress();
                InetAddress broadcast = ia.getBroadcast();
                if (address instanceof Inet4Address) {
                    byte[] buf;
                    if (network_prefix_len == 0 && (buf = address.getAddress())[0] == 127) {
                        network_prefix_len = 8;
                    }
                    if (broadcast == null) {
                        broadcast = address;
                    }
                }
                if (network_prefix_len <= 0 || address == null || broadcast == null) continue;
                set.add(new SubNet(network_prefix_len, address, broadcast));
            }
        }
    }

    private void getWindowsSubNetList(HashSet<SubNet> set) throws Exception {
        String s;
        HashMap<String, InetAddress> map = new HashMap<String, InetAddress>();
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface f = e.nextElement();
            Enumeration<InetAddress> n = f.getInetAddresses();
            while (n.hasMoreElements()) {
                InetAddress addr = n.nextElement();
                if (!(addr instanceof Inet4Address)) continue;
                String s2 = addr.getHostAddress();
                if (s2.startsWith("127.")) {
                    byte[] buf = addr.getAddress();
                    buf[3] = -1;
                    buf[2] = -1;
                    buf[1] = -1;
                    set.add(new SubNet(8, addr, InetAddress.getByAddress(buf)));
                    continue;
                }
                map.put(s2, addr);
            }
        }
        Process prs = Runtime.getRuntime().exec(new String[]{"ipconfig", "/all"}, null);
        BufferedReader inp = new BufferedReader(new InputStreamReader(prs.getInputStream()));
        while ((s = inp.readLine()) != null) {
            InetAddress addr;
            int n = s.indexOf(" : ");
            if (n < 0) continue;
            int m = n += 3;
            while (m < s.length()) {
                char ch = s.charAt(m);
                if ((ch < '0' || ch > '9') && ch != '.') break;
                ++m;
            }
            if (m == n || (addr = (InetAddress)map.get(s.substring(n, m))) == null) continue;
            while ((s = inp.readLine()) != null && s.length() == 0) {
            }
            if (s == null) break;
            n = s.indexOf(" : ");
            if (n < 0) continue;
            s = s.substring(n + 3);
            int l = s.length();
            int i_cnt = 0;
            int d_cnt = 0;
            int i = 0;
            while (i < l) {
                char ch = s.charAt(i);
                if (ch == '.') {
                    ++d_cnt;
                } else if (ch < '0' || ch > '9') {
                    ++i_cnt;
                }
                ++i;
            }
            if (d_cnt != 3 || i_cnt != 0) continue;
            try {
                byte[] buf = InetAddress.getByName(s).getAddress();
                int prefix_length = 0;
                int i2 = 0;
                while (i2 < 32) {
                    if ((buf[i2 / 8] & 1 << 7 - i2 % 8) == 0) {
                        prefix_length = i2;
                        break;
                    }
                    ++i2;
                }
                if (prefix_length <= 0) continue;
                buf = addr.getAddress();
                i2 = prefix_length;
                while (i2 < 32) {
                    int n2 = i2 / 8;
                    buf[n2] = (byte)(buf[n2] | 1 << 7 - i2 % 8);
                    ++i2;
                }
                set.add(new SubNet(prefix_length, addr, InetAddress.getByAddress(buf)));
            }
            catch (Exception exception) {}
        }
        try {
            prs.getErrorStream().close();
            prs.getOutputStream().close();
            inp.close();
        }
        catch (IOException iOException) {}
        prs.waitFor();
    }

    private byte[] getUTF8Bytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (Exception x) {
            this.log("UTF-8 character encoder is not available", x);
            return s.getBytes();
        }
    }

    private boolean sendDatagramPacket(SubNet subnet, int size, InetAddress addr, int port) {
        block13: {
            block12: {
                try {
                    if (addr == null) {
                        addr = subnet.address.equals(this.loopback_addr) ? this.loopback_addr : subnet.broadcast;
                        port = 1534;
                        for (Slave slave : this.slaves) {
                            this.sendDatagramPacket(subnet, size, slave.address, slave.port);
                        }
                    }
                    if (subnet.contains(addr)) break block12;
                    return false;
                }
                catch (Exception x) {
                    this.log("Cannot send datagram packet to " + addr, x);
                    return false;
                }
            }
            if (port != this.socket.getLocalPort() || !addr.equals(subnet.address)) break block13;
            return false;
        }
        this.socket.send(new DatagramPacket(this.out_buf, size, addr, port));
        if (TRACE_DISCOVERY) {
            Map<String, String> map = null;
            switch (this.out_buf[4]) {
                case 2: {
                    map = LocatorService.parsePeerAtrributes(this.out_buf, size);
                    break;
                }
                case 4: {
                    map = LocatorService.parseIDs(this.out_buf, size);
                    break;
                }
                case 5: {
                    map = LocatorService.parseIDs(this.out_buf, size);
                }
            }
            LocatorService.traceDiscoveryPacket(false, packetTypes[this.out_buf[4]], map, addr, port);
        }
        return true;
    }

    private static Map<String, String> parsePeerAtrributes(byte[] data, int size) throws UnsupportedEncodingException {
        HashMap<String, String> map = new HashMap<String, String>();
        String s = new String(data, 8, size - 8, "UTF-8");
        int l = s.length();
        int i = 0;
        while (i < l) {
            int i0 = i;
            while (i < l && s.charAt(i) != '=' && s.charAt(i) != '\u0000') {
                ++i;
            }
            int i1 = i;
            if (i >= l || s.charAt(i) == '=') {
                // empty if block
            }
            int i2 = ++i;
            while (i < l && s.charAt(i) != '\u0000') {
                ++i;
            }
            int i3 = i;
            if (i < l && s.charAt(i) == '\u0000') {
                ++i;
            }
            String key = s.substring(i0, i1);
            String val = s.substring(i2, i3);
            map.put(key, val);
        }
        return map;
    }

    private static Map<String, String> parseIDs(byte[] data, int size) throws UnsupportedEncodingException {
        int cnt = 0;
        HashMap<String, String> map = new HashMap<String, String>();
        String s = new String(data, 8, size - 8, "UTF-8");
        int l = s.length();
        int i = 0;
        while (i < l) {
            int i0 = i;
            while (i < l && s.charAt(i) != '\u0000') {
                ++i;
            }
            if (i > i0) {
                String id = s.substring(i0, i);
                map.put(Integer.toString(cnt++), id);
            }
            while (i < l && s.charAt(i) == '\u0000') {
                ++i;
            }
        }
        return map;
    }

    private void sendPeersRequest(InetAddress addr, int port) {
        this.out_buf[4] = 1;
        for (SubNet subnet : this.subnets) {
            this.sendDatagramPacket(subnet, 8, addr, port);
        }
    }

    private void sendPeerInfo(IPeer peer, InetAddress addr, int port) {
        if (peer instanceof UserDefPeer) {
            return;
        }
        Map<String, String> attrs = peer.getAttributes();
        InetAddress peer_addr = this.getInetAddress(attrs.get("Host"));
        if (peer_addr == null) {
            return;
        }
        if (attrs.get("Port") == null) {
            return;
        }
        this.out_buf[4] = 2;
        int i = 8;
        for (SubNet subnet : this.subnets) {
            if (peer instanceof RemotePeer) {
                if (this.socket.getLocalPort() != 1534) {
                    return;
                }
                if (!subnet.address.equals(this.loopback_addr) && !subnet.address.equals(peer_addr)) continue;
            }
            if (!subnet.address.equals(this.loopback_addr) && !subnet.contains(peer_addr)) continue;
            if (i == 8) {
                StringBuffer sb = new StringBuffer(this.out_buf.length);
                for (String key : attrs.keySet()) {
                    sb.append(key);
                    sb.append('=');
                    sb.append(attrs.get(key));
                    sb.append('\u0000');
                }
                byte[] bt = this.getUTF8Bytes(sb.toString());
                if (i + bt.length > this.out_buf.length) {
                    return;
                }
                System.arraycopy(bt, 0, this.out_buf, i, bt.length);
                i += bt.length;
            }
            if (!this.sendDatagramPacket(subnet, i, addr, port)) continue;
            subnet.send_all_ok = true;
        }
    }

    private void sendEmptyPacket(InetAddress addr, int port) {
        this.out_buf[4] = 4;
        for (SubNet subnet : this.subnets) {
            if (subnet.send_all_ok) continue;
            this.sendDatagramPacket(subnet, 8, addr, port);
        }
    }

    private void sendAll(InetAddress addr, int port, Slave sl, long time) {
        for (SubNet subnet : this.subnets) {
            subnet.send_all_ok = false;
        }
        for (IPeer peer : peers.values()) {
            this.sendPeerInfo(peer, addr, port);
        }
        if (addr != null && sl != null && sl.last_req_slaves_time + 60000L >= time) {
            this.sendSlavesInfo(addr, port, time);
        }
        this.sendEmptyPacket(addr, port);
    }

    private void sendSlavesRequest(SubNet subnet, InetAddress addr, int port) {
        this.out_buf[4] = 3;
        this.sendDatagramPacket(subnet, 8, addr, port);
    }

    private void sendSlaveInfo(Slave x, long time) {
        int ttl = (int)(x.last_packet_time + 60000L - time);
        if (ttl <= 0) {
            return;
        }
        this.out_buf[4] = 4;
        for (SubNet subnet : this.subnets) {
            if (!subnet.contains(x.address)) continue;
            int i = 8;
            String s = String.valueOf(ttl) + ":" + x.port + ":" + x.address.getHostAddress();
            byte[] bt = this.getUTF8Bytes(s);
            System.arraycopy(bt, 0, this.out_buf, i, bt.length);
            i += bt.length;
            this.out_buf[i++] = 0;
            for (Slave y : this.slaves) {
                if (!subnet.contains(y.address) || y.last_req_slaves_time + 60000L < time) continue;
                this.sendDatagramPacket(subnet, i, y.address, y.port);
            }
        }
    }

    private void sendSlavesInfo(InetAddress addr, int port, long time) {
        this.out_buf[4] = 4;
        for (SubNet subnet : this.subnets) {
            if (!subnet.contains(addr)) continue;
            int i = 8;
            for (Slave x : this.slaves) {
                int ttl = (int)(x.last_packet_time + 60000L - time);
                if (ttl <= 0 || x.port == port && x.address.equals(addr) || !subnet.address.equals(this.loopback_addr) && !subnet.contains(x.address)) continue;
                subnet.send_all_ok = true;
                String s = String.valueOf(ttl) + ":" + x.port + ":" + x.address.getHostAddress();
                byte[] bt = this.getUTF8Bytes(s);
                if (i > 8 && i + bt.length >= 1452) {
                    this.sendDatagramPacket(subnet, i, addr, port);
                    i = 8;
                }
                System.arraycopy(bt, 0, this.out_buf, i, bt.length);
                i += bt.length;
                this.out_buf[i++] = 0;
            }
            if (i <= 8) continue;
            this.sendDatagramPacket(subnet, i, addr, port);
        }
    }

    private boolean isRemote(InetAddress address, int port) {
        if (port != this.socket.getLocalPort()) {
            return true;
        }
        for (SubNet s : this.subnets) {
            if (!s.address.equals(address)) continue;
            return false;
        }
        return true;
    }

    private void handleDatagramPacket(InputPacket p) {
        try {
            long time = System.currentTimeMillis();
            byte[] buf = p.getData();
            int len = p.getLength();
            if (len < 8) {
                return;
            }
            if (buf[0] != 84) {
                return;
            }
            if (buf[1] != 67) {
                return;
            }
            if (buf[2] != 70) {
                return;
            }
            if (buf[3] != 50) {
                return;
            }
            int remote_port = p.getPort();
            InetAddress remote_address = p.getAddress();
            if (this.isRemote(remote_address, remote_port)) {
                if (buf[4] == 5) {
                    this.handlePeerRemovedPacket(p, remote_port == 1534 && remote_address.isLoopbackAddress());
                } else {
                    Slave sl = null;
                    if (remote_port != 1534) {
                        sl = this.addSlave(remote_address, remote_port, time);
                    }
                    switch (buf[4]) {
                        case 2: {
                            this.handlePeerInfoPacket(p);
                            break;
                        }
                        case 1: {
                            this.handleReqInfoPacket(p, sl, time);
                            break;
                        }
                        case 4: {
                            this.handleSlavesInfoPacket(p, time);
                            break;
                        }
                        case 3: {
                            this.handleReqSlavesPacket(p, sl, time);
                        }
                    }
                    for (SubNet subnet : this.subnets) {
                        if (!subnet.contains(remote_address)) continue;
                        long delay = 20000L;
                        if (remote_port != 1534) {
                            delay = 40000L;
                        } else if (!subnet.address.equals(remote_address)) {
                            delay = 30000L;
                        }
                        if (subnet.last_slaves_req_time + delay <= time) {
                            this.sendSlavesRequest(subnet, remote_address, remote_port);
                            subnet.last_slaves_req_time = time;
                        }
                        if (remote_port != 1534 || !subnet.address.equals(remote_address)) continue;
                        this.last_master_packet_time = time;
                    }
                }
            }
        }
        catch (Throwable x) {
            this.log("Invalid datagram packet received from " + p.getAddress() + "/" + p.getPort(), x);
        }
    }

    private void handlePeerInfoPacket(InputPacket p) {
        try {
            String id;
            Map<String, String> map = LocatorService.parsePeerAtrributes(p.getData(), p.getLength());
            if (TRACE_DISCOVERY) {
                LocatorService.traceDiscoveryPacket(true, "CONF_PEER_INFO", map, p);
            }
            if ((id = map.get("ID")) == null) {
                throw new Exception("Invalid peer info: no ID");
            }
            boolean ok = true;
            String host = map.get("Host");
            if (host != null) {
                ok = false;
                InetAddress peer_addr = this.getInetAddress(host);
                if (peer_addr != null) {
                    for (SubNet subnet : this.subnets) {
                        if (!subnet.contains(peer_addr)) continue;
                        ok = true;
                        break;
                    }
                }
            }
            if (ok) {
                IPeer peer = peers.get(id);
                if (peer instanceof RemotePeer) {
                    ((RemotePeer)peer).updateAttributes(map);
                } else if (peer == null) {
                    new RemotePeer(map);
                }
            }
        }
        catch (Exception x) {
            this.log("Invalid datagram packet received from " + p.getAddress() + "/" + p.getPort(), x);
        }
    }

    private void handleReqInfoPacket(InputPacket p, Slave sl, long time) {
        if (TRACE_DISCOVERY) {
            LocatorService.traceDiscoveryPacket(true, "CONF_REQ_INFO", null, p);
        }
        this.sendAll(p.getAddress(), p.getPort(), sl, time);
    }

    private void handleSlavesInfoPacket(InputPacket p, long time_now) {
        try {
            Map<String, String> map = LocatorService.parseIDs(p.getData(), p.getLength());
            if (TRACE_DISCOVERY) {
                LocatorService.traceDiscoveryPacket(true, "CONF_SLAVES_INFO", map, p);
            }
            for (String s : map.values()) {
                long time_val;
                InetAddress addr;
                int i = 0;
                int l = s.length();
                int time0 = i;
                while (i < l && s.charAt(i) != ':' && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int time1 = i;
                if (i >= l || s.charAt(i) == ':') {
                    // empty if block
                }
                int port0 = ++i;
                while (i < l && s.charAt(i) != ':' && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int port1 = i;
                if (i >= l || s.charAt(i) == ':') {
                    // empty if block
                }
                int host0 = ++i;
                while (i < l && s.charAt(i) != '\u0000') {
                    ++i;
                }
                int host1 = i;
                int port = Integer.parseInt(s.substring(port0, port1));
                String timestamp = s.substring(time0, time1);
                String host = s.substring(host0, host1);
                if (port == 1534 || (addr = this.getInetAddress(host)) == null) continue;
                long delta = 1800000L;
                long l2 = time_val = timestamp.length() > 0 ? Long.parseLong(timestamp) : time_now;
                if (time_val < 3600000L) {
                    time_val = time_now + time_val - 60000L;
                } else if (time_val < time_now / 1000L + 50000000L) {
                    time_val *= 1000L;
                }
                if (time_val < time_now - delta || time_val > time_now + delta) {
                    SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                    String msg = "Invalid slave info timestamp: " + timestamp + " -> " + fmt.format(new Date(time_val));
                    this.log("Invalid datagram packet received from " + p.getAddress() + "/" + p.getPort(), new Exception(msg));
                    time_val = time_now - 30000L;
                }
                this.addSlave(addr, port, time_val);
            }
        }
        catch (Exception x) {
            this.log("Invalid datagram packet received from " + p.getAddress() + "/" + p.getPort(), x);
        }
    }

    private void handleReqSlavesPacket(InputPacket p, Slave sl, long time) {
        if (TRACE_DISCOVERY) {
            LocatorService.traceDiscoveryPacket(true, "CONF_REQ_SLAVES", null, p);
        }
        if (sl != null) {
            sl.last_req_slaves_time = time;
        }
        this.sendSlavesInfo(p.getAddress(), p.getPort(), time);
    }

    private void handlePeerRemovedPacket(InputPacket p, boolean master_exited) {
        try {
            Map<String, String> map = LocatorService.parseIDs(p.getData(), p.getLength());
            if (TRACE_DISCOVERY) {
                LocatorService.traceDiscoveryPacket(true, "CONF_PEERS_REMOVED", map, p);
            }
            for (String id : map.values()) {
                IPeer peer = peers.get(id);
                if (!(peer instanceof RemotePeer)) continue;
                ((RemotePeer)peer).dispose();
            }
            if (master_exited) {
                Protocol.invokeLater(500L, new Runnable(){

                    @Override
                    public void run() {
                        if (LocatorService.this.socket.getLocalPort() == 1534) {
                            return;
                        }
                        try {
                            DatagramSocket s0 = LocatorService.this.socket;
                            LocatorService.this.socket = LocatorService.createSocket(false);
                            if (TRACE_DISCOVERY) {
                                LoggingUtil.trace("Became the master agent (bound to port " + LocatorService.this.socket.getLocalPort() + ")");
                            }
                            s0.close();
                        }
                        catch (Throwable throwable) {}
                    }
                });
            }
        }
        catch (Exception x) {
            this.log("Invalid datagram packet received from " + p.getAddress() + "/" + p.getPort(), x);
        }
    }

    public static LocatorService getLocator() {
        return locator;
    }

    @Override
    public String getName() {
        return "Locator";
    }

    @Override
    public Map<String, IPeer> getPeers() {
        assert (Protocol.isDispatchThread());
        return peers;
    }

    @Override
    public IToken redirect(String peer_id, ILocator.DoneRedirect done) {
        throw new Error("Channel redirect cannot be done on local peer");
    }

    @Override
    public IToken redirect(Map<String, String> peer, ILocator.DoneRedirect done) {
        throw new Error("Channel redirect cannot be done on local peer");
    }

    @Override
    public IToken sync(ILocator.DoneSync done) {
        throw new Error("Channel sync cannot be done on local peer");
    }

    @Override
    public IToken getAgentID(ILocator.DoneGetAgentID done) {
        throw new Error("Channel get agent ID cannot be done on local peer");
    }

    @Override
    public void addListener(ILocator.LocatorListener listener) {
        assert (listener != null);
        assert (Protocol.isDispatchThread());
        listeners.add(listener);
    }

    @Override
    public void removeListener(ILocator.LocatorListener listener) {
        assert (Protocol.isDispatchThread());
        listeners.remove(listener);
    }

    private static void traceDiscoveryPacket(boolean received, String type, Map<String, String> attrs, InetAddress addr, int port) {
        assert (TRACE_DISCOVERY);
        StringBuilder str = new StringBuilder(String.valueOf(type) + (received ? " received from " : " sent to ") + addr + "/" + port);
        if (attrs != null) {
            for (Map.Entry<String, String> entry : attrs.entrySet()) {
                str.append("\n\t" + entry.getKey() + '=' + entry.getValue());
            }
        }
        LoggingUtil.trace(str.toString());
    }

    private static void traceDiscoveryPacket(boolean received, String type, Map<String, String> attrs, InputPacket packet) {
        LocatorService.traceDiscoveryPacket(received, type, attrs, packet.getAddress(), packet.getPort());
    }

    static /* synthetic */ HashMap access$3() {
        return addr_cache;
    }

    static /* synthetic */ boolean access$4() {
        return addr_request;
    }

    static /* synthetic */ void access$5(boolean bl) {
        addr_request = bl;
    }

    static /* synthetic */ byte[] access$7(LocatorService locatorService) {
        return locatorService.inp_buf;
    }

    private static class AddressCacheItem {
        final String host;
        InetAddress address;
        long time_stamp;
        boolean used;

        AddressCacheItem(String host) {
            this.host = host;
        }
    }

    private static class InputPacket {
        final DatagramPacket p;

        InputPacket(DatagramPacket p) {
            this.p = p;
        }

        DatagramPacket getPacket() {
            return this.p;
        }

        int getLength() {
            return this.p.getLength();
        }

        byte[] getData() {
            return this.p.getData();
        }

        int getPort() {
            return this.p.getPort();
        }

        InetAddress getAddress() {
            return this.p.getAddress();
        }

        public String toString() {
            return "[address=" + this.p.getAddress().toString() + ",port=" + this.p.getPort() + ",data=\"" + new String(this.p.getData(), 0, this.p.getLength()) + "\"]";
        }
    }

    private static class Slave {
        final InetAddress address;
        final int port;
        long last_packet_time;
        long last_req_slaves_time;

        Slave(InetAddress address, int port) {
            this.address = address;
            this.port = port;
        }

        public String toString() {
            return String.valueOf(this.address.getHostAddress()) + "/" + this.port;
        }
    }

    private static class SubNet {
        final int prefix_length;
        final InetAddress address;
        final InetAddress broadcast;
        long last_slaves_req_time;
        boolean send_all_ok;

        SubNet(int prefix_length, InetAddress address, InetAddress broadcast) {
            this.prefix_length = prefix_length;
            this.address = address;
            this.broadcast = broadcast;
        }

        boolean contains(InetAddress addr) {
            int n;
            byte[] a2;
            if (addr == null || this.address == null) {
                return false;
            }
            byte[] a1 = addr.getAddress();
            if (a1.length != (a2 = this.address.getAddress()).length) {
                return false;
            }
            int i = 0;
            int l = this.prefix_length <= a1.length * 8 ? this.prefix_length : a1.length * 8;
            while (i + 8 <= l) {
                n = i / 8;
                if (a1[n] != a2[n]) {
                    return false;
                }
                i += 8;
            }
            while (i < l) {
                n = i / 8;
                int m = 1 << 7 - i % 8;
                if ((a1[n] & m) != (a2[n] & m)) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SubNet)) {
                return false;
            }
            SubNet x = (SubNet)o;
            return this.prefix_length == x.prefix_length && this.broadcast.equals(x.broadcast) && this.address.equals(x.address);
        }

        public int hashCode() {
            return this.address.hashCode();
        }

        public String toString() {
            return String.valueOf(this.address.getHostAddress()) + "/" + this.prefix_length;
        }
    }
}

