/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.search;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.te.core.interfaces.IPropertyChangeProvider;
import org.eclipse.tcf.te.ui.interfaces.ISchedulableEvent;
import org.eclipse.tcf.te.ui.search.QuickFilterPopup;
import org.eclipse.tcf.te.ui.search.TablePatternFilter;

public class QuickFilter
extends TablePatternFilter
implements PropertyChangeListener {
    private TreeViewer viewer;
    private TreePath root;
    private boolean global;

    public QuickFilter(TreeViewer viewer, TreePath root) {
        super((ILabelProvider)viewer.getLabelProvider());
        this.viewer = viewer;
        this.root = root;
        this.addPropertyChangeListener(this);
    }

    public void showFilterPopup(boolean global) {
        this.global = global;
        if (!this.isFiltering()) {
            this.viewer.addFilter((ViewerFilter)this);
        }
        QuickFilterPopup popup = new QuickFilterPopup(this.viewer, this);
        Point location = this.computePopupLocation();
        popup.open();
        popup.getShell().setLocation(location);
    }

    private Point computePopupLocation() {
        Point location = null;
        if (!this.global) {
            TreeItem[] items = this.viewer.getTree().getSelection();
            if (items != null && items.length > 0) {
                TreeItem item;
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    item = treeItemArray[n2];
                    this.viewer.getTree().showItem(item);
                    ++n2;
                }
                item = items[0];
                Rectangle bounds = item.getBounds();
                location = new Point(bounds.x, bounds.y - bounds.height);
            } else {
                location = new Point(0, -this.viewer.getTree().getItemHeight());
            }
        } else {
            location = new Point(0, -this.viewer.getTree().getItemHeight());
        }
        location = this.viewer.getTree().toDisplay(location);
        return location;
    }

    void adjustPopup(Shell popshell) {
        if (!this.global) {
            Point location = this.computePopupLocation();
            Point shellLocation = popshell.getLocation();
            if (shellLocation != null && !shellLocation.equals((Object)location)) {
                popshell.setLocation(location);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object element = this.root.getLastSegment();
        Object object = element = element == null ? this.viewer.getInput() : element;
        if (element != null) {
            IPropertyChangeProvider provider = this.getPropertyChangeProvider(element);
            if (provider != null) {
                provider.firePropertyChange((PropertyChangeEvent)new QuickFilterEvent(this.viewer, element, evt.getPropertyName(), evt.getOldValue(), evt.getNewValue()));
            } else {
                this.viewer.refresh(element, true);
            }
        }
    }

    private IPropertyChangeProvider getPropertyChangeProvider(Object element) {
        IPropertyChangeProvider provider = null;
        if (element instanceof IPropertyChangeProvider) {
            provider = (IPropertyChangeProvider)element;
        }
        if (provider == null && element instanceof IAdaptable) {
            provider = (IPropertyChangeProvider)((IAdaptable)element).getAdapter(IPropertyChangeProvider.class);
        }
        if (provider == null && element != null) {
            provider = (IPropertyChangeProvider)Platform.getAdapterManager().getAdapter(element, IPropertyChangeProvider.class);
        }
        return provider;
    }

    public void resetViewer() {
        this.viewer.removeFilter((ViewerFilter)this);
        Map filters = (Map)this.viewer.getData("quick.filter");
        if (filters != null) {
            filters.remove(this.root);
        }
        this.setPattern(null);
    }

    private boolean isFiltering() {
        ViewerFilter[] filters = this.viewer.getFilters();
        if (filters != null) {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (filter == this) {
                    return this.matcher != null;
                }
                ++n2;
            }
        }
        return false;
    }

    @Override
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        Assert.isNotNull((Object)parentElement);
        return !this.shouldSelect(parentElement) || super.select(viewer, parentElement, element);
    }

    private boolean shouldSelect(Object parentElement) {
        TreePath rootElement = parentElement instanceof TreePath ? this.root : (this.root.getSegmentCount() == 0 ? this.viewer.getInput() : this.root.getLastSegment());
        return parentElement.equals(rootElement);
    }

    public boolean isFiltering(TreePath path) {
        return this.isFiltering() && this.matcher != null && this.root.equals((Object)path);
    }

    private static class QuickFilterEvent
    extends PropertyChangeEvent
    implements ISchedulableEvent {
        private static final long serialVersionUID = 1L;
        private static long last_enqueue;
        private static final long MAXIMUM_DELAY = 300L;
        private TreeViewer viewer;

        public QuickFilterEvent(TreeViewer viewer, Object source, String propertyName, Object oldValue, Object newValue) {
            super(source, propertyName, oldValue, newValue);
            this.viewer = viewer;
        }

        @Override
        public synchronized void eventQueued() {
            last_enqueue = System.currentTimeMillis();
        }

        @Override
        public boolean isSchedulable() {
            return System.currentTimeMillis() - last_enqueue > 300L;
        }

        @Override
        public boolean isApplicable(TreeViewer viewer) {
            return this.viewer == viewer;
        }
    }
}

