/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.tcf.te.ui.controls.validator.RegexVerifyListener;

public class NumberVerifyListener
extends RegexVerifyListener {
    protected static final String NUMBER_REGEX = "([0-9]*)";
    private int min = 0;
    private int max = Integer.MAX_VALUE;

    public NumberVerifyListener() {
        this(-1, -1);
    }

    public NumberVerifyListener(int min, int max) {
        this(0, NUMBER_REGEX, min, max);
    }

    public NumberVerifyListener(int attributes, String regEx, int min, int max) {
        super(attributes, regEx);
        min = min >= 0 ? min : 0;
        max = max >= 0 ? max : Integer.MAX_VALUE;
        this.min = Math.min(min, max);
        this.max = Math.max(min, max);
    }

    @Override
    public void verifyText(VerifyEvent e) {
        super.verifyText(e);
        String fullText = this.getFullText(e);
        if (e.doit && fullText != null && fullText.length() > 0 && !fullText.equalsIgnoreCase("0x")) {
            try {
                int value = Integer.decode(fullText);
                if (value < this.min || value > this.max) {
                    e.doit = false;
                }
            }
            catch (Exception exception) {
                e.doit = false;
            }
        }
    }
}

