/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.core.internal.channelmanager.steps;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.stepper.StepperAttributeUtil;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.tcf.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapService;
import org.eclipse.tcf.te.tcf.core.steps.AbstractPeerStep;

public class ApplyPathMapsStep
extends AbstractPeerStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)monitor);
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (channel == null || channel.getState() != 1) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "Channel to target not available or closed."));
        }
    }

    public void execute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor, ICallback callback) {
        boolean applyPathMaps;
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)data);
        Assert.isNotNull((Object)fullQualifiedId);
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)callback);
        IChannel channel = (IChannel)StepperAttributeUtil.getProperty((String)"org.eclipse.tcf.te.tcf.locator.channel", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        Assert.isNotNull((Object)channel);
        IPeer peer = this.getActivePeerContext(context, data, fullQualifiedId);
        Assert.isNotNull((Object)peer);
        boolean bl = applyPathMaps = !StepperAttributeUtil.getBooleanProperty((String)"channel.noPathMap", (IFullQualifiedId)fullQualifiedId, (IPropertiesContainer)data);
        if (applyPathMaps) {
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
            IPathMapService service = (IPathMapService)ServiceManager.getInstance().getService((Object)peer, IPathMapService.class);
            if (service != null) {
                service.applyPathMap(channel, true, false, callback);
            } else {
                this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
            }
        } else {
            this.callback(data, fullQualifiedId, callback, Status.OK_STATUS, null);
        }
    }
}

