/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.remote.core.operation;

import java.io.OutputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.te.tcf.remote.core.TCFFileStore;
import org.eclipse.tcf.te.tcf.remote.core.operation.PeerInfo;
import org.eclipse.tcf.te.tcf.remote.core.operation.TCFFileStoreOperation;
import org.eclipse.tcf.util.TCFFileOutputStream;

public class TCFOperationOpenOutputStream
extends TCFFileStoreOperation<OutputStream> {
    private final boolean fAppend;

    public TCFOperationOpenOutputStream(TCFFileStore filestore, boolean append) {
        super(filestore);
        this.fAppend = append;
    }

    public boolean isAppend() {
        return this.fAppend;
    }

    @Override
    protected void doExecute() {
        this.getFileSystem(new PeerInfo.DoneGetFileSystem(){

            @Override
            public void done(IFileSystem fileSystem, IStatus status) {
                if (TCFOperationOpenOutputStream.this.shallAbort(status)) {
                    return;
                }
                int flags = 10;
                fileSystem.open(TCFOperationOpenOutputStream.this.getPath(), flags |= TCFOperationOpenOutputStream.this.isAppend() ? 4 : 16, null, new IFileSystem.DoneOpen(){

                    public void doneOpen(IToken token, IFileSystem.FileSystemException error, IFileSystem.IFileHandle handle) {
                        if (TCFOperationOpenOutputStream.this.shallAbort((Throwable)error)) {
                            return;
                        }
                        TCFOperationOpenOutputStream.this.setResult(new TCFFileOutputStream(handle));
                    }
                });
            }
        });
    }
}

