/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import java.math.BigInteger;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenCountUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IHasChildrenUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ILabelUpdate;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerInputUpdate;
import org.eclipse.tcf.debug.ui.ITCFStackFrame;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFFunctionRef;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.ui.ColorCache;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenHoverExpressions;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenLocalVariables;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenRegisters;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelProxy;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IExpressions;
import org.eclipse.tcf.services.ILineNumbers;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IStackTrace;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;

public class TCFNodeStackFrame
extends TCFNode
implements ITCFStackFrame {
    private int frame_no;
    private boolean trace_limit;
    private final boolean emulated;
    private final TCFChildrenRegisters children_regs;
    private final TCFChildrenLocalVariables children_vars;
    private final TCFChildrenExpressions children_exps;
    private final TCFChildrenHoverExpressions children_hover_exps;
    private final TCFNode.TCFData<IStackTrace.StackTraceContext> stack_trace_context;
    private final TCFNode.TCFData<TCFSourceRef> line_info;
    private final TCFNode.TCFData<TCFFunctionRef> func_info;
    private final TCFNode.TCFData<BigInteger> address;

    TCFNodeStackFrame(final TCFNodeExecContext parent, final String id, final boolean emulated) {
        super(parent, id);
        this.emulated = emulated;
        this.children_regs = new TCFChildrenRegisters(this);
        this.children_vars = new TCFChildrenLocalVariables(this);
        this.children_exps = new TCFChildrenExpressions(this);
        this.children_hover_exps = new TCFChildrenHoverExpressions(this);
        this.stack_trace_context = new TCFNode.TCFData<IStackTrace.StackTraceContext>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!$assertionsDisabled && this.command != null) {
                    throw new AssertionError();
                }
                TCFChildrenStackTrace stack_trace_cache = parent.getStackTrace();
                if (!stack_trace_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                if (emulated) {
                    this.set(null, null, null);
                    return true;
                }
                TCFDataCache<TCFContextState> parent_state_cache = parent.getState();
                if (!parent_state_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                TCFContextState parent_state_data = (TCFContextState)parent_state_cache.getData();
                if (parent_state_data == null || !parent_state_data.is_suspended) {
                    this.set(null, null, null);
                    return true;
                }
                if (TCFNodeStackFrame.this.frame_no < 0) {
                    this.set(null, null, null);
                    return true;
                }
                IStackTrace st = (IStackTrace)TCFNodeStackFrame.this.launch.getService(IStackTrace.class);
                if (st == null) {
                    if (!$assertionsDisabled && TCFNodeStackFrame.this.frame_no != 0) {
                        throw new AssertionError();
                    }
                    this.set(null, null, null);
                    return true;
                }
                this.command = st.getContext(new String[]{id}, new IStackTrace.DoneGetContext(){

                    public void doneGetContext(IToken token, Exception error, IStackTrace.StackTraceContext[] context) {
                        if (context != null && context.length == 1) {
                            (this).TCFNodeStackFrame.this.model.getContextMap().put(id, context[0]);
                        }
                        this.set(token, error, context == null || context.length == 0 ? null : context[0]);
                    }
                });
                return false;
            }
        };
        this.line_info = new TCFNode.TCFData<TCFSourceRef>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeStackFrame.this.stack_trace_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IStackTrace.StackTraceContext ctx = (IStackTrace.StackTraceContext)TCFNodeStackFrame.this.stack_trace_context.getData();
                if (ctx == null) {
                    this.set(null, TCFNodeStackFrame.this.stack_trace_context.getError(), null);
                    return true;
                }
                TCFDataCache<TCFNodeExecContext> mem_node_cache = parent.getMemoryNode();
                if (!mem_node_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                if (mem_node_cache.getError() != null || mem_node_cache.getData() == null) {
                    this.set(null, mem_node_cache.getError(), null);
                    return true;
                }
                TCFNodeExecContext mem_node = (TCFNodeExecContext)mem_node_cache.getData();
                ILineNumbers.CodeArea area = ctx.getCodeArea();
                if (area != null) {
                    IMemory.MemoryContext mem_ctx_data = null;
                    if (mem_node != null) {
                        TCFDataCache<IMemory.MemoryContext> mem_ctx_cache = mem_node.getMemoryContext();
                        if (!mem_ctx_cache.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        mem_ctx_data = (IMemory.MemoryContext)mem_ctx_cache.getData();
                    }
                    TCFSourceRef ref_data = new TCFSourceRef();
                    if (mem_ctx_data != null) {
                        ref_data.context_id = mem_ctx_data.getID();
                        ref_data.address_size = mem_ctx_data.getAddressSize();
                    }
                    ref_data.area = area;
                    this.set(null, null, ref_data);
                } else {
                    TCFDataCache<TCFSourceRef> info_cache;
                    if (!TCFNodeStackFrame.this.address.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    BigInteger n = (BigInteger)TCFNodeStackFrame.this.address.getData();
                    if (n == null) {
                        this.set(null, TCFNodeStackFrame.this.address.getError(), null);
                        return true;
                    }
                    if (!$assertionsDisabled && !parent.getStackTrace().isValid()) {
                        throw new AssertionError();
                    }
                    if (TCFNodeStackFrame.this.frame_no > 0) {
                        n = n.subtract(BigInteger.valueOf(1L));
                    }
                    if ((info_cache = mem_node.getLineInfo(n)) == null) {
                        this.set(null, null, null);
                        return true;
                    }
                    if (!info_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, info_cache.getError(), (TCFSourceRef)info_cache.getData());
                }
                return true;
            }
        };
        this.func_info = new TCFNode.TCFData<TCFFunctionRef>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeStackFrame.this.stack_trace_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IStackTrace.StackTraceContext ctx = (IStackTrace.StackTraceContext)TCFNodeStackFrame.this.stack_trace_context.getData();
                if (ctx == null) {
                    this.set(null, TCFNodeStackFrame.this.stack_trace_context.getError(), null);
                    return true;
                }
                TCFDataCache<TCFNodeExecContext> mem_node_cache = parent.getMemoryNode();
                if (!mem_node_cache.validate((Runnable)((Object)this))) {
                    return false;
                }
                if (mem_node_cache.getError() != null || mem_node_cache.getData() == null) {
                    this.set(null, mem_node_cache.getError(), null);
                    return true;
                }
                TCFNodeExecContext mem_node = (TCFNodeExecContext)mem_node_cache.getData();
                String func_id = ctx.getFuncID();
                if (func_id != null) {
                    IMemory.MemoryContext mem_ctx_data = null;
                    if (mem_node != null) {
                        TCFDataCache<IMemory.MemoryContext> mem_ctx_cache = mem_node.getMemoryContext();
                        if (!mem_ctx_cache.validate((Runnable)((Object)this))) {
                            return false;
                        }
                        mem_ctx_data = (IMemory.MemoryContext)mem_ctx_cache.getData();
                    }
                    TCFFunctionRef ref = new TCFFunctionRef();
                    if (mem_ctx_data != null) {
                        ref.context_id = mem_ctx_data.getID();
                        ref.address_size = mem_ctx_data.getAddressSize();
                    }
                    ref.symbol_id = func_id;
                    this.set(null, null, ref);
                } else {
                    TCFDataCache<TCFFunctionRef> info_cache;
                    if (!$assertionsDisabled && !parent.getStackTrace().isValid()) {
                        throw new AssertionError();
                    }
                    if (!TCFNodeStackFrame.this.address.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    BigInteger n = (BigInteger)TCFNodeStackFrame.this.address.getData();
                    if (n == null) {
                        this.set(null, TCFNodeStackFrame.this.address.getError(), null);
                        return true;
                    }
                    if (TCFNodeStackFrame.this.frame_no > 0) {
                        n = n.subtract(BigInteger.valueOf(1L));
                    }
                    if ((info_cache = mem_node.getFuncInfo(n)) == null) {
                        this.set(null, null, null);
                        return true;
                    }
                    if (!info_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, info_cache.getError(), (TCFFunctionRef)info_cache.getData());
                }
                return true;
            }
        };
        this.address = new TCFNode.TCFData<BigInteger>((TCFNode)this, this.channel){

            protected boolean startDataRetrieval() {
                if (!TCFNodeStackFrame.this.stack_trace_context.validate((Runnable)((Object)this))) {
                    return false;
                }
                IStackTrace.StackTraceContext ctx = (IStackTrace.StackTraceContext)TCFNodeStackFrame.this.stack_trace_context.getData();
                if (ctx != null) {
                    Number n = ctx.getInstructionAddress();
                    if (n instanceof BigInteger) {
                        this.set(null, null, (BigInteger)n);
                        return true;
                    }
                    if (n != null) {
                        this.set(null, null, JSON.toBigInteger((Number)n));
                        return true;
                    }
                }
                if (!$assertionsDisabled && !parent.getStackTrace().isValid()) {
                    throw new AssertionError();
                }
                if (TCFNodeStackFrame.this.frame_no == 0) {
                    TCFDataCache<BigInteger> addr_cache = parent.getAddress();
                    if (!addr_cache.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    this.set(null, addr_cache.getError(), (BigInteger)addr_cache.getData());
                    return true;
                }
                this.set(null, TCFNodeStackFrame.this.stack_trace_context.getError(), null);
                return true;
            }
        };
    }

    public int getFrameNo() {
        assert (Protocol.isDispatchThread());
        assert (((TCFNodeExecContext)this.parent).getStackTrace().isValid());
        return this.frame_no;
    }

    void setFrameNo(int frame_no) {
        this.frame_no = frame_no;
    }

    void setTraceLimit(boolean trace_limit) {
        this.trace_limit = trace_limit;
    }

    TCFChildren getHoverExpressionCache(String expression) {
        this.children_hover_exps.setExpression(expression);
        return this.children_hover_exps;
    }

    public TCFDataCache<TCFSourceRef> getLineInfo() {
        return this.line_info;
    }

    @Override
    public TCFDataCache<IStackTrace.StackTraceContext> getStackTraceContext() {
        return this.stack_trace_context;
    }

    public TCFDataCache<BigInteger> getAddress() {
        return this.address;
    }

    @Override
    public TCFChildren getRegisters() {
        return this.children_regs;
    }

    public BigInteger getReturnAddress() {
        assert (Protocol.isDispatchThread());
        if (!this.stack_trace_context.isValid()) {
            return null;
        }
        IStackTrace.StackTraceContext ctx = (IStackTrace.StackTraceContext)this.stack_trace_context.getData();
        if (ctx != null) {
            return JSON.toBigInteger((Number)ctx.getReturnAddress());
        }
        return null;
    }

    public boolean isEmulated() {
        return this.emulated;
    }

    boolean isTraceLimit() {
        return this.trace_limit && ((TCFNodeExecContext)this.parent).getViewBottomFrame() == this;
    }

    void riseTraceLimit() {
        ((TCFNodeExecContext)this.parent).riseTraceLimit();
    }

    private TCFChildren getChildren(IPresentationContext ctx) {
        String id = ctx.getId();
        if ("org.eclipse.debug.ui.RegisterView".equals(id)) {
            return this.children_regs;
        }
        if ("org.eclipse.debug.ui.VariableView".equals(id)) {
            return this.children_vars;
        }
        if ("org.eclipse.debug.ui.ExpressionView".equals(id)) {
            return this.children_exps;
        }
        if ("org.eclipse.tcf.debug.ui.expression_hover".equals(id)) {
            return this.children_hover_exps;
        }
        return null;
    }

    @Override
    protected boolean getData(IHasChildrenUpdate result, Runnable done) {
        TCFChildren c = this.getChildren(result.getPresentationContext());
        if (c != null) {
            if (!c.validate(done)) {
                return false;
            }
            result.setHasChilren(c.size() > 0);
        } else {
            result.setHasChilren(false);
        }
        return true;
    }

    @Override
    protected boolean getData(IChildrenCountUpdate result, Runnable done) {
        TCFChildren c = this.getChildren(result.getPresentationContext());
        if (c != null) {
            if (!c.validate(done)) {
                return false;
            }
            result.setChildCount(c.size());
        } else {
            result.setChildCount(0);
        }
        return true;
    }

    @Override
    protected boolean getData(IChildrenUpdate result, Runnable done) {
        TCFChildren children = this.getChildren(result.getPresentationContext());
        if (children == null) {
            return true;
        }
        return children.getData(result, done);
    }

    @Override
    protected boolean getData(ILabelUpdate result, Runnable done) {
        TCFChildrenStackTrace stack_trace_cache = ((TCFNodeExecContext)this.parent).getStackTrace();
        if (!stack_trace_cache.validate(done)) {
            return false;
        }
        if (((Map)stack_trace_cache.getData()).get(this.id) == null) {
            result.setLabel("", 0);
        } else if (this.isTraceLimit()) {
            result.setLabel("<select to see more frames>", 0);
        } else {
            TCFFunctionRef ref;
            int n;
            int n2;
            Object[] objectArray;
            boolean show_arg_names = this.model.getShowFunctionArgNames();
            boolean show_arg_values = this.model.getShowFunctionArgValues();
            TCFDataCache<TCFContextState> state_cache = ((TCFNodeExecContext)this.parent).getState();
            TCFDataCache<TCFNodeExecContext> mem_cache = ((TCFNodeExecContext)this.parent).getMemoryNode();
            TCFDataCache<IExpressions.Expression> pending = null;
            if (!state_cache.validate()) {
                pending = state_cache;
            }
            if (!mem_cache.validate()) {
                pending = mem_cache;
            }
            if (!this.stack_trace_context.validate()) {
                pending = this.stack_trace_context;
            }
            if (!this.address.validate()) {
                pending = this.address;
            }
            if (!this.line_info.validate()) {
                pending = this.line_info;
            }
            if (!this.func_info.validate()) {
                pending = this.func_info;
            }
            if (show_arg_names || show_arg_values) {
                if (!this.children_vars.validate()) {
                    pending = this.children_vars;
                } else {
                    TCFNode[] tCFNodeArray = this.children_vars.toArray();
                    int n3 = tCFNodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TCFNode n5 = tCFNodeArray[n4];
                        TCFNodeExpression e = (TCFNodeExpression)n5;
                        if (!e.getVariable().validate()) {
                            pending = e.getVariable();
                        }
                        ++n4;
                    }
                }
            }
            if (pending != null) {
                pending.wait(done);
                return false;
            }
            Throwable error = state_cache.getError();
            if (error == null) {
                error = stack_trace_cache.getError();
            }
            if (error == null) {
                error = this.stack_trace_context.getError();
            }
            if (error == null) {
                error = this.address.getError();
            }
            if (error == null) {
                error = this.line_info.getError();
            }
            BigInteger addr = (BigInteger)this.address.getData();
            TCFSourceRef sref = (TCFSourceRef)this.line_info.getData();
            TCFContextState state = (TCFContextState)state_cache.getData();
            StringBuffer bf = new StringBuffer();
            if (addr != null) {
                bf.append(this.makeHexAddrString(sref != null ? sref.address_size : 0, addr));
                TCFNodeExecContext mem_node = (TCFNodeExecContext)mem_cache.getData();
                if (mem_node != null) {
                    TCFDataCache<TCFNodeExecContext.MemoryRegion[]> map_dc = mem_node.getMemoryMap();
                    if (!map_dc.validate(done)) {
                        return false;
                    }
                    TCFNodeExecContext.MemoryRegion[] map = (TCFNodeExecContext.MemoryRegion[])map_dc.getData();
                    if (map != null) {
                        BigInteger n6 = addr;
                        assert (((TCFNodeExecContext)this.parent).getStackTrace().isValid());
                        if (this.frame_no > 0) {
                            n6 = n6.subtract(BigInteger.valueOf(1L));
                        }
                        objectArray = map;
                        n2 = map.length;
                        n = 0;
                        while (n < n2) {
                            TCFNodeExecContext.MemoryRegion r = objectArray[n];
                            String fnm = r.region.getFileName();
                            if (fnm != null && r.contains(n6)) {
                                int x = (fnm = fnm.replace('\\', '/')).lastIndexOf(47);
                                if (x >= 0) {
                                    fnm = fnm.substring(x + 1);
                                }
                                bf.append(" [");
                                bf.append(fnm);
                                bf.append("]");
                                break;
                            }
                            ++n;
                        }
                    }
                }
            }
            if ((ref = (TCFFunctionRef)this.func_info.getData()) != null && ref.symbol_id != null) {
                TCFDataCache<ISymbols.Symbol> sym_cache = this.model.getSymbolInfoCache(ref.symbol_id);
                if (!sym_cache.validate(done)) {
                    return false;
                }
                ISymbols.Symbol sym_data = (ISymbols.Symbol)sym_cache.getData();
                if (sym_data != null && sym_data.getName() != null) {
                    bf.append(" ");
                    bf.append(sym_data.getName());
                    bf.append('(');
                    if (show_arg_names || show_arg_values) {
                        if (this.children_vars.getError() != null) {
                            bf.append('?');
                        } else {
                            int cnt = 0;
                            objectArray = this.children_vars.toArray();
                            n2 = objectArray.length;
                            n = 0;
                            while (n < n2) {
                                Object s;
                                Object n7 = objectArray[n];
                                ISymbols.Symbol sym = null;
                                TCFNodeExpression expr_node = (TCFNodeExpression)n7;
                                IExpressions.Expression expr_props = (IExpressions.Expression)expr_node.getVariable().getData();
                                if (expr_props != null) {
                                    s = this.model.getSymbolInfoCache(expr_props.getSymbolID());
                                    if (!s.validate(done)) {
                                        return false;
                                    }
                                    sym = (ISymbols.Symbol)s.getData();
                                }
                                if (sym != null && sym.getFlag(1)) {
                                    if (cnt > 0) {
                                        bf.append(',');
                                    }
                                    if (show_arg_names) {
                                        String name = sym.getName();
                                        if (name == null) {
                                            name = "?";
                                        }
                                        bf.append(name);
                                        if (show_arg_values) {
                                            bf.append('=');
                                        }
                                    }
                                    if (show_arg_values) {
                                        s = expr_node.getValueText(false, done);
                                        if (s == null) {
                                            return false;
                                        }
                                        bf.append((String)(((String)s).length() == 0 ? "?" : s));
                                    }
                                    ++cnt;
                                }
                                ++n;
                            }
                        }
                    }
                    bf.append(')');
                }
            }
            if (sref != null && sref.area != null && sref.area.file != null) {
                bf.append(": ");
                int l = sref.area.file.length();
                if (l > 32) {
                    bf.append("...");
                    bf.append(sref.area.file.substring(l - 32));
                } else {
                    bf.append(sref.area.file);
                }
                bf.append(", line ");
                bf.append(sref.area.start_line);
            }
            if (error != null) {
                if (state == null || state.is_suspended) {
                    result.setForeground(ColorCache.rgb_error, 0);
                    if (bf.length() > 0) {
                        bf.append(": ");
                    }
                    bf.append(TCFModel.getErrorMessage(error, false));
                } else {
                    result.setLabel("...", 0);
                }
            }
            if (bf.length() == 0) {
                bf.append("...");
            }
            result.setLabel(bf.toString(), 0);
            String image_name = null;
            image_name = state == null ? "icons/full/obj16/stckframe_obj" : (state.is_suspended ? "icons/full/obj16/stckframe_obj" : (state.isReversing() ? "icons/stckframe_reversing" : "icons/full/obj16/stckframe_running_obj"));
            result.setImageDescriptor(ImageCache.getImageDescriptor(image_name), 0);
        }
        return true;
    }

    @Override
    protected boolean getData(IViewerInputUpdate result, Runnable done) {
        result.setInputElement((Object)this);
        String id = result.getPresentationContext().getId();
        if ("org.eclipse.debug.ui.RegisterView".equals(id) || "org.eclipse.debug.ui.ExpressionView".equals(id)) {
            TCFNodeExecContext exe = (TCFNodeExecContext)this.parent;
            TCFChildrenStackTrace stack_trace_cache = exe.getStackTrace();
            if (!stack_trace_cache.validate(done)) {
                return false;
            }
            if (stack_trace_cache.getTopFrame() == this) {
                result.setInputElement((Object)exe);
            }
        } else if ("org.eclipse.debug.ui.ModuleView".equals(id)) {
            TCFDataCache<TCFNodeExecContext> mem = this.model.searchMemoryContext(this);
            if (mem == null) {
                return true;
            }
            if (!mem.validate(done)) {
                return false;
            }
            if (mem.getData() == null) {
                return true;
            }
            result.setInputElement(mem.getData());
        }
        return true;
    }

    private String makeHexAddrString(int addr_size, BigInteger n) {
        String s;
        int sz = (addr_size != 0 ? addr_size : 4) * 2;
        int l = sz - (s = n.toString(16)).length();
        if (l < 0) {
            l = 0;
        }
        if (l > 16) {
            l = 16;
        }
        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
    }

    void postAllChangedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            int flags = 0;
            String view_id = p.getPresentationContext().getId();
            if ("org.eclipse.debug.ui.DebugView".equals(view_id) && (this.launch.getContextActionsCount(this.parent.id) == 0 || !this.model.getDelayStackUpdateUtilLastStep())) {
                flags |= 0x800;
            }
            if (this.getChildren(p.getPresentationContext()) != null && p.getInput() == this) {
                flags |= 0x400;
            }
            if (flags == 0) continue;
            p.addDelta(this, flags);
        }
    }

    private void postStateChangedDelta() {
        for (TCFModelProxy p : this.model.getModelProxies()) {
            String id = p.getPresentationContext().getId();
            if (!"org.eclipse.debug.ui.DebugView".equals(id)) continue;
            p.addDelta(this, 2048);
        }
    }

    void onExpressionAddedOrRemoved() {
        this.children_exps.cancel();
    }

    void onSourceMappingChange() {
        this.line_info.reset();
        this.postStateChangedDelta();
    }

    void onSuspended(boolean func_call) {
        this.stack_trace_context.cancel();
        this.line_info.cancel();
        this.func_info.cancel();
        this.address.cancel();
        if (!func_call) {
            this.children_regs.reset();
        }
        this.children_regs.onSuspended(func_call);
        this.children_vars.onSuspended(func_call);
        this.children_exps.onSuspended(func_call);
        this.children_hover_exps.onSuspended(func_call);
    }

    void onMemoryMapChanged() {
        this.stack_trace_context.cancel();
        this.line_info.reset();
        this.func_info.reset();
        this.address.cancel();
        this.children_vars.onMemoryMapChanged();
        this.children_exps.onMemoryMapChanged();
        this.children_hover_exps.onMemoryMapChanged();
        if (!((TCFNodeExecContext)this.parent).getStackTrace().isValid() || this.frame_no > 0) {
            this.children_regs.onRegistersChanged();
        }
        this.postAllChangedDelta();
    }

    void onMemoryChanged() {
        this.stack_trace_context.cancel();
        this.line_info.cancel();
        this.func_info.cancel();
        this.address.cancel();
        this.children_vars.onMemoryChanged();
        this.children_exps.onMemoryChanged();
        this.children_hover_exps.onMemoryChanged();
        this.postStateChangedDelta();
    }

    void onRegistersChanged() {
        this.children_regs.onRegistersChanged();
        this.postAllChangedDelta();
    }

    void onRegisterValueChanged() {
        this.stack_trace_context.cancel();
        this.line_info.cancel();
        this.func_info.cancel();
        this.address.cancel();
        if (this.frame_no > 0) {
            this.children_regs.onRegistersChanged();
        }
        this.children_vars.onRegisterValueChanged();
        this.children_exps.onRegisterValueChanged();
        this.children_hover_exps.onRegisterValueChanged();
        this.postStateChangedDelta();
    }

    @Override
    public int compareTo(TCFNode n) {
        if (n instanceof TCFNodeStackFrame) {
            TCFNodeStackFrame f = (TCFNodeStackFrame)n;
            if (this.frame_no < f.frame_no) {
                return -1;
            }
            if (this.frame_no > f.frame_no) {
                return 1;
            }
        }
        return this.id.compareTo(n.id);
    }
}

