/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.ui.editor.tree.columns;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IPendingOperationNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;

public class CommandLineLabelProvider
extends LabelProvider {
    public String getText(Object element) {
        if (element instanceof IRuntimeModel || element instanceof IPendingOperationNode) {
            return "";
        }
        if (element instanceof IProcessContextNode) {
            final IProcessContextNode node = (IProcessContextNode)element;
            final AtomicReference cmd = new AtomicReference();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    String[] cmdline = (String[])node.getProperty("cmdline");
                    if (cmdline != null) {
                        cmd.set(CommandLineLabelProvider.makeString(cmdline));
                    }
                }
            };
            Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0);
            Protocol.invokeAndWait((Runnable)runnable);
            if (cmd.get() != null) {
                return (String)cmd.get();
            }
        }
        return "";
    }

    public static final String makeString(String[] cmdline) {
        Assert.isNotNull((Object)cmdline);
        StringBuilder buffer = new StringBuilder();
        String[] stringArray = cmdline;
        int n = cmdline.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            buffer.append(arg.contains(" ") ? "\"" + arg + "\"" : arg);
            buffer.append(" ");
            ++n2;
        }
        return buffer.toString();
    }
}

