/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.rse;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.services.files.RemoteFileException;
import org.eclipse.rse.ui.subsystems.StandardConnectorService;
import org.eclipse.tcf.core.TransientPeer;
import org.eclipse.tcf.internal.rse.ITCFSessionProvider;
import org.eclipse.tcf.internal.rse.Messages;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IFileSystem;
import org.eclipse.tcf.services.ILocator;
import org.eclipse.tcf.services.IStreams;
import org.eclipse.tcf.services.ISysMonitor;

public class TCFConnectorService
extends StandardConnectorService
implements ITCFSessionProvider {
    public static final String PROPERTY_SET_NAME = "TCF Connection Settings";
    public static final String PROPERTY_TRANSPORT_NAME = "Transport.Name";
    public static final String PROPERTY_LOGIN_REQUIRED = "Login.Required";
    public static final String PROPERTY_PWD_REQUIRED = "Pwd.Required";
    public static final String PROPERTY_LOGIN_PROMPT = "Login.Prompt";
    public static final String PROPERTY_PASSWORD_PROMPT = "Password.Prompt";
    public static final String PROPERTY_COMMAND_PROMPT = "Command.Prompt";
    private IChannel channel;
    private Throwable channel_error;
    private final List<Runnable> wait_list = new ArrayList<Runnable>();
    private boolean poll_timer_started;
    private boolean streams_subscribed = false;
    private boolean streams_connecting = false;
    private final HashSet<String> stream_ids = new HashSet();
    private final IStreams.StreamsListener streams_listener = new IStreams.StreamsListener(){

        public void created(String stream_type, String stream_id, String context_id) {
            if (TCFConnectorService.this.streams_connecting) {
                TCFConnectorService.this.stream_ids.add(stream_id);
            } else {
                TCFConnectorService.this.getService(IStreams.class).disconnect(stream_id, new IStreams.DoneDisconnect(){

                    public void doneDisconnect(IToken token, Exception error) {
                        if (error != null) {
                            TCFConnectorService.this.channel.terminate((Throwable)error);
                        }
                    }
                });
            }
        }

        public void disposed(String stream_type, String stream_id) {
            TCFConnectorService.this.stream_ids.remove(stream_id);
        }
    };

    public TCFConnectorService(IHost host, int port) {
        super(Messages.TCFConnectorService_Name, Messages.TCFConnectorService_Description, host, port);
        this.getTCFPropertySet();
    }

    public IPropertySet getTCFPropertySet() {
        IPropertySet tcfSet = this.getPropertySet(PROPERTY_SET_NAME);
        if (tcfSet == null) {
            tcfSet = this.createPropertySet(PROPERTY_SET_NAME, Messages.PropertySet_Description);
            tcfSet.addProperty(PROPERTY_TRANSPORT_NAME, "TCP", PropertyType.getEnumPropertyType((String[])new String[]{"TCP", "SSL"}));
            tcfSet.addProperty(PROPERTY_LOGIN_REQUIRED, "false", PropertyType.getEnumPropertyType((String[])new String[]{"true", "false"}));
            tcfSet.addProperty(PROPERTY_PWD_REQUIRED, "false", PropertyType.getEnumPropertyType((String[])new String[]{"true", "false"}));
            tcfSet.addProperty(PROPERTY_LOGIN_PROMPT, "ogin: ", PropertyType.getStringPropertyType());
            tcfSet.addProperty(PROPERTY_PASSWORD_PROMPT, "assword: ", PropertyType.getStringPropertyType());
            tcfSet.addProperty(PROPERTY_COMMAND_PROMPT, "#", PropertyType.getStringPropertyType());
        }
        return tcfSet;
    }

    public final boolean requiresPassword() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalConnect(final IProgressMonitor monitor) throws Exception {
        assert (!Protocol.isDispatchThread());
        final Exception[] res = new Exception[1];
        this.fireCommunicationsEvent(1);
        monitor.beginTask("Connecting " + this.getHostName(), 1);
        Exception[] exceptionArray = res;
        synchronized (res) {
            Protocol.invokeLater((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public void run() {
                    try {
                        if (TCFConnectorService.this.connectTCFChannel(res, monitor)) return;
                        TCFConnectorService.this.add_to_wait_list(this);
                        return;
                    }
                    catch (Throwable x) {
                        Exception[] exceptionArray = res;
                        synchronized (res) {
                            res[0] = x instanceof Exception ? (Exception)x : new Exception(x);
                            res.notify();
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return;
                        }
                    }
                }
            });
            res.wait();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (res[0] != null) {
                throw res[0];
            }
            monitor.done();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalDisconnect(final IProgressMonitor monitor) throws Exception {
        assert (!Protocol.isDispatchThread());
        final Exception[] res = new Exception[1];
        this.fireCommunicationsEvent(3);
        monitor.beginTask("Disconnecting " + this.getHostName(), 1);
        try {
            try {
                Exception[] exceptionArray = res;
                synchronized (res) {
                    Protocol.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (!TCFConnectorService.this.disconnectTCFChannel(res, monitor)) {
                                TCFConnectorService.this.add_to_wait_list(this);
                            }
                        }
                    });
                    res.wait();
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    if (res[0] != null) {
                        throw res[0];
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RemoteFileException("Error creating Terminal", e);
            }
        }
        finally {
            monitor.done();
        }
        {
            return;
        }
    }

    public boolean isConnected() {
        final boolean[] res = new boolean[1];
        try {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    res[0] = TCFConnectorService.this.channel != null && TCFConnectorService.this.channel.getState() == 1;
                }
            });
        }
        catch (IllegalStateException e) {
            res[0] = false;
        }
        return res[0];
    }

    private void add_to_wait_list(Runnable cb) {
        this.wait_list.add(cb);
        if (this.poll_timer_started) {
            return;
        }
        Protocol.invokeLater((long)1000L, (Runnable)new Runnable(){

            @Override
            public void run() {
                TCFConnectorService.this.poll_timer_started = false;
                TCFConnectorService.this.run_wait_list();
            }
        });
        this.poll_timer_started = true;
    }

    private void run_wait_list() {
        if (this.wait_list.isEmpty()) {
            return;
        }
        Runnable[] r = this.wait_list.toArray(new Runnable[this.wait_list.size()]);
        this.wait_list.clear();
        int i = 0;
        while (i < r.length) {
            r[i].run();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connectTCFChannel(Exception[] res, IProgressMonitor monitor) {
        if (this.channel != null) {
            switch (this.channel.getState()) {
                case 1: 
                case 2: {
                    Exception[] exceptionArray = res;
                    synchronized (res) {
                        res[0] = this.channel_error instanceof Exception ? (Exception)this.channel_error : (this.channel_error != null ? new Exception(this.channel_error) : null);
                        res.notify();
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return true;
                    }
                }
            }
        }
        if (monitor.isCanceled()) {
            Exception[] exceptionArray = res;
            synchronized (res) {
                res[0] = new Exception("Canceled");
                if (this.channel != null) {
                    this.channel.terminate((Throwable)res[0]);
                }
                res.notify();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return true;
            }
        }
        if (this.channel == null) {
            String host = this.getHostName().toLowerCase();
            int port = this.getConnectPort();
            if (port <= 0) {
                port = 1534;
            }
            IPeer peer = null;
            String port_str = Integer.toString(port);
            String transport = this.getTCFPropertySet().getPropertyValue(PROPERTY_TRANSPORT_NAME);
            ILocator locator = Protocol.getLocator();
            for (IPeer p : locator.getPeers().values()) {
                Map attrs = p.getAttributes();
                if (!transport.equals(attrs.get("TransportName")) || !host.equalsIgnoreCase((String)attrs.get("Host")) || !port_str.equals(attrs.get("Port"))) continue;
                peer = p;
                break;
            }
            if (peer == null) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put("ID", "RSE:" + host + ":" + port_str);
                attrs.put("Name", this.getName());
                attrs.put("TransportName", transport);
                attrs.put("Host", host);
                attrs.put("Port", port_str);
                peer = new TransientPeer(attrs);
            }
            this.channel = peer.openChannel();
            this.channel.addChannelListener(new IChannel.IChannelListener(){

                public void onChannelOpened() {
                    if (!$assertionsDisabled && TCFConnectorService.this.channel == null) {
                        throw new AssertionError();
                    }
                    TCFConnectorService.this.run_wait_list();
                }

                public void congestionLevel(int level) {
                }

                public void onChannelClosed(Throwable error) {
                    if (!$assertionsDisabled && TCFConnectorService.this.channel == null) {
                        throw new AssertionError();
                    }
                    TCFConnectorService.this.channel.removeChannelListener((IChannel.IChannelListener)this);
                    TCFConnectorService.this.channel_error = error;
                    if (TCFConnectorService.this.wait_list.isEmpty()) {
                        TCFConnectorService.this.fireCommunicationsEvent(5);
                    } else {
                        TCFConnectorService.this.run_wait_list();
                    }
                    TCFConnectorService.this.channel = null;
                    TCFConnectorService.this.channel_error = null;
                    TCFConnectorService.this.streams_subscribed = false;
                    TCFConnectorService.this.stream_ids.clear();
                }
            });
            assert (this.channel.getState() == 0);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean disconnectTCFChannel(Exception[] res, IProgressMonitor monitor) {
        if (this.channel == null || this.channel.getState() == 2) {
            Exception[] exceptionArray = res;
            synchronized (res) {
                res[0] = null;
                res.notify();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return true;
            }
        }
        if (monitor.isCanceled()) {
            Exception[] exceptionArray = res;
            synchronized (res) {
                res[0] = new Exception("Canceled");
                res.notify();
                // ** MonitorExit[var3_4] (shouldn't be in output)
                return true;
            }
        }
        if (this.channel.getState() == 1) {
            this.channel.close();
        }
        return false;
    }

    public <V extends IService> V getService(Class<V> service_interface) {
        if (this.channel == null || this.channel.getState() != 1) {
            throw new Error("Not connected");
        }
        IService m = this.channel.getRemoteService(service_interface);
        if (m == null) {
            throw new Error("Remote peer does not support " + service_interface.getName() + " service");
        }
        return (V)m;
    }

    public ISysMonitor getSysMonitorService() {
        return this.getService(ISysMonitor.class);
    }

    public IFileSystem getFileSystemService() {
        return this.getService(IFileSystem.class);
    }

    @Override
    public IChannel getChannel() {
        return this.channel;
    }

    @Override
    public String getSessionHostName() {
        String hostName = "";
        IHost host = this.getHost();
        if (host != null) {
            hostName = host.getHostName();
        }
        return hostName;
    }

    @Override
    public String getSessionUserId() {
        return this.getUserId();
    }

    @Override
    public String getSessionPassword() {
        String password = "";
        SystemSignonInformation ssi = this.getSignonInformation();
        if (ssi != null) {
            password = ssi.getPassword();
        }
        return password;
    }

    @Override
    public void onStreamsConnecting() {
        if (!this.streams_subscribed) {
            this.streams_subscribed = true;
            IStreams streams = this.getService(IStreams.class);
            if (streams != null) {
                streams.subscribe("Terminals", this.streams_listener, new IStreams.DoneSubscribe(){

                    public void doneSubscribe(IToken token, Exception error) {
                        if (error != null) {
                            TCFConnectorService.this.channel.terminate((Throwable)error);
                        }
                    }
                });
            }
        }
        this.streams_connecting = true;
    }

    @Override
    public void onStreamsID(String id) {
        this.stream_ids.remove(id);
    }

    @Override
    public void onStreamsConnected() {
        this.streams_connecting = false;
        for (String id : this.stream_ids) {
            this.getService(IStreams.class).disconnect(id, new IStreams.DoneDisconnect(){

                public void doneDisconnect(IToken token, Exception error) {
                    if (error != null) {
                        TCFConnectorService.this.channel.terminate((Throwable)error);
                    }
                }
            });
        }
    }
}

