/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.tcf.core.ErrorReport;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupDirector;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFMemoryRegion;
import org.eclipse.tcf.internal.debug.model.TCFSymFileRef;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.commands.MemoryMapItemDialog;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildren;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeLaunch;
import org.eclipse.tcf.internal.services.local.LocatorService;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IMemory;
import org.eclipse.tcf.services.IMemoryMap;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class MemoryMapWidget {
    private static final int TABLE_WIDTH = 800;
    private static final int TABLE_HEIGHT = 300;
    private static final int[] COL_WIDTH = new int[]{300, 100, 80, 50, 140, 140};
    private static final String[] column_names = new String[]{"File", "Address", "Size", "Flags", "File offset/section", "Context query"};
    private final Display display;
    private final Preferences prefs;
    private TCFModel model;
    private IChannel channel;
    private TCFNode selection;
    private Combo ctx_text;
    private Tree map_table;
    private TreeViewer table_viewer;
    private Runnable update_map_buttons;
    private final Map<String, ArrayList<IMemoryMap.MemoryRegion>> org_maps = new HashMap<String, ArrayList<IMemoryMap.MemoryRegion>>();
    private final Map<String, ArrayList<IMemoryMap.MemoryRegion>> cur_maps = new HashMap<String, ArrayList<IMemoryMap.MemoryRegion>>();
    private final ArrayList<IMemoryMap.MemoryRegion> target_map = new ArrayList();
    private final HashMap<String, TCFNodeExecContext> target_map_nodes = new HashMap();
    private TCFNodeExecContext selected_mem_map_node;
    private IMemory.MemoryContext mem_ctx;
    private ILaunchConfiguration cfg;
    private final HashSet<IMemoryMap.MemoryRegion> loaded_regions = new HashSet();
    private final HashMap<String, String> path_map = new HashMap();
    private String selected_mem_map_id;
    private final ArrayList<ModifyListener> modify_listeners = new ArrayList();
    private boolean editing;
    private boolean changed;
    private boolean disposed;
    private final ITreeContentProvider content_provider = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IMemoryMap.MemoryRegion) {
                IMemoryMap.MemoryRegion region = (IMemoryMap.MemoryRegion)element;
                return region instanceof RegionList;
            }
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        /*
         * Unable to fully structure code
         */
        public Object[] getElements(Object input) {
            all = new ArrayList<E>();
            lst = (ArrayList)MemoryMapWidget.access$0(MemoryMapWidget.this).get(input);
            if (lst != null) {
                all.addAll(lst);
            }
            all.addAll(MemoryMapWidget.access$1(MemoryMapWidget.this));
            roots = new ArrayList<RegionList>();
            removed = new HashSet<IMemoryMap.MemoryRegion>();
            i = 0;
            while (i < all.size()) {
                block6: {
                    region = (IMemoryMap.MemoryRegion)all.get(i);
                    if (removed.contains(region)) break block6;
                    file_name = region.getFileName();
                    if (file_name == null) ** GOTO lbl-1000
                    children = new ArrayList<IMemoryMap.MemoryRegion>();
                    j = i + 1;
                    while (j < all.size()) {
                        child = (IMemoryMap.MemoryRegion)all.get(j);
                        if (!region.equals(child) && file_name.equals(child.getFileName())) {
                            children.add(child);
                            removed.add(child);
                        }
                        ++j;
                    }
                    if (children.size() > 0) {
                        removed.add(region);
                        children.add(0, region);
                        props = new HashMap<String, Object>();
                        props.put("FileName", file_name);
                        root = new RegionList(props);
                        root.children = children;
                        roots.add(root);
                    } else lbl-1000:
                    // 2 sources

                    {
                        roots.add((RegionList)region);
                    }
                }
                ++i;
            }
            return roots.toArray();
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof RegionList) {
                RegionList region = (RegionList)((Object)parent);
                return region.children.toArray();
            }
            return null;
        }
    };
    private final MapLabelProvider label_provider = new MapLabelProvider();
    private final IMemoryMap.MemoryMapListener listener = new IMemoryMap.MemoryMapListener(){

        public void changed(final String context_id) {
            MemoryMapWidget.this.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (MemoryMapWidget.this.disposed) {
                        return;
                    }
                    if (MemoryMapWidget.this.mem_ctx == null) {
                        return;
                    }
                    if (MemoryMapWidget.this.mem_ctx.getID() == null) {
                        return;
                    }
                    if (!MemoryMapWidget.this.mem_ctx.getID().equals(context_id)) {
                        return;
                    }
                    if (MemoryMapWidget.this.editing) {
                        MemoryMapWidget.this.changed = true;
                    } else if (MemoryMapWidget.this.cfg != null) {
                        MemoryMapWidget.this.loadData(MemoryMapWidget.this.cfg);
                    }
                }
            });
        }
    };

    public MemoryMapWidget(Composite composite, TCFNode node, Preferences prefs) {
        this.display = composite.getDisplay();
        this.prefs = prefs;
        this.setTCFNode(node);
        this.createContextText(composite);
        this.createMemoryMapTable(composite);
    }

    public MemoryMapWidget(Composite composite, TCFNode node) {
        this(composite, node, null);
    }

    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        if (this.prefs != null) {
            try {
                this.prefs.flush();
            }
            catch (BackingStoreException x) {
                Activator.log(x);
            }
        }
        if (this.channel != null) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    IMemoryMap svc = (IMemoryMap)MemoryMapWidget.this.channel.getRemoteService(IMemoryMap.class);
                    if (svc != null) {
                        svc.removeListener(MemoryMapWidget.this.listener);
                    }
                }
            });
        }
        this.model = null;
        this.channel = null;
        this.selection = null;
    }

    public boolean setTCFNode(TCFNode node) {
        if (node == this.selection) {
            return false;
        }
        if (this.channel != null) {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    IMemoryMap svc = (IMemoryMap)MemoryMapWidget.this.channel.getRemoteService(IMemoryMap.class);
                    if (svc != null) {
                        svc.removeListener(MemoryMapWidget.this.listener);
                    }
                }
            });
        }
        if (node != null) {
            this.model = node.getModel();
            this.channel = node.getChannel();
            this.selection = node;
            if (this.channel != null) {
                Protocol.invokeAndWait((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        IMemoryMap svc = (IMemoryMap)MemoryMapWidget.this.channel.getRemoteService(IMemoryMap.class);
                        if (svc != null) {
                            svc.addListener(MemoryMapWidget.this.listener);
                        }
                    }
                });
            }
        } else {
            this.model = null;
            this.channel = null;
            this.selection = null;
        }
        return true;
    }

    public String getMemoryMapID() {
        return this.selected_mem_map_id;
    }

    private void createContextText(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        Label props_label = new Label(composite, 64);
        props_label.setLayoutData((Object)new GridData(256));
        props_label.setFont(font);
        props_label.setText("&Debug context:");
        this.ctx_text = new Combo(composite, 2060);
        this.ctx_text.setLayoutData((Object)new GridData(768));
        this.ctx_text.setFont(font);
        this.ctx_text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MemoryMapWidget.this.selected_mem_map_id = MemoryMapWidget.this.ctx_text.getText();
                MemoryMapWidget.this.selected_mem_map_node = (TCFNodeExecContext)MemoryMapWidget.this.target_map_nodes.get(MemoryMapWidget.this.selected_mem_map_id);
                MemoryMapWidget.this.loadTargetMemoryMap();
                MemoryMapWidget.this.table_viewer.setInput((Object)MemoryMapWidget.this.selected_mem_map_id);
                if (MemoryMapWidget.this.selected_mem_map_id.length() == 0) {
                    MemoryMapWidget.this.selected_mem_map_id = null;
                }
                MemoryMapWidget.this.update_map_buttons.run();
            }
        });
    }

    private void createMemoryMapTable(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.map_table = new Tree(composite, 68356);
        this.map_table.setFont(font);
        this.configureTable(this.map_table);
        this.map_table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                TreeItem item = (TreeItem)e.item;
                final boolean expanded = item.getExpanded();
                final IMemoryMap.MemoryRegion r = (IMemoryMap.MemoryRegion)item.getData();
                if (r == null) {
                    return;
                }
                MemoryMapWidget.this.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (r instanceof RegionList) {
                            MemoryMapWidget.this.table_viewer.setExpandedState((Object)r, !expanded);
                        } else {
                            MemoryMapWidget.this.editRegion(r);
                        }
                    }
                });
            }

            public void widgetSelected(SelectionEvent e) {
                MemoryMapWidget.this.update_map_buttons.run();
            }
        });
        this.table_viewer = new TreeViewer(this.map_table);
        this.table_viewer.setUseHashlookup(true);
        this.table_viewer.setColumnProperties(column_names);
        this.table_viewer.setContentProvider((IContentProvider)this.content_provider);
        this.table_viewer.setLabelProvider((IBaseLabelProvider)this.label_provider);
        this.map_table.pack();
        this.createMapButtons(composite);
    }

    protected String getColumnText(int column) {
        if (column < column_names.length && column >= 0) {
            return column_names[column];
        }
        return "";
    }

    protected void configureTable(Tree table) {
        GridData data = new GridData(1808);
        data.widthHint = 800;
        data.heightHint = 300;
        table.setLayoutData((Object)data);
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < COL_WIDTH.length) {
            final TreeColumn col = new TreeColumn(table, i);
            col.setResizable(true);
            col.setAlignment(16384);
            col.setText(this.getColumnText(i));
            int w = COL_WIDTH[i];
            if (this.prefs != null) {
                final String id = "w" + i;
                w = this.prefs.getInt(id, w);
                col.addListener(11, new Listener(){

                    public void handleEvent(Event event) {
                        MemoryMapWidget.this.prefs.putInt(id, col.getWidth());
                    }
                });
            }
            layout.addColumnData((ColumnLayoutData)new ColumnPixelData(w));
            ++i;
        }
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
    }

    protected final TreeViewer getViewer() {
        return this.table_viewer;
    }

    private void createMapButtons(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setFont(font);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(272));
        Menu menu = new Menu((Control)this.map_table);
        SelectionAdapter sel_adapter = null;
        final Button button_add = new Button(composite, 8);
        button_add.setText(" &Add... ");
        GridData gd = new GridData(256);
        PixelConverter converter = new PixelConverter((Control)button_add);
        gd.widthHint = converter.convertHorizontalDLUsToPixels(61);
        button_add.setLayoutData((Object)gd);
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = MemoryMapWidget.this.ctx_text.getText();
                if (id == null || id.length() == 0) {
                    return;
                }
                HashMap<String, Object> props = new HashMap<String, Object>();
                if (new MemoryMapItemDialog(MemoryMapWidget.this.map_table.getShell(), props, true).open() == 0) {
                    props.put("ID", id);
                    props.put("UUID", UUID.randomUUID().toString());
                    ArrayList<TCFMemoryRegion> lst = (ArrayList<TCFMemoryRegion>)MemoryMapWidget.this.cur_maps.get(id);
                    if (lst == null) {
                        lst = new ArrayList<TCFMemoryRegion>();
                        MemoryMapWidget.this.cur_maps.put(id, lst);
                    }
                    lst.add(new TCFMemoryRegion(props));
                    MemoryMapWidget.this.table_viewer.refresh();
                    MemoryMapWidget.this.notifyModifyListeners();
                }
            }
        };
        button_add.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_add = new MenuItem(menu, 8);
        item_add.setText("&Add...");
        item_add.addSelectionListener((SelectionListener)sel_adapter);
        item_add.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ADD"));
        final Button button_edit = new Button(composite, 8);
        button_edit.setText(" E&dit... ");
        button_edit.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMemoryMap.MemoryRegion r = MemoryMapWidget.this.getSelectedRegion();
                if (r == null) {
                    return;
                }
                MemoryMapWidget.this.editRegion(r);
            }
        };
        button_edit.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_edit = new MenuItem(menu, 8);
        item_edit.setText("E&dit...");
        item_edit.addSelectionListener((SelectionListener)sel_adapter);
        final Button button_remove = new Button(composite, 8);
        button_remove.setText(" &Remove ");
        button_remove.setLayoutData((Object)new GridData(256));
        sel_adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String id = MemoryMapWidget.this.ctx_text.getText();
                if (id == null || id.length() == 0) {
                    return;
                }
                IMemoryMap.MemoryRegion r = MemoryMapWidget.this.getSelectedRegion();
                if (r == null) {
                    return;
                }
                ArrayList lst = (ArrayList)MemoryMapWidget.this.cur_maps.get(id);
                if (lst != null && lst.remove(r)) {
                    MemoryMapWidget.this.table_viewer.refresh();
                }
                MemoryMapWidget.this.notifyModifyListeners();
            }
        };
        button_remove.addSelectionListener((SelectionListener)sel_adapter);
        final MenuItem item_remove = new MenuItem(menu, 8);
        item_remove.setText("&Remove");
        item_remove.addSelectionListener((SelectionListener)sel_adapter);
        item_remove.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ETOOL_DELETE"));
        this.map_table.setMenu(menu);
        this.update_map_buttons = new Runnable(){

            @Override
            public void run() {
                IMemoryMap.MemoryRegion r = MemoryMapWidget.this.getSelectedRegion();
                boolean can_edit = r != null && !(r instanceof RegionList);
                boolean can_remove = can_edit && !(r instanceof ForeignRegion);
                button_add.setEnabled(MemoryMapWidget.this.selected_mem_map_id != null);
                button_edit.setEnabled(can_edit);
                button_remove.setEnabled(can_remove);
                item_add.setEnabled(MemoryMapWidget.this.selected_mem_map_id != null);
                item_edit.setEnabled(can_edit);
                item_remove.setEnabled(can_remove);
            }
        };
        this.update_map_buttons.run();
    }

    private IMemoryMap.MemoryRegion getSelectedRegion() {
        return (IMemoryMap.MemoryRegion)((IStructuredSelection)this.table_viewer.getSelection()).getFirstElement();
    }

    private void editRegion(final IMemoryMap.MemoryRegion region) {
        try {
            ArrayList<IMemoryMap.MemoryRegion> lst;
            MemoryMapItemDialog dlg;
            boolean enable_editing;
            this.editing = true;
            String id = this.ctx_text.getText();
            if (id == null || id.length() == 0) {
                return;
            }
            assert (!(region instanceof RegionList));
            final TCFNodeExecContext mem_node = this.selected_mem_map_node;
            HashMap props = region.getProperties();
            boolean bl = enable_editing = !(region instanceof ForeignRegion);
            if (enable_editing) {
                props = new HashMap(props);
            }
            if ((dlg = new MemoryMapItemDialog(this.map_table.getShell(), props, enable_editing){
                boolean symbols_ok;

                @Override
                protected void createStatusFields(Composite parent) {
                    try {
                        String file_info;
                        if (mem_node != null && region != null) {
                            Label label = new Label(parent, 64);
                            label.setLayoutData((Object)new GridData(4, 4, true, false));
                            label.setFont(parent.getFont());
                            if (region instanceof ForeignRegion) {
                                label.setText("The file info was repoted by the target agent: cannot edit");
                            } else if (MemoryMapWidget.this.loaded_regions.contains(region)) {
                                label.setForeground(MemoryMapWidget.this.display.getSystemColor(6));
                                label.setText("The file info was sent to the target agent");
                            } else {
                                label.setForeground(MemoryMapWidget.this.display.getSystemColor(10));
                                label.setText("The file info is not sent to the target agent yet");
                            }
                        }
                        if (mem_node != null && region != null && region.getAddress() != null && (file_info = (String)new TCFTask<String>(MemoryMapWidget.this.channel){

                            public void run() {
                                StringBuilder buf = new StringBuilder();
                                TCFDataCache<TCFSymFileRef> sym_cache = mem_node.getSymFileInfo(JSON.toBigInteger((Number)region.getAddress()));
                                if (sym_cache != null) {
                                    if (!sym_cache.validate((Runnable)((Object)this))) {
                                        return;
                                    }
                                    TCFSymFileRef sym_data = (TCFSymFileRef)sym_cache.getData();
                                    if (sym_data != null) {
                                        if (sym_data.props != null) {
                                            Map map;
                                            String sym_file_name = (String)sym_data.props.get("FileName");
                                            if (sym_file_name != null && !sym_file_name.equals(region.getFileName())) {
                                                buf.append("Symbol file: ");
                                                buf.append(sym_file_name);
                                                symbols_ok = true;
                                            }
                                            if ((map = (Map)sym_data.props.get("FileError")) != null) {
                                                if (buf.length() > 0) {
                                                    buf.append("\n");
                                                }
                                                buf.append("Symbol file error: ");
                                                buf.append(TCFModel.getErrorMessage((Throwable)new ErrorReport("", map), false));
                                            }
                                        } else if (sym_data.error != null) {
                                            buf.append("Symbol file error: ");
                                            buf.append(TCFModel.getErrorMessage(sym_data.error, false));
                                        }
                                    }
                                }
                                this.done(buf.length() > 0 ? buf.toString() : null);
                            }
                        }.get()) != null) {
                            Label label = new Label(parent, 64);
                            label.setLayoutData((Object)new GridData(4, 4, true, false));
                            label.setFont(parent.getFont());
                            label.setText(file_info);
                        }
                        if (!this.symbols_ok && mem_node != null && region != null && region.getFileName() != null) {
                            boolean local_host_peer;
                            String file_name;
                            TCFLaunch launch = MemoryMapWidget.this.model.getLaunch();
                            IStorage mapped = TCFSourceLookupDirector.lookupByTargetPathMap((TCFLaunch)launch, (String)mem_node.getID(), (String)region.getFileName());
                            if (mapped != null && !(file_name = mapped.getFullPath().toOSString()).equals(region.getFileName())) {
                                Label label = new Label(parent, 64);
                                label.setLayoutData((Object)new GridData(4, 4, true, false));
                                label.setFont(parent.getFont());
                                label.setText("Mapped to: " + file_name + "\nMapping can be edited in the Path Map tab of the launch configuration");
                            }
                            if (local_host_peer = ((Boolean)new TCFTask<Boolean>(MemoryMapWidget.this.channel){

                                public void run() {
                                    List peers = MemoryMapWidget.this.channel.getRemotePeerList();
                                    for (IPeer peer : peers) {
                                        if (!LocatorService.isLocalHostPeer((IPeer)peer)) continue;
                                        this.done(true);
                                        return;
                                    }
                                    this.done(false);
                                }
                            }.get()).booleanValue()) {
                                boolean exists;
                                boolean bl = exists = mapped != null && mapped.getFullPath().toFile().exists() || new File(region.getFileName()).exists();
                                if (!exists) {
                                    Label label = new Label(parent, 64);
                                    label.setLayoutData((Object)new GridData(4, 4, true, false));
                                    label.setFont(parent.getFont());
                                    label.setText("The symbol file not found on the local host");
                                    if (!enable_editing) {
                                        Button button_locate = new Button(parent, 72);
                                        button_locate.setText("Locate local copy of the file... ");
                                        GridData layoutData = new GridData(4, 4, true, false);
                                        button_locate.setLayoutData((Object)layoutData);
                                        button_locate.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                            public void widgetSelected(SelectionEvent e) {
                                                MemoryMapWidget.this.locateSymbolFile(region);
                                            }
                                        });
                                    }
                                }
                            }
                        }
                    }
                    catch (Throwable x) {
                        Label label = new Label(parent, 64);
                        label.setLayoutData((Object)new GridData(4, 4, true, false));
                        label.setForeground(MemoryMapWidget.this.display.getSystemColor(3));
                        label.setFont(parent.getFont());
                        String s = "Cannot display region status: " + x.getClass().getName();
                        String m = x.getMessage();
                        if (m != null) {
                            s = String.valueOf(s) + " " + m;
                        }
                        label.setText(s);
                    }
                }
            }).open() == 0 && enable_editing && (lst = this.cur_maps.get(id)) != null) {
                int n = 0;
                while (n < lst.size()) {
                    if (lst.get(n) == region) {
                        lst.set(n, (IMemoryMap.MemoryRegion)new TCFMemoryRegion(props));
                        this.table_viewer.refresh();
                        this.notifyModifyListeners();
                    }
                    ++n;
                }
            }
        }
        finally {
            this.editing = false;
            if (this.changed) {
                this.loadData(this.cfg);
                this.changed = false;
            }
        }
    }

    private void locateSymbolFile(IMemoryMap.MemoryRegion r) {
        FileDialog dialog = new FileDialog(this.map_table.getShell(), 4096);
        IPath workspace_path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        dialog.setFilterPath(workspace_path.toString());
        dialog.setText("Locate Symbol File");
        String symbol_file = dialog.open();
        if (symbol_file != null && new File(symbol_file).exists()) {
            this.path_map.put(r.getFileName(), symbol_file);
        }
    }

    private void readMemoryMapAttribute() {
        this.cur_maps.clear();
        try {
            new TCFTask<Boolean>(){

                public void run() {
                    try {
                        TCFLaunchDelegate.getMemMapsAttribute((Map)MemoryMapWidget.this.cur_maps, (ILaunchConfiguration)MemoryMapWidget.this.cfg);
                        this.done(true);
                    }
                    catch (Exception e) {
                        this.error(e);
                    }
                }
            }.get();
        }
        catch (Exception x) {
            Activator.log("Invalid launch cofiguration attribute", x);
        }
    }

    private void writeMemoryMapAttribute(ILaunchConfigurationWorkingCopy copy) throws Exception {
        String s = null;
        final ArrayList<Map> lst = new ArrayList<Map>();
        for (ArrayList<IMemoryMap.MemoryRegion> x : this.cur_maps.values()) {
            for (IMemoryMap.MemoryRegion r : x) {
                lst.add(r.getProperties());
            }
        }
        if (lst.size() > 0) {
            s = (String)new TCFTask<String>(){

                public void run() {
                    try {
                        this.done(JSON.toJSON((Object)lst));
                    }
                    catch (IOException e) {
                        this.error(e);
                    }
                }
            }.getIO();
        }
        copy.setAttribute("org.eclipse.tcf.debug.MemoryMap", s);
    }

    public void loadData(ILaunchConfiguration cfg) {
        this.cfg = cfg;
        this.cur_maps.clear();
        this.org_maps.clear();
        this.loadTargetMemoryNodes();
        this.readMemoryMapAttribute();
        for (String id : this.cur_maps.keySet()) {
            this.org_maps.put(id, new ArrayList(this.cur_maps.get(id)));
        }
        Object map_id = this.getSelectedMemoryNode();
        HashSet<String> ids = new HashSet<String>(this.target_map_nodes.keySet());
        if (map_id != null) {
            ids.add((String)map_id);
        }
        ids.addAll(this.cur_maps.keySet());
        Object[] arr = ids.toArray(new String[ids.size()]);
        Arrays.sort(arr);
        this.ctx_text.removeAll();
        Object[] objectArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            Object id = objectArray[n2];
            this.ctx_text.add((String)id);
            ++n2;
        }
        if (map_id == null && arr.length > 0) {
            map_id = arr[0];
        }
        if (map_id == null) {
            map_id = "";
        }
        this.ctx_text.setText((String)map_id);
    }

    private String getSelectedMemoryNode() {
        if (this.channel == null || this.channel.getState() != 1) {
            return null;
        }
        try {
            return (String)new TCFTask<String>(this.channel){

                public void run() {
                    TCFDataCache<TCFNodeExecContext> mem_cache = MemoryMapWidget.this.model.searchMemoryContext(MemoryMapWidget.this.selection);
                    if (mem_cache == null) {
                        this.error(new Exception("Context does not provide memory access"));
                        return;
                    }
                    if (!mem_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    if (mem_cache.getError() != null) {
                        this.error(mem_cache.getError());
                        return;
                    }
                    String id = null;
                    TCFNodeExecContext mem_node = (TCFNodeExecContext)mem_cache.getData();
                    if (mem_node != null) {
                        TCFDataCache<TCFNodeExecContext> syms_cache = mem_node.getSymbolsNode();
                        if (!syms_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        TCFNodeExecContext syms_node = (TCFNodeExecContext)syms_cache.getData();
                        if (syms_node != null) {
                            TCFDataCache<IMemory.MemoryContext> mem_ctx = syms_node.getMemoryContext();
                            if (!mem_ctx.validate((Runnable)((Object)this))) {
                                return;
                            }
                            if (mem_ctx.getData() != null) {
                                if (MemoryMapWidget.this.model.getLaunch().isMemoryMapPreloadingSupported()) {
                                    TCFDataCache<String> name_cache = syms_node.getFullName();
                                    if (!name_cache.validate((Runnable)((Object)this))) {
                                        return;
                                    }
                                    id = (String)name_cache.getData();
                                } else {
                                    id = ((IMemory.MemoryContext)mem_ctx.getData()).getName();
                                }
                                if (id == null) {
                                    id = syms_node.getID();
                                }
                            }
                        }
                    }
                    this.done(id);
                }
            }.get();
        }
        catch (Exception x) {
            return null;
        }
    }

    protected TCFLaunch findLaunch() {
        ILaunch[] iLaunchArray = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        int n = iLaunchArray.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunch launch = iLaunchArray[n2];
            if (launch instanceof TCFLaunch && launch.getLaunchConfiguration().equals(this.cfg instanceof ILaunchConfigurationWorkingCopy ? ((ILaunchConfigurationWorkingCopy)this.cfg).getOriginal() : this.cfg)) {
                return (TCFLaunch)launch;
            }
            ++n2;
        }
        return null;
    }

    private void loadTargetMemoryNodes() {
        this.target_map_nodes.clear();
        if (this.channel == null || this.channel.getState() != 1) {
            return;
        }
        try {
            new TCFTask<Boolean>(this.channel){

                public void run() {
                    TCFNodeLaunch n = MemoryMapWidget.this.model.getRootNode();
                    if (!this.collectMemoryNodes(n.getFilteredChildren())) {
                        return;
                    }
                    this.done(true);
                }

                private boolean collectMemoryNodes(TCFChildren children) {
                    if (!children.validate((Runnable)((Object)this))) {
                        return false;
                    }
                    Map m = (Map)children.getData();
                    if (m != null) {
                        for (TCFNode n : m.values()) {
                            if (!(n instanceof TCFNodeExecContext)) continue;
                            TCFNodeExecContext exe = (TCFNodeExecContext)n;
                            if (!this.collectMemoryNodes(exe.getChildren())) {
                                return false;
                            }
                            TCFDataCache<TCFNodeExecContext> syms_cache = exe.getSymbolsNode();
                            if (!syms_cache.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            TCFNodeExecContext syms_node = (TCFNodeExecContext)syms_cache.getData();
                            if (syms_node == null) continue;
                            TCFDataCache<IMemory.MemoryContext> mem_ctx = syms_node.getMemoryContext();
                            if (!mem_ctx.validate((Runnable)((Object)this))) {
                                return false;
                            }
                            if (mem_ctx.getData() == null) continue;
                            String id = null;
                            if (MemoryMapWidget.this.model.getLaunch().isMemoryMapPreloadingSupported()) {
                                TCFDataCache<String> name_cache = syms_node.getFullName();
                                if (!name_cache.validate((Runnable)((Object)this))) {
                                    return false;
                                }
                                id = (String)name_cache.getData();
                            } else {
                                id = ((IMemory.MemoryContext)mem_ctx.getData()).getName();
                            }
                            if (id == null) {
                                id = syms_node.getID();
                            }
                            MemoryMapWidget.this.target_map_nodes.put(id, syms_node);
                        }
                    }
                    return true;
                }
            }.get();
        }
        catch (Exception x) {
            if (this.channel.getState() != 1) {
                return;
            }
            Activator.log("Cannot load target memory context info", x);
        }
    }

    private void loadTargetMemoryMap() {
        this.loaded_regions.clear();
        this.target_map.clear();
        this.mem_ctx = null;
        if (this.channel == null || this.channel.getState() != 1) {
            return;
        }
        try {
            new TCFTask<Boolean>(this.channel){

                public void run() {
                    if (MemoryMapWidget.this.selected_mem_map_node != null && !MemoryMapWidget.this.selected_mem_map_node.isDisposed()) {
                        TCFDataCache<IMemory.MemoryContext> mem_cache = MemoryMapWidget.this.selected_mem_map_node.getMemoryContext();
                        if (!mem_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (mem_cache.getError() != null) {
                            this.error(mem_cache.getError());
                            return;
                        }
                        MemoryMapWidget.this.mem_ctx = (IMemory.MemoryContext)mem_cache.getData();
                        TCFDataCache<TCFNodeExecContext.MemoryRegion[]> map_cache = MemoryMapWidget.this.selected_mem_map_node.getMemoryMap();
                        if (!map_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        if (map_cache.getError() != null) {
                            this.error(map_cache.getError());
                            return;
                        }
                        if (map_cache.getData() != null) {
                            ArrayList map = (ArrayList)MemoryMapWidget.this.cur_maps.get(MemoryMapWidget.this.selected_mem_map_id);
                            TCFNodeExecContext.MemoryRegion[] memoryRegionArray = (TCFNodeExecContext.MemoryRegion[])map_cache.getData();
                            int n = memoryRegionArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TCFNodeExecContext.MemoryRegion m = memoryRegionArray[n2];
                                TCFMemoryRegion region = new TCFMemoryRegion(m.region.getProperties());
                                if (map != null && map.contains(region)) {
                                    MemoryMapWidget.this.loaded_regions.add(region);
                                } else {
                                    MemoryMapWidget.this.target_map.add(new ForeignRegion(m.region.getProperties()));
                                }
                                ++n2;
                            }
                        }
                    }
                    this.done(true);
                }
            }.get();
        }
        catch (Exception x) {
            if (this.channel.getState() != 1) {
                return;
            }
            Activator.log("Cannot load target memory map", x);
        }
    }

    public boolean saveData(ILaunchConfigurationWorkingCopy copy) throws Exception {
        ArrayList<IMemoryMap.MemoryRegion> lst;
        boolean loaded_regions_ok = true;
        if (this.selected_mem_map_id != null && (lst = this.cur_maps.get(this.selected_mem_map_id)) != null) {
            for (IMemoryMap.MemoryRegion r : lst) {
                assert (!(r instanceof ForeignRegion));
                if (this.loaded_regions.contains(r)) continue;
                loaded_regions_ok = false;
                break;
            }
            if (lst.size() == 0) {
                this.cur_maps.remove(this.selected_mem_map_id);
            }
        }
        if (this.path_map.size() > 0) {
            String s = copy.getAttribute("org.eclipse.tcf.debug.PathMap", "");
            ArrayList map = TCFLaunchDelegate.parsePathMapAttribute((String)s);
            for (String fnm : this.path_map.keySet()) {
                LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
                props.put("Source", fnm);
                props.put("Destination", this.path_map.get(fnm));
                TCFLaunchDelegate.PathMapRule rule = new TCFLaunchDelegate.PathMapRule(props);
                if (map.contains(rule)) continue;
                map.add(rule);
            }
            StringBuilder bf = new StringBuilder();
            for (IPathMap.PathMapRule m : map) {
                bf.append(m.toString());
            }
            copy.setAttribute("org.eclipse.tcf.debug.PathMap", bf.toString());
        }
        if (!loaded_regions_ok || !this.org_maps.equals(this.cur_maps) || this.path_map.size() > 0) {
            this.writeMemoryMapAttribute(copy);
            return true;
        }
        return false;
    }

    public void addModifyListener(ModifyListener l) {
        this.modify_listeners.add(l);
    }

    private void notifyModifyListeners() {
        for (ModifyListener l : this.modify_listeners) {
            l.modifyText(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asyncExec(Runnable r) {
        Class<Device> clazz = Device.class;
        synchronized (Device.class) {
            if (this.display.isDisposed()) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            this.display.asyncExec(r);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static class ForeignRegion
    extends TCFMemoryRegion {
        ForeignRegion(Map<String, Object> props) {
            super(props);
        }
    }

    private class MapLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ITableFontProvider {
        private MapLabelProvider() {
        }

        public Image getColumnImage(Object element, int column) {
            return null;
        }

        public String getColumnText(Object element, int column) {
            TCFMemoryRegion r = (TCFMemoryRegion)element;
            if (r instanceof RegionList && column != 0) {
                return "";
            }
            switch (column) {
                case 0: {
                    return r.getFileName();
                }
                case 1: 
                case 2: {
                    int l;
                    BigInteger x;
                    BigInteger bigInteger = x = column == 1 ? r.addr : r.size;
                    if (x == null) {
                        return "";
                    }
                    String s = x.toString(16);
                    int sz = 0;
                    if (MemoryMapWidget.this.mem_ctx != null) {
                        sz = MemoryMapWidget.this.mem_ctx.getAddressSize() * 2;
                    }
                    if ((l = sz - s.length()) < 0) {
                        l = 0;
                    }
                    if (l > 16) {
                        l = 16;
                    }
                    return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
                }
                case 3: {
                    int n = r.getFlags();
                    char[] bf = new char[3];
                    bf[2] = 45;
                    bf[1] = 45;
                    bf[0] = 45;
                    if ((n & 1) != 0) {
                        bf[0] = 114;
                    }
                    if ((n & 2) != 0) {
                        bf[1] = 119;
                    }
                    if ((n & 4) != 0) {
                        bf[2] = 120;
                    }
                    return new String(bf);
                }
                case 4: {
                    Number n = r.getOffset();
                    if (n != null) {
                        BigInteger x = JSON.toBigInteger((Number)n);
                        String s = x.toString(16);
                        int l = 16 - s.length();
                        if (l < 0) {
                            l = 0;
                        }
                        if (l > 16) {
                            l = 16;
                        }
                        return String.valueOf("0x0000000000000000".substring(0, 2 + l)) + s;
                    }
                    String s = r.getSectionName();
                    if (s != null) {
                        return s;
                    }
                    return "";
                }
                case 5: {
                    String s = r.getContextQuery();
                    if (s == null) {
                        s = "";
                    }
                    return s;
                }
            }
            return "";
        }

        public Color getBackground(Object element, int columnIndex) {
            return MemoryMapWidget.this.map_table.getBackground();
        }

        public Color getForeground(Object element, int columnIndex) {
            TCFMemoryRegion region = (TCFMemoryRegion)element;
            if (region instanceof RegionList) {
                return MemoryMapWidget.this.map_table.getForeground();
            }
            if (region instanceof ForeignRegion) {
                return MemoryMapWidget.this.map_table.getForeground();
            }
            if (MemoryMapWidget.this.loaded_regions.contains(region)) {
                return MemoryMapWidget.this.display.getSystemColor(6);
            }
            return MemoryMapWidget.this.display.getSystemColor(10);
        }

        public Font getFont(Object element, int columnIndex) {
            switch (columnIndex) {
                case 1: 
                case 2: 
                case 4: {
                    return JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
                }
            }
            return null;
        }

        public String getText(Object element) {
            return element.toString();
        }
    }

    private static class RegionList
    extends TCFMemoryRegion {
        ArrayList<IMemoryMap.MemoryRegion> children;

        RegionList(Map<String, Object> props) {
            super(props);
        }
    }
}

