/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.extensions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.nls.Messages;
import org.osgi.framework.Bundle;

public class ExecutableExtensionProxy<V> {
    private V instance;
    private final IConfigurationElement element;
    private String id;

    public ExecutableExtensionProxy(IConfigurationElement element) throws CoreException {
        Assert.isNotNull((Object)element);
        this.element = element;
        this.id = element.getAttribute("id");
        if (this.id == null || this.id.trim().length() == 0) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), 0, NLS.bind((String)Messages.Extension_error_missingRequiredAttribute, (Object)"id", (Object)element.getContributor().getName()), null));
        }
        this.instance = null;
    }

    public ExecutableExtensionProxy(String id, V instance) {
        Assert.isNotNull((Object)id);
        Assert.isNotNull(instance);
        this.id = id;
        this.instance = instance;
        this.element = null;
    }

    public String getId() {
        return this.id;
    }

    public IConfigurationElement getConfigurationElement() {
        return this.element;
    }

    public V reset() {
        V oldExtension = this.instance;
        this.instance = null;
        return oldExtension;
    }

    public V getInstance() {
        if (this.instance == null) {
            this.instance = this.newInstance();
        }
        return this.instance;
    }

    public V newInstance() {
        IConfigurationElement element = this.getConfigurationElement();
        Assert.isNotNull((Object)element);
        String attributeName = this.getExecutableExtensionAttributeName();
        Assert.isNotNull((Object)attributeName);
        if (element.getAttribute(attributeName) != null || element.getChildren(attributeName).length > 0) {
            try {
                return (V)element.createExecutableExtension(attributeName);
            }
            catch (Exception e) {
                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), NLS.bind((String)Messages.Extension_error_invalidExtensionPoint, (Object)element.getDeclaringExtension().getUniqueIdentifier()), (Throwable)e));
            }
        }
        return null;
    }

    protected String getExecutableExtensionAttributeName() {
        return "class";
    }

    public boolean equals(Object obj) {
        if (obj instanceof ExecutableExtensionProxy) {
            return this.getId().equals(((ExecutableExtensionProxy)obj).getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }
}

