/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.notifications.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.tcf.te.runtime.events.NotifyEvent;
import org.eclipse.tcf.te.ui.notifications.activator.UIPlugin;
import org.eclipse.tcf.te.ui.notifications.internal.popup.PopupNotificationSink;

public class NotificationService {
    final PopupNotificationSink sink = new PopupNotificationSink();

    NotificationService() {
    }

    public static NotificationService getInstance() {
        return LazyInstance.instance;
    }

    public void notify(NotifyEvent event) {
        Assert.isNotNull((Object)event);
        this.notify(new NotifyEvent[]{event});
    }

    public void notify(final NotifyEvent[] events) {
        Assert.isNotNull((Object)events);
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                NotificationService.this.sink.notify(events);
            }

            public void handleException(Throwable e) {
                UIPlugin.getDefault().getLog().log((IStatus)new Status(2, UIPlugin.getUniqueIdentifier(), "Sink failed: " + NotificationService.this.sink.getClass(), e));
            }
        });
    }

    private static class LazyInstance {
        public static NotificationService instance = new NotificationService();

        private LazyInstance() {
        }
    }
}

