/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.ui.internal.celleditor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.tcf.te.tcf.filesystem.core.interfaces.runtime.IFSTreeNode;
import org.eclipse.tcf.te.tcf.filesystem.ui.nls.Messages;

public class FSCellValidator
implements ICellEditorValidator {
    public static final String UNIX_FILENAME_REGEX = "[^/]+";
    public static final String WIN_FILENAME_REGEX = "[^(\\?|\\\\|/|:|\\*|<|>|\\|)]+";
    private TreeViewer viewer;

    public FSCellValidator(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public String isValid(Object value) {
        String formatRegex;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object element = selection.getFirstElement();
        Assert.isTrue((boolean)(element instanceof IFSTreeNode));
        IFSTreeNode node = (IFSTreeNode)element;
        if (value == null) {
            return Messages.FSRenamingAssistant_SpecifyNonEmptyName;
        }
        String text = value.toString().trim();
        if (text.length() == 0) {
            return Messages.FSRenamingAssistant_SpecifyNonEmptyName;
        }
        if (this.hasSibbling(node, text)) {
            return Messages.FSRenamingAssistant_NameAlreadyExists;
        }
        String string = formatRegex = node.isWindowsNode() ? WIN_FILENAME_REGEX : UNIX_FILENAME_REGEX;
        if (!text.matches(formatRegex)) {
            return node.isWindowsNode() ? Messages.FSRenamingAssistant_WinIllegalCharacters : Messages.FSRenamingAssistant_UnixIllegalCharacters;
        }
        return null;
    }

    private boolean hasSibbling(IFSTreeNode folder, String name) {
        IFSTreeNode[] nodes = folder.getParent().getChildren();
        if (nodes == null) {
            return false;
        }
        IFSTreeNode[] iFSTreeNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            IFSTreeNode node = iFSTreeNodeArray[n2];
            if (node.isWindowsNode() ? node.getName().equalsIgnoreCase(name) : node.getName().equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

