/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.cdt.ui.commands;

import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.commands.IDebugCommandHandler;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.tcf.internal.cdt.ui.commands.StepIntoSelectionLocation;
import org.eclipse.tcf.internal.debug.actions.TCFAction;
import org.eclipse.tcf.internal.debug.launch.TCFSourceLookupDirector;
import org.eclipse.tcf.internal.debug.model.TCFContextState;
import org.eclipse.tcf.internal.debug.model.TCFLaunch;
import org.eclipse.tcf.internal.debug.model.TCFSourceRef;
import org.eclipse.tcf.internal.debug.ui.model.TCFChildrenStackTrace;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFModelPresentation;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeStackFrame;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IBreakpoints;
import org.eclipse.tcf.services.IRunControl;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.ui.IEditorInput;

public class TCFStepIntoSelectionHandler
implements IDebugCommandHandler {
    public void canExecute(final IEnabledStateRequest request) {
        final StepIntoSelectionLocation l = new StepIntoSelectionLocation();
        l.getTextLocation((IDebugCommandRequest)request);
        if (!l.isValid()) {
            request.setEnabled(false);
            request.done();
            return;
        }
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (l.node.isDisposed()) {
                    this.done(null, false);
                    return;
                }
                TCFDataCache cache = l.node.getMinState();
                if (!cache.validate((Runnable)this)) {
                    return;
                }
                if (cache.getError() != null) {
                    this.done(cache.getError(), false);
                    return;
                }
                TCFContextState state = (TCFContextState)cache.getData();
                this.done(null, state != null && state.is_suspended);
            }

            private void done(Throwable e, boolean enabled) {
                if (e != null) {
                    request.setStatus((IStatus)new Status(4, "org.eclipse.tcf.cdt.ui", 4, TCFModel.getErrorMessage((Throwable)e, (boolean)true), e));
                }
                request.setEnabled(enabled);
                request.done();
            }
        });
    }

    public boolean execute(final IDebugCommandRequest request) {
        final StepIntoSelectionLocation l = new StepIntoSelectionLocation();
        l.getTargetFunction(request);
        if (!l.isValid()) {
            request.done();
            return true;
        }
        new TCFAction(l.node.getModel().getLaunch(), l.node.getID()){
            boolean resumed;
            boolean req_done;
            boolean action_done;
            String bp_id;

            public void run() {
                if (this.aborted || this.action_done || l.node.isDisposed()) {
                    this.done(null);
                    return;
                }
                TCFDataCache state_cache = l.node.getState();
                if (!state_cache.validate((Runnable)((Object)this))) {
                    return;
                }
                if (state_cache.getError() != null) {
                    this.done(state_cache.getError());
                    return;
                }
                TCFContextState state_data = (TCFContextState)state_cache.getData();
                if (state_data == null || !state_data.is_suspended) {
                    this.done(null);
                    return;
                }
                if (this.resumed) {
                    TCFDataCache line_cache;
                    if (!$assertionsDisabled && this.bp_id == null) {
                        throw new AssertionError();
                    }
                    boolean bp_hit = false;
                    Object ids = state_data.suspend_params.get("BPs");
                    if (ids != null) {
                        Collection bp_ids = (Collection)ids;
                        boolean bl = bp_hit = bp_ids.contains(this.bp_id) && bp_ids.size() == 1;
                    }
                    if (!bp_hit) {
                        this.done(null);
                        return;
                    }
                    TCFChildrenStackTrace stack_trace = l.node.getStackTrace();
                    if (!stack_trace.validate((Runnable)((Object)this))) {
                        return;
                    }
                    TCFNodeStackFrame stack_frame = stack_trace.getTopFrame();
                    BigInteger addr_data = null;
                    if (l.target_function != null) {
                        if (!stack_frame.getStackTraceContext().validate((Runnable)((Object)this))) {
                            return;
                        }
                        addr_data = stack_frame.getReturnAddress();
                        if (addr_data != null && addr_data.compareTo(BigInteger.valueOf(0L)) > 0) {
                            addr_data = addr_data.subtract(BigInteger.valueOf(1L));
                        }
                    } else {
                        TCFDataCache addr_cache = stack_frame.getAddress();
                        if (!addr_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        addr_data = (BigInteger)addr_cache.getData();
                    }
                    if (addr_data != null && (line_cache = l.node.getLineInfo(addr_data)) != null) {
                        TCFModelPresentation presentation;
                        IEditorInput editor_input;
                        Object source_element;
                        if (!line_cache.validate((Runnable)((Object)this))) {
                            return;
                        }
                        TCFSourceRef line_data = (TCFSourceRef)line_cache.getData();
                        if (line_data != null && line_data.area != null && line_data.area.start_line <= l.text_line && line_data.area.end_line > l.text_line && (source_element = TCFSourceLookupDirector.lookup((TCFLaunch)l.node.getModel().getLaunch(), (String)line_data.context_id, (Object)line_data.area)) != null && (editor_input = (presentation = TCFModelPresentation.getDefault()).getEditorInput(source_element)).equals(l.editor.getEditorInput())) {
                            this.done(null);
                            return;
                        }
                    }
                }
                IChannel channel = l.node.getChannel();
                if (this.bp_id == null) {
                    IBreakpoints breakpoints = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                    if (breakpoints == null) {
                        this.done(new Exception("Cannot set breakpoint."));
                        return;
                    }
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    properties.put("File", l.text_file);
                    properties.put("Line", l.text_line);
                    if (l.target_function != null) {
                        if (!$assertionsDisabled && l.target_function == null) {
                            throw new AssertionError();
                        }
                        properties.put("Location", l.target_function.getElementName());
                        properties.put("SkipPrologue", true);
                    }
                    properties.put("ContextIds", new String[]{l.node.getID()});
                    properties.put("Enabled", Boolean.TRUE);
                    properties.put("Service", "RunControl");
                    this.bp_id = "Step." + l.node.getID();
                    properties.put("ID", this.bp_id);
                    breakpoints.add(properties, new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            if (error != null) {
                                bp_id = null;
                                this.done(error);
                            } else {
                                this.run();
                            }
                        }
                    });
                    return;
                }
                final IRunControl run_ctrl = (IRunControl)channel.getRemoteService(IRunControl.class);
                if (run_ctrl == null) {
                    this.done(new Exception("Cannot resume."));
                    return;
                }
                TCFDataCache ctx_cache = l.node.getRunContext();
                if (!ctx_cache.validate((Runnable)((Object)this))) {
                    return;
                }
                if (ctx_cache.getError() != null) {
                    this.done(ctx_cache.getError());
                    return;
                }
                final String node_id = l.node.getID();
                run_ctrl.addListener(new IRunControl.RunControlListener(){

                    private void suspended() {
                        run_ctrl.removeListener((IRunControl.RunControlListener)this);
                        this.run();
                    }

                    public void contextSuspended(String context, String pc, String reason, Map<String, Object> params) {
                        if (node_id.equals(context)) {
                            this.suspended();
                        }
                    }

                    public void contextResumed(String context) {
                    }

                    public void contextRemoved(String[] context_ids) {
                        String[] stringArray = context_ids;
                        int n = context_ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String context = stringArray[n2];
                            if (node_id.equals(context)) {
                                this.suspended();
                                return;
                            }
                            ++n2;
                        }
                    }

                    public void contextException(String context, String msg) {
                    }

                    public void contextChanged(IRunControl.RunControlContext[] contexts) {
                    }

                    public void contextAdded(IRunControl.RunControlContext[] contexts) {
                    }

                    public void containerSuspended(String context, String pc, String reason, Map<String, Object> params, String[] suspended_ids) {
                        String[] stringArray = suspended_ids;
                        int n = suspended_ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String context2 = stringArray[n2];
                            if (node_id.equals(context2)) {
                                this.suspended();
                                return;
                            }
                            ++n2;
                        }
                    }

                    public void containerResumed(String[] context_ids) {
                    }
                });
                this.resumed = true;
                IRunControl.RunControlContext ctx = (IRunControl.RunControlContext)ctx_cache.getData();
                ctx.resume(0, 1, new IRunControl.DoneCommand(){

                    public void doneCommand(IToken token, Exception error) {
                        if (error != null) {
                            this.done(error);
                        } else if (!req_done) {
                            req_done = true;
                            request.done();
                        }
                    }
                });
            }

            public boolean showRunning() {
                return true;
            }

            private void done(Throwable e) {
                if (this.bp_id != null) {
                    IChannel channel = l.node.getChannel();
                    IBreakpoints breakpoints = (IBreakpoints)channel.getRemoteService(IBreakpoints.class);
                    breakpoints.remove(new String[]{this.bp_id}, new IBreakpoints.DoneCommand(){

                        public void doneCommand(IToken token, Exception error) {
                            this.done(error);
                        }
                    });
                    this.bp_id = null;
                    return;
                }
                if (!this.req_done) {
                    if (e != null) {
                        request.setStatus((IStatus)new Status(4, "org.eclipse.tcf.cdt.ui", 4, TCFModel.getErrorMessage((Throwable)e, (boolean)true), e));
                    }
                    this.req_done = true;
                    request.done();
                }
                if (!this.action_done) {
                    this.action_done = true;
                    this.setActionResult(this.getContextID(), "Step Into Selection");
                    super.done();
                }
            }
        };
        return true;
    }
}

