/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.tcf.te.launch.core.bindings.LaunchConfigTypeBindingsManager;
import org.eclipse.tcf.te.launch.core.interfaces.IReferencedProjectItem;
import org.eclipse.tcf.te.launch.core.persistence.DefaultPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.launchcontext.LaunchContextsPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.persistence.projects.ReferencedProjectItem;
import org.eclipse.tcf.te.launch.core.persistence.projects.ReferencedProjectsPersistenceDelegate;
import org.eclipse.tcf.te.launch.core.selection.LaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.ProjectSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.RemoteSelectionContext;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ILaunchSelection;
import org.eclipse.tcf.te.launch.core.selection.interfaces.ISelectionContext;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.runtime.events.ChangeEvent;
import org.eclipse.tcf.te.runtime.events.EventManager;
import org.eclipse.tcf.te.runtime.interfaces.events.IEventListener;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;

public final class LaunchModel
implements IEventListener,
ILaunchConfigurationListener {
    private static final Map<Object, LaunchModel> models = new HashMap<Object, LaunchModel>();
    private static final Map<String, String> nameToUUID = new HashMap<String, String>();
    private final LaunchNode rootNode;
    private final Object modelRoot;
    private String lastAddedUUID = null;

    public static LaunchModel getLaunchModel(Object modelRoot) {
        if (modelRoot instanceof ICategory || modelRoot instanceof IModelNode || modelRoot instanceof IProject) {
            LaunchModel model = models.get(modelRoot);
            if (model == null) {
                model = new LaunchModel(modelRoot);
                models.put(modelRoot, model);
            }
            return model;
        }
        return null;
    }

    private LaunchModel(Object modelRoot) {
        Assert.isNotNull((Object)modelRoot);
        this.modelRoot = modelRoot;
        this.rootNode = new LaunchNode(this);
        this.refresh();
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        if (modelRoot instanceof ICategory) {
            EventManager.getInstance().addEventListener((IEventListener)this, ChangeEvent.class);
        }
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy()) {
            if (this.getModelRoot() instanceof ICategory) {
                if (!LaunchModel.getCategoryId(configuration).equals(this.lastAddedUUID)) {
                    Managers.getCategoryManager().remove(((ICategory)this.getModelRoot()).getId(), LaunchModel.getCategoryId(configuration));
                }
                nameToUUID.remove(configuration.getName());
                this.lastAddedUUID = null;
            }
            if (this.refresh()) {
                EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"removed", null, null));
            }
        }
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy()) {
            this.refresh();
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"changed", null, null));
        }
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy()) {
            if (this.getModelRoot() instanceof ICategory && Managers.getCategoryManager().belongsTo(((ICategory)this.getModelRoot()).getId(), LaunchModel.getCategoryId(configuration))) {
                this.lastAddedUUID = LaunchModel.getCategoryId(configuration);
            }
            if (this.refresh()) {
                EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, (Object)"added", null, null));
            }
        }
    }

    public void eventFired(EventObject event) {
        ChangeEvent e;
        if (event instanceof ChangeEvent && (e = (ChangeEvent)event).getSource() instanceof ICategory && (e.getNewValue() instanceof String && ((String)e.getNewValue()).startsWith(LaunchNode.class.getName()) || e.getOldValue() instanceof String && ((String)e.getOldValue()).startsWith(LaunchNode.class.getName())) && this.refresh()) {
            EventManager.getInstance().fireEvent((EventObject)new ChangeEvent((Object)this, ((ChangeEvent)event).getEventId(), null, null));
        }
    }

    public LaunchNode getRootNode() {
        return this.rootNode;
    }

    public Object getModelRoot() {
        return this.modelRoot;
    }

    public boolean refresh() {
        int n;
        int n2;
        Object[] objectArray;
        boolean changed = false;
        Object parent = this.rootNode.getModel().getModelRoot();
        String[] typeIds = new String[]{};
        if (parent instanceof ICategory) {
            ArrayList<String> ids = new ArrayList<String>();
            objectArray = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                ILaunchConfigurationType type = objectArray[n];
                ids.add(type.getIdentifier());
                ++n;
            }
            typeIds = ids.toArray(new String[ids.size()]);
        }
        if (parent instanceof IProject) {
            typeIds = LaunchConfigTypeBindingsManager.getInstance().getValidLaunchConfigTypes((ILaunchSelection)new LaunchSelection(null, (ISelectionContext)new ProjectSelectionContext((IProject)parent, true)));
        } else if (parent instanceof IModelNode) {
            typeIds = LaunchConfigTypeBindingsManager.getInstance().getValidLaunchConfigTypes((ILaunchSelection)new LaunchSelection(null, (ISelectionContext)new RemoteSelectionContext((IModelNode)parent, true)));
        }
        ArrayList<IModelNode> typeNodes = new ArrayList<IModelNode>(Arrays.asList(this.rootNode.getChildren()));
        objectArray = typeIds;
        n2 = typeIds.length;
        n = 0;
        while (n < n2) {
            ILaunchConfigurationType typeId = objectArray[n];
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType((String)typeId);
            if (type.isPublic()) {
                ILaunchConfiguration[] configs;
                Object typeNode = this.find(type, typeNodes);
                if (typeNode != null) {
                    typeNodes.remove(typeNode);
                } else {
                    typeNode = new LaunchNode(type);
                    this.rootNode.add((IModelNode)typeNode);
                    changed = true;
                }
                try {
                    configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(type);
                }
                catch (Exception e) {
                    configs = new ILaunchConfiguration[]{};
                }
                ArrayList<IModelNode> configNodes = new ArrayList<IModelNode>(Arrays.asList(((IContainerModelNode)typeNode).getChildren()));
                ILaunchConfiguration[] iLaunchConfigurationArray = configs;
                int n3 = configs.length;
                int n4 = 0;
                while (n4 < n3) {
                    ILaunchConfiguration config = iLaunchConfigurationArray[n4];
                    if (parent instanceof ICategory) {
                        if (Managers.getCategoryManager().belongsTo(((ICategory)parent).getId(), LaunchModel.getCategoryId(config))) {
                            changed |= this.checkAndAdd(config, (IContainerModelNode)typeNode, configNodes);
                        }
                    } else if (parent instanceof IModelNode) {
                        IModelNode[] contexts = LaunchContextsPersistenceDelegate.getLaunchContexts((ILaunchConfiguration)config);
                        if (contexts != null && Arrays.asList(contexts).contains(parent)) {
                            changed |= this.checkAndAdd(config, (IContainerModelNode)typeNode, configNodes);
                        }
                    } else if (parent instanceof IProject) {
                        IReferencedProjectItem[] projects = ReferencedProjectsPersistenceDelegate.getReferencedProjects((ILaunchConfiguration)config);
                        ReferencedProjectItem project = new ReferencedProjectItem();
                        project.setProperty("project_name", (Object)((IProject)parent).getName());
                        if (projects != null && Arrays.asList(projects).contains(project)) {
                            changed |= this.checkAndAdd(config, (IContainerModelNode)typeNode, configNodes);
                        }
                    }
                    ++n4;
                }
                for (IModelNode configToDelete : configNodes) {
                    ((IContainerModelNode)typeNode).remove(configToDelete, true);
                    changed = true;
                }
                if (parent instanceof ICategory && typeNode.isEmpty()) {
                    typeNodes.add((IModelNode)typeNode);
                }
            }
            ++n;
        }
        for (IModelNode typeToDelete : typeNodes) {
            this.rootNode.remove(typeToDelete, true);
            changed = true;
        }
        return changed;
    }

    private boolean checkAndAdd(ILaunchConfiguration config, IContainerModelNode typeNode, List<IModelNode> configNodes) {
        Object configNode = this.find(config, configNodes);
        if (configNode == null) {
            configNode = new LaunchNode(config);
            typeNode.add(configNode);
            return true;
        }
        configNodes.remove(configNode);
        return false;
    }

    private IModelNode find(ILaunchConfiguration config, List<IModelNode> list) {
        for (IModelNode candidate : list) {
            if (!(candidate instanceof LaunchNode)) continue;
            LaunchNode node = new LaunchNode(config);
            node.setProperty("model", this);
            if (!((LaunchNode)candidate).equals((Object)node)) continue;
            return candidate;
        }
        return null;
    }

    private IModelNode find(ILaunchConfigurationType type, List<IModelNode> list) {
        for (IModelNode candidate : list) {
            if (!(candidate instanceof LaunchNode)) continue;
            LaunchNode node = new LaunchNode(type);
            node.setProperty("model", this);
            if (!((LaunchNode)candidate).equals((Object)node)) continue;
            return candidate;
        }
        return null;
    }

    public static String getCategoryId(ILaunchConfiguration config) {
        String uuid = DefaultPersistenceDelegate.getAttribute((ILaunchConfiguration)config, (String)"org.eclipse.tcf.te.launch.UUID", null);
        if (uuid == null) {
            uuid = nameToUUID.get(config.getName());
        }
        if (uuid != null && !nameToUUID.containsKey(config.getName())) {
            nameToUUID.put(config.getName(), uuid);
        }
        return String.valueOf(LaunchNode.class.getName()) + "." + (uuid != null ? uuid : config.getName());
    }
}

