/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.remote.internal.jsch.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.remote.core.IRemoteConnection;
import org.eclipse.remote.ui.IRemoteUIFileManager;
import org.eclipse.remote.ui.dialogs.RemoteResourceBrowser;
import org.eclipse.swt.widgets.Shell;

public class JSchUIFileManager
implements IRemoteUIFileManager {
    private IRemoteConnection connection = null;
    private boolean showConnections = false;

    public String browseDirectory(Shell shell, String message, String filterPath, int flags) {
        RemoteResourceBrowser browser = new RemoteResourceBrowser(shell, 4);
        browser.setType(2);
        browser.setInitialPath(filterPath);
        browser.setTitle(message);
        browser.showConnections(this.showConnections);
        browser.setConnection(this.connection);
        if (browser.open() == 1) {
            return null;
        }
        this.connection = browser.getConnection();
        IFileStore resource = browser.getResource();
        if (resource == null) {
            return null;
        }
        return resource.toURI().getPath();
    }

    public String browseFile(Shell shell, String message, String filterPath, int flags) {
        RemoteResourceBrowser browser = new RemoteResourceBrowser(shell, 4);
        browser.setType(1);
        browser.setInitialPath(filterPath);
        browser.setTitle(message);
        browser.showConnections(this.showConnections);
        browser.setConnection(this.connection);
        if (browser.open() == 1) {
            return null;
        }
        this.connection = browser.getConnection();
        IFileStore resource = browser.getResource();
        if (resource == null) {
            return null;
        }
        return resource.toURI().getPath();
    }

    public List<String> browseFiles(Shell shell, String message, String filterPath, int flags) {
        RemoteResourceBrowser browser = new RemoteResourceBrowser(shell, 2);
        browser.setType(1);
        browser.setInitialPath(filterPath);
        browser.setTitle(message);
        browser.showConnections(this.showConnections);
        browser.setConnection(this.connection);
        if (browser.open() == 1) {
            return null;
        }
        this.connection = browser.getConnection();
        ArrayList<String> paths = new ArrayList<String>();
        for (IFileStore store : browser.getResources()) {
            paths.add(store.toURI().getPath());
        }
        return paths;
    }

    public IRemoteConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IRemoteConnection connection) {
        this.connection = connection;
    }

    public void showConnections(boolean enable) {
        this.showConnections = enable;
    }
}

