/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.common.jfreechart.ui.viewers;

import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.jfree.chart.util.Args;

public class SelectionProvider
implements ISelectionProvider {
    private final ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();
    private final ISelection emptySelection;
    private ISelection selection;

    public SelectionProvider() {
        this((ISelection)StructuredSelection.EMPTY);
    }

    public SelectionProvider(ISelection emptySelection) {
        Args.nullNotPermitted((Object)emptySelection, (String)"emptySelection");
        if (!emptySelection.isEmpty()) {
            throw new IllegalArgumentException("emptySelection should return true on isEmpty()");
        }
        this.emptySelection = emptySelection;
        this.selection = emptySelection;
    }

    public void clearSelection() {
        this.setSelection(this.emptySelection);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection == null ? this.emptySelection : selection;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.selection));
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        for (final ISelectionChangedListener l : this.selectionChangedListeners) {
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
        }
    }
}

