/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.taginfo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.sse.ui.internal.ITemporaryAnnotation;
import org.eclipse.wst.sse.ui.internal.SSEUIMessages;
import org.eclipse.wst.sse.ui.internal.SSEUIPlugin;
import org.eclipse.wst.sse.ui.internal.taginfo.AbstractHoverProcessor;

public class AnnotationHoverProcessor
extends AbstractHoverProcessor {
    private static final String LIST_BEGIN = "<ul>";
    private static final String LIST_ELEMENT = "<li>";
    private static final String PARAGRAPH_END = "</p>";
    private static final String PARAGRAPH_START = "<p>";
    private IPreferenceStore fPreferenceStore = null;

    private String formatMessage(String msg) {
        StringBuffer buf = new StringBuffer();
        buf.append(PARAGRAPH_START);
        buf.append(StringUtils.convertToHTMLContent((String)msg));
        buf.append(PARAGRAPH_END);
        return buf.toString();
    }

    private String formatMessages(List messages) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(PARAGRAPH_START);
        buffer.append(SSEUIMessages.Multiple_errors);
        buffer.append(LIST_BEGIN);
        Iterator e = messages.iterator();
        while (e.hasNext()) {
            buffer.append(LIST_ELEMENT);
            buffer.append(StringUtils.convertToHTMLContent((String)((String)e.next())));
        }
        buffer.append(PARAGRAPH_END);
        return buffer.toString();
    }

    private AnnotationPreference getAnnotationPreference(Annotation annotation) {
        if (annotation.isMarkedDeleted()) {
            return null;
        }
        return EditorsUI.getAnnotationPreferenceLookup().getAnnotationPreference(annotation);
    }

    public String getHoverInfo(ITextViewer viewer, IRegion hoverRegion) {
        IAnnotationModel model = ((SourceViewer)viewer).getAnnotationModel();
        if (model != null) {
            ArrayList<String> messages = new ArrayList<String>();
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                String msg;
                Position p;
                Annotation a = (Annotation)e.next();
                if (!this.isAnnotationValid(a) || !(p = model.getPosition(a)).overlapsWith(hoverRegion.getOffset(), hoverRegion.getLength()) || (msg = a.getText()) == null || msg.trim().length() <= 0) continue;
                if (a instanceof ITemporaryAnnotation) {
                    boolean duplicated = false;
                    int j = 0;
                    while (j < messages.size() && !duplicated) {
                        duplicated = messages.get(j).equals(msg);
                        ++j;
                    }
                    if (duplicated) continue;
                    messages.add(msg);
                    continue;
                }
                messages.add(msg);
            }
            if (messages.size() > 1) {
                return this.formatMessages(messages);
            }
            if (messages.size() > 0) {
                return this.formatMessage(messages.get(0).toString());
            }
        }
        return null;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        IAnnotationModel model = ((SourceViewer)textViewer).getAnnotationModel();
        Region hoverRegion = null;
        if (model != null) {
            Iterator e = model.getAnnotationIterator();
            while (e.hasNext()) {
                Position p;
                Annotation a = (Annotation)e.next();
                if (!this.isAnnotationValid(a) || (p = model.getPosition(a)) == null || !p.includes(offset) || hoverRegion != null && hoverRegion.getLength() <= p.getLength()) continue;
                hoverRegion = new Region(p.getOffset(), p.getLength());
            }
        }
        return hoverRegion;
    }

    private IPreferenceStore getPreferenceStore() {
        if (this.fPreferenceStore == null) {
            IPreferenceStore sseEditorPrefs = SSEUIPlugin.getDefault().getPreferenceStore();
            IPreferenceStore baseEditorPrefs = EditorsUI.getPreferenceStore();
            this.fPreferenceStore = new ChainedPreferenceStore(new IPreferenceStore[]{sseEditorPrefs, baseEditorPrefs});
        }
        return this.fPreferenceStore;
    }

    boolean isAnnotationValid(Annotation a) {
        AnnotationPreference preference = this.getAnnotationPreference(a);
        if (preference == null) {
            return false;
        }
        String textPreferenceKey = preference.getTextPreferenceKey();
        String highlightPreferenceKey = preference.getHighlightPreferenceKey();
        return textPreferenceKey != null && this.getPreferenceStore().getBoolean(textPreferenceKey) && highlightPreferenceKey != null && !this.getPreferenceStore().getBoolean(highlightPreferenceKey);
    }
}

