/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.Criteria;

public class FilterCriteria {
    protected static final String ACTIVE = "active";
    protected static final String POSITIVE = "positive";
    protected static final String LOADERCLASSNAME = "loaderClassName";
    private Criteria fCriteria;
    private boolean fIsActive;
    private boolean fIsPositive;
    private String fLoaderClassName;

    public FilterCriteria(Criteria criteria, boolean isActive, boolean isPositive) {
        this(criteria, isActive, isPositive, null);
    }

    public FilterCriteria(Criteria criteria, boolean isActive, boolean isPositive, String loaderClassName) {
        this.fCriteria = criteria;
        this.fIsActive = isActive;
        this.fIsPositive = isPositive;
        this.fLoaderClassName = loaderClassName;
    }

    public FilterCriteria(FilterCriteria other) {
        this.fCriteria = new Criteria(other.fCriteria);
        this.fIsActive = other.fIsActive;
        this.fIsPositive = other.fIsPositive;
        this.fLoaderClassName = other.fLoaderClassName;
    }

    protected FilterCriteria() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(':');
        if (this.fCriteria != null) {
            sb.append(" expression=");
            sb.append(this.fCriteria.getExpression());
            sb.append(" active=");
            sb.append(this.fIsActive);
            sb.append(" positive=");
            sb.append(this.fIsPositive);
        } else {
            sb.append("empty criteria");
        }
        return sb.toString();
    }

    public void setCriteria(Criteria criteria) {
        this.fCriteria = criteria;
    }

    public Criteria getCriteria() {
        return this.fCriteria;
    }

    public void setActive(boolean isActive) {
        this.fIsActive = isActive;
    }

    public boolean isActive() {
        return this.fIsActive;
    }

    public void setPositive(boolean isPositive) {
        this.fIsPositive = isPositive;
    }

    public boolean isPositive() {
        return this.fIsPositive;
    }

    public void setLoaderClassName(String loaderClassName) {
        this.fLoaderClassName = loaderClassName;
    }

    public String getLoaderClassName() {
        return this.fLoaderClassName;
    }

    public static FilterCriteria find(FilterCriteria what, List<FilterCriteria> list) {
        if (what != null && list != null) {
            try {
                for (FilterCriteria fc : list) {
                    if (!what.compareTo(fc)) continue;
                    return fc;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean compareTo(FilterCriteria to) {
        if (this.isPositive() == to.isPositive() && this.getCriteria().compareTo(to.getCriteria())) {
            if (this.getLoaderClassName() == null && to.getLoaderClassName() == null) {
                return true;
            }
            if (this.getLoaderClassName() != null && to.getLoaderClassName() != null && this.getLoaderClassName().equals(to.getLoaderClassName())) {
                return true;
            }
        }
        return false;
    }

    public void save(DialogSettings settings) {
        settings.put(ACTIVE, this.isActive());
        settings.put(POSITIVE, this.isPositive());
        if (this.getLoaderClassName() != null) {
            settings.put(LOADERCLASSNAME, this.getLoaderClassName());
        } else {
            settings.put(LOADERCLASSNAME, "");
        }
        if (this.fCriteria != null) {
            this.fCriteria.save(settings);
        }
    }

    public void load(DialogSettings settings) {
        this.setActive(settings.getBoolean(ACTIVE));
        this.setPositive(settings.getBoolean(POSITIVE));
        String loaderClassName = settings.get(LOADERCLASSNAME);
        this.setLoaderClassName(loaderClassName != null && loaderClassName.length() > 0 ? loaderClassName : null);
        if (this.fCriteria != null) {
            this.fCriteria.load(settings);
        }
    }
}

