/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.importexport.launchconfigurations;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.importexport.launchconfigurations.WizardMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchCategoryFilter;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchViewerComparator;
import org.eclipse.ui.progress.UIJob;

public class ExportLaunchConfigurationsWizardPage
extends WizardPage {
    private final ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
    private final String OVERWRITE = "overwrite";
    private final String OLD_PATH = "oldpath";
    private CheckboxTreeViewer fViewer = null;
    private Text fFilePath = null;
    private Button fOverwrite = null;
    private ConfigContentProvider fContentProvider = null;
    private IStructuredSelection selectedElements;

    protected ExportLaunchConfigurationsWizardPage() {
        super(WizardMessages.ExportLaunchConfigurationsWizard_0);
        this.setTitle(WizardMessages.ExportLaunchConfigurationsWizard_0);
    }

    protected ExportLaunchConfigurationsWizardPage(IStructuredSelection selection) {
        this();
        this.selectedElements = selection;
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808);
        this.createViewer(comp);
        this.createFilePath(comp);
        this.fOverwrite = SWTFactory.createCheckButton(comp, WizardMessages.ExportLaunchConfigurationsWizardPage_1, null, this.getDialogSettings().getBoolean("overwrite"), 2);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, "org.eclipse.debug.ui.export_launch_configurations_context");
        this.setMessage(WizardMessages.ExportLaunchConfigurationsWizardPage_7);
        this.setPageComplete(this.isComplete());
    }

    protected void createViewer(Composite parent) {
        SWTFactory.createWrapLabel(parent, WizardMessages.ExportLaunchConfigurationsWizardPage_3, 2);
        Tree tree = new Tree(parent, 2084);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = 2;
        tree.setLayoutData((Object)gd);
        this.fViewer = new CheckboxTreeViewer(tree);
        this.fViewer.setLabelProvider((IBaseLabelProvider)DebugUITools.newDebugModelPresentation());
        this.fViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.fContentProvider = new ConfigContentProvider();
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setInput((Object)this.getUsedLaunchConfigurationTypes());
        this.fViewer.addFilter((ViewerFilter)new LaunchCategoryFilter("org.eclipse.ui.externaltools.builder"));
        this.fViewer.expandAll();
        this.fViewer.collapseAll();
        if (this.selectedElements != null) {
            Object[] checkedElements = this.selectedElements.toArray();
            this.fViewer.setCheckedElements(checkedElements);
            this.fViewer.setExpandedElements(checkedElements);
            Object[] objectArray = checkedElements;
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.updateCheckedState(element);
                ++n2;
            }
        }
        this.fViewer.addCheckStateListener(event -> {
            this.updateCheckedState(event.getElement());
            this.setPageComplete(this.isComplete());
        });
        Composite buttoncomp = SWTFactory.createComposite(parent, parent.getFont(), 2, 2, 768, 0, 0);
        Button button = SWTFactory.createPushButton(buttoncomp, WizardMessages.ExportLaunchConfigurationsWizardPage_8, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] items;
                Object[] objectArray = items = ExportLaunchConfigurationsWizardPage.this.fContentProvider.getElements(ExportLaunchConfigurationsWizardPage.this.fViewer.getInput());
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ExportLaunchConfigurationsWizardPage.this.fViewer.setSubtreeChecked(item, true);
                    ++n2;
                }
                ExportLaunchConfigurationsWizardPage.this.setPageComplete(ExportLaunchConfigurationsWizardPage.this.isComplete());
            }
        });
        button = SWTFactory.createPushButton(buttoncomp, WizardMessages.ExportLaunchConfigurationsWizardPage_9, null);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] items;
                Object[] objectArray = items = ExportLaunchConfigurationsWizardPage.this.fContentProvider.getElements(ExportLaunchConfigurationsWizardPage.this.fViewer.getInput());
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    Object item = objectArray[n2];
                    ExportLaunchConfigurationsWizardPage.this.fViewer.setSubtreeChecked(item, false);
                    ++n2;
                }
                ExportLaunchConfigurationsWizardPage.this.setPageComplete(ExportLaunchConfigurationsWizardPage.this.isComplete());
            }
        });
    }

    private ILaunchConfigurationType[] getUsedLaunchConfigurationTypes() {
        return (ILaunchConfigurationType[])Arrays.stream(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationTypes()).filter(launchConfigType -> {
            try {
                return this.getConfigurationTypeChildren((ILaunchConfigurationType)launchConfigType).length > 0;
            }
            catch (CoreException e) {
                DebugUIPlugin.logErrorMessage(e.getMessage());
                return true;
            }
        }).toArray(ILaunchConfigurationType[]::new);
    }

    private ILaunchConfiguration[] getConfigurationTypeChildren(ILaunchConfigurationType launchConfigurationTypeParent) throws CoreException {
        return this.lm.getLaunchConfigurations(launchConfigurationTypeParent, 3);
    }

    protected void updateCheckedState(Object element) {
        boolean state = this.fViewer.getChecked(element);
        if (element instanceof ILaunchConfigurationType) {
            Object[] items;
            Object[] objectArray = items = ((ConfigContentProvider)this.fViewer.getContentProvider()).getChildren(element);
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                this.fViewer.setChecked(item, state);
                ++n2;
            }
            this.fViewer.setGrayed(element, false);
        } else if (element instanceof ILaunchConfiguration) {
            ConfigContentProvider ccp = (ConfigContentProvider)this.fViewer.getContentProvider();
            Object parent = ccp.getParent(element);
            Object[] items = ccp.getChildren(parent);
            boolean checked = true;
            boolean onechecked = false;
            Object[] objectArray = items;
            int n = items.length;
            int n3 = 0;
            while (n3 < n) {
                Object item = objectArray[n3];
                state = this.fViewer.getChecked(item);
                checked &= state;
                if (state) {
                    onechecked = true;
                }
                ++n3;
            }
            this.fViewer.setGrayed(parent, onechecked && !checked);
            this.fViewer.setChecked(parent, checked || onechecked);
        }
    }

    protected void createFilePath(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, parent.getFont(), 3, 2, 768, 0, 10);
        SWTFactory.createLabel(comp, WizardMessages.ExportLaunchConfigurationsWizardPage_4, 1);
        this.fFilePath = SWTFactory.createText(comp, 2052, 1);
        String opath = this.getDialogSettings().get("oldpath");
        this.fFilePath.setText(opath == null ? "" : opath);
        this.fFilePath.addModifyListener(e -> this.setPageComplete(this.isComplete()));
        Button button = SWTFactory.createPushButton(comp, WizardMessages.ExportLaunchConfigurationsWizardPage_0, null, 3);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IPath path;
                DirectoryDialog dd = new DirectoryDialog(ExportLaunchConfigurationsWizardPage.this.getContainer().getShell(), 0x10000000);
                dd.setText(WizardMessages.ExportLaunchConfigurationsWizard_0);
                String file = dd.open();
                if (file != null && (path = IPath.fromOSString((String)file)) != null) {
                    ExportLaunchConfigurationsWizardPage.this.fFilePath.setText(path.toString());
                    ExportLaunchConfigurationsWizardPage.this.setPageComplete(ExportLaunchConfigurationsWizardPage.this.isComplete());
                }
            }
        });
    }

    protected boolean isComplete() {
        Object[] elements = this.fViewer.getCheckedElements();
        boolean oneconfig = false;
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof ILaunchConfiguration) {
                oneconfig = true;
                break;
            }
            ++n2;
        }
        if (elements.length < 1 || !oneconfig) {
            this.setErrorMessage(WizardMessages.ExportLaunchConfigurationsWizardPage_5);
            return false;
        }
        String path = this.fFilePath.getText().trim();
        if (path.equals("")) {
            this.setErrorMessage(WizardMessages.ExportLaunchConfigurationsWizardPage_6);
            return false;
        }
        if (new File(path).isFile()) {
            this.setErrorMessage(WizardMessages.ExportLaunchConfigurationsWizardPage_2);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(WizardMessages.ExportLaunchConfigurationsWizardPage_7);
        return true;
    }

    public Image getImage() {
        return DebugUITools.getImage("IMG_WIZBAN_EXPORT_CONFIGS");
    }

    public boolean finish() {
        final String dpath = this.fFilePath.getText().trim();
        IDialogSettings settings = this.getDialogSettings();
        settings.put("overwrite", this.fOverwrite.getSelection());
        settings.put("oldpath", dpath);
        final Object[] configs = this.fViewer.getCheckedElements();
        final boolean overwrite = this.fOverwrite.getSelection();
        UIJob exportjob = new UIJob(this.getContainer().getShell().getDisplay(), WizardMessages.ExportLaunchConfigurationsWizard_0){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                IProgressMonitor progressMonitor = monitor != null ? monitor : new NullProgressMonitor();
                IPath destpath = IPath.fromOSString((String)dpath);
                File destfolder = destpath.toFile();
                if (!destfolder.exists()) {
                    destfolder.mkdirs();
                }
                progressMonitor.beginTask(WizardMessages.ExportLaunchConfigurationsWizardPage_10, configs.length);
                try {
                    ArrayList<Object> errors = null;
                    IFileStore file = null;
                    File newfile = null;
                    boolean owall = false;
                    boolean nowall = false;
                    MessageDialog dialog = null;
                    Object[] objectArray = configs;
                    int n = configs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        block31: {
                            block30: {
                                Object config = objectArray[n2];
                                if (progressMonitor.isCanceled()) {
                                    IStatus iStatus = Status.CANCEL_STATUS;
                                    return iStatus;
                                }
                                if (config instanceof ILaunchConfiguration) {
                                    try {
                                        LaunchConfiguration launchConfig = (LaunchConfiguration)config;
                                        file = launchConfig.getFileStore();
                                        if (file == null) {
                                            if (errors == null) {
                                                errors = new ArrayList(configs.length);
                                            }
                                            errors.add(new Status(4, DebugUIPlugin.getUniqueIdentifier(), MessageFormat.format(WizardMessages.ExportLaunchConfigurationsWizardPage_19, launchConfig.getName()), null));
                                            break block30;
                                        }
                                        newfile = new File(destpath.append(file.getName()).toOSString());
                                        if (newfile.exists() && !overwrite) {
                                            if (nowall) break block31;
                                            dialog = new MessageDialog(DebugUIPlugin.getShell(), WizardMessages.ExportLaunchConfigurationsWizardPage_11, null, MessageFormat.format(WizardMessages.ExportLaunchConfigurationsWizardPage_12, file.getName()), 3, new String[]{WizardMessages.ExportLaunchConfigurationsWizardPage_13, WizardMessages.ExportLaunchConfigurationsWizardPage_14, WizardMessages.ExportLaunchConfigurationsWizardPage_15, WizardMessages.ExportLaunchConfigurationsWizardPage_16, WizardMessages.ExportLaunchConfigurationsWizardPage_17}, 0);
                                            if (!owall) {
                                                int ret = dialog.open();
                                                switch (ret) {
                                                    case 0: {
                                                        ExportLaunchConfigurationsWizardPage.this.copyFile(file, newfile);
                                                        break;
                                                    }
                                                    case 1: {
                                                        owall = true;
                                                        ExportLaunchConfigurationsWizardPage.this.copyFile(file, newfile);
                                                        break;
                                                    }
                                                    case 3: {
                                                        nowall = true;
                                                        break;
                                                    }
                                                    case 4: {
                                                        progressMonitor.setCanceled(true);
                                                        break;
                                                    }
                                                }
                                            } else if (!nowall) {
                                                ExportLaunchConfigurationsWizardPage.this.copyFile(file, newfile);
                                            }
                                            break block30;
                                        }
                                        ExportLaunchConfigurationsWizardPage.this.copyFile(file, newfile);
                                    }
                                    catch (IOException e) {
                                        if (errors == null) {
                                            errors = new ArrayList<Object>(configs.length);
                                        }
                                        errors.add(new Status(4, DebugUIPlugin.getUniqueIdentifier(), e.getMessage(), (Throwable)e));
                                    }
                                    catch (CoreException e) {
                                        if (errors == null) {
                                            errors = new ArrayList(configs.length);
                                        }
                                        errors.add(e.getStatus());
                                    }
                                }
                            }
                            if (!progressMonitor.isCanceled()) {
                                progressMonitor.worked(1);
                            }
                        }
                        ++n2;
                    }
                    if (errors == null || errors.isEmpty()) {
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    if (errors.size() == 1) {
                        IStatus iStatus = (IStatus)errors.get(0);
                        return iStatus;
                    }
                    MultiStatus multiStatus = new MultiStatus(DebugUIPlugin.getUniqueIdentifier(), 0, errors.toArray(new IStatus[errors.size()]), WizardMessages.ExportLaunchConfigurationsWizardPage_18, null);
                    return multiStatus;
                }
                finally {
                    progressMonitor.done();
                }
            }
        };
        exportjob.schedule();
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void copyFile(IFileStore in, File out) throws CoreException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            BufferedInputStream is = new BufferedInputStream(in.openInputStream(0, null));
            try {
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));){
                    byte[] buf = new byte[1024];
                    int i = 0;
                    while ((i = is.read(buf)) != -1) {
                        os.write(buf, 0, i);
                    }
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    class ConfigContentProvider
    implements ITreeContentProvider {
        ConfigContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ILaunchConfigurationType) {
                try {
                    return ExportLaunchConfigurationsWizardPage.this.getConfigurationTypeChildren((ILaunchConfigurationType)parentElement);
                }
                catch (Exception e) {
                    DebugUIPlugin.logErrorMessage(e.getMessage());
                }
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ILaunchConfiguration) {
                try {
                    return ((ILaunchConfiguration)element).getType();
                }
                catch (CoreException coreException) {
                    return null;
                }
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return element instanceof ILaunchConfigurationType;
        }

        public Object[] getElements(Object inputElement) {
            return ExportLaunchConfigurationsWizardPage.this.getUsedLaunchConfigurationTypes();
        }
    }
}

