/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.launchview.internal.model;

import org.eclipse.debug.ui.launchview.services.ILaunchObject;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;

public class LaunchObjectModel
implements Comparable<LaunchObjectModel> {
    private final String id;
    private final Image image;
    private final ILaunchObject object;
    private final String internalId;

    LaunchObjectModel(ILaunchObject obj) {
        this.id = obj.getId();
        this.internalId = obj.getId();
        this.image = obj.getImage();
        this.object = obj;
    }

    LaunchObjectModel(String id, String internalId, Image image) {
        this.id = id;
        this.internalId = internalId;
        this.image = image;
        this.object = null;
    }

    public StyledString getLabel() {
        if (this.object == null) {
            return new StyledString(this.id);
        }
        return this.object.getLabel();
    }

    public Image getImage() {
        return this.image;
    }

    public ILaunchObject getObject() {
        return this.object;
    }

    public String toString() {
        return this.uniqueId() + "(" + String.valueOf(this.getObject()) + ")";
    }

    @Override
    public int compareTo(LaunchObjectModel o) {
        return this.uniqueId().compareTo(o.uniqueId());
    }

    public String uniqueId() {
        if (this.id == null && this.internalId == null) {
            return "root";
        }
        if (this.internalId != null) {
            return this.internalId;
        }
        if (this.object == null || this.object.getType() == null) {
            return this.id;
        }
        return this.object.getType().getIdentifier() + "." + this.id;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.uniqueId().hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LaunchObjectModel other = (LaunchObjectModel)obj;
        return this.uniqueId().equals(other.uniqueId());
    }
}

