/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.kernel.deployer.model.internal;

import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.virgo.kernel.deployer.core.internal.StandardDeploymentIdentity;
import org.eclipse.virgo.kernel.deployer.model.DuplicateDeploymentIdentityException;
import org.eclipse.virgo.kernel.deployer.model.DuplicateFileNameException;
import org.eclipse.virgo.kernel.deployer.model.DuplicateLocationException;
import org.eclipse.virgo.kernel.deployer.model.GCRoots;
import org.eclipse.virgo.kernel.deployer.model.RuntimeArtifactModel;
import org.eclipse.virgo.kernel.install.artifact.InstallArtifact;
import org.eclipse.virgo.nano.deployer.api.core.DeployUriNormaliser;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentException;
import org.eclipse.virgo.nano.deployer.api.core.DeploymentIdentity;
import org.eclipse.virgo.nano.serviceability.Assert;
import org.eclipse.virgo.nano.serviceability.NonNull;

final class StandardRuntimeArtifactModel
implements RuntimeArtifactModel,
GCRoots {
    private static final String CLASH_MESSAGE_FORMAT = "The artifact %s at URI '%s' cannot be stored in the runtime artifact model as it clashes with the artifact %s which is already present.";
    private static final String URI_PATH_SEPARATOR = "/";
    private static final String SCHEME_FILE = "file";
    private final Object monitor = new Object();
    private final Map<URI, InstallArtifact> artifactByUri = new HashMap<URI, InstallArtifact>();
    private final Map<DeploymentIdentity, URI> uriByIdentity = new HashMap<DeploymentIdentity, URI>();
    private final Map<String, URI> uriByFileName = new HashMap<String, URI>();
    private final DeployUriNormaliser uriNormaliser;

    StandardRuntimeArtifactModel(DeployUriNormaliser uriNormaliser) {
        this.uriNormaliser = uriNormaliser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentIdentity add(@NonNull URI location, @NonNull InstallArtifact installArtifact) throws DuplicateFileNameException, DuplicateLocationException, DuplicateDeploymentIdentityException, DeploymentException {
        URI canonicalLocation = this.getCanonicalFileLocation(location);
        Object object = this.monitor;
        synchronized (object) {
            this.checkLocation(canonicalLocation, installArtifact);
            String fileName = this.getFileName(canonicalLocation);
            this.checkFileName(canonicalLocation, installArtifact, fileName);
            DeploymentIdentity deploymentIdentity = this.getDeploymentIdentity(installArtifact);
            this.checkDeploymentIdentity(canonicalLocation, installArtifact, deploymentIdentity);
            this.updateState(canonicalLocation, installArtifact, fileName, deploymentIdentity);
            return deploymentIdentity;
        }
    }

    private void checkLocation(URI canonicalLocation, InstallArtifact installArtifact) throws DuplicateLocationException {
        if (this.artifactByUri.containsKey(canonicalLocation)) {
            InstallArtifact clashingArtifact = this.getArtifactByUri(canonicalLocation);
            throw new DuplicateLocationException(this.getClashMessage(canonicalLocation, installArtifact, clashingArtifact));
        }
    }

    private void checkFileName(URI location, InstallArtifact installArtifact, String fileName) throws DuplicateFileNameException {
        if (this.uriByFileName.containsKey(fileName)) {
            InstallArtifact clashingArtifact = this.getArtifactByUri(this.uriByFileName.get(fileName));
            throw new DuplicateFileNameException(this.getClashMessage(location, installArtifact, clashingArtifact));
        }
    }

    private void checkDeploymentIdentity(URI location, InstallArtifact installArtifact, DeploymentIdentity deploymentIdentity) throws DuplicateDeploymentIdentityException {
        if (this.uriByIdentity.containsKey(deploymentIdentity)) {
            InstallArtifact clashingArtifact = this.getArtifactByUri(this.uriByIdentity.get(deploymentIdentity));
            throw new DuplicateDeploymentIdentityException(this.getClashMessage(location, installArtifact, clashingArtifact));
        }
    }

    private String getClashMessage(URI location, InstallArtifact installArtifact, InstallArtifact clashingArtifact) {
        return String.format(CLASH_MESSAGE_FORMAT, installArtifact, location, clashingArtifact);
    }

    private DeploymentIdentity getDeploymentIdentity(@NonNull InstallArtifact installArtifact) {
        return new StandardDeploymentIdentity(installArtifact.getType(), installArtifact.getName(), installArtifact.getVersion().toString());
    }

    private String getFileName(@NonNull URI location) throws DeploymentException {
        int separatorIndex;
        URI normalisedLocation = this.uriNormaliser.normalise(location);
        String path = normalisedLocation.getPath();
        String pathSeparator = URI_PATH_SEPARATOR;
        if (SCHEME_FILE.equals(normalisedLocation.getScheme())) {
            pathSeparator = File.separator;
        }
        if (path.endsWith(pathSeparator)) {
            path = path.substring(0, path.length() - 1);
        }
        return (separatorIndex = path.lastIndexOf(pathSeparator)) != -1 ? path.substring(separatorIndex + 1) : path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstallArtifact get(@NonNull DeploymentIdentity deploymentIdentity) {
        Object object = this.monitor;
        synchronized (object) {
            URI location = this.uriByIdentity.get(deploymentIdentity);
            return location == null ? null : this.getArtifactByUri(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstallArtifact get(@NonNull URI location) {
        Object object = this.monitor;
        synchronized (object) {
            return this.getArtifactByUri(location);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URI getLocation(DeploymentIdentity deploymentIdentity) {
        Object object = this.monitor;
        synchronized (object) {
            return this.uriByIdentity.get(deploymentIdentity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeploymentIdentity[] getDeploymentIdentities() {
        Object object = this.monitor;
        synchronized (object) {
            Set<DeploymentIdentity> deploymentIdentities = this.uriByIdentity.keySet();
            return deploymentIdentities.toArray(new DeploymentIdentity[deploymentIdentities.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstallArtifact delete(DeploymentIdentity deploymentIdentity) throws DeploymentException {
        Object object = this.monitor;
        synchronized (object) {
            URI location;
            block4: {
                location = this.uriByIdentity.get(deploymentIdentity);
                if (location != null) break block4;
                return null;
            }
            InstallArtifact installArtifact = this.getArtifactByUri(location);
            Assert.notNull((Object)installArtifact, (String)"Broken invariant: artifactByUri is missing an entry for URI '%s' but this URI is present in uriByIdentity for '%s'", (Object[])new Object[]{location, deploymentIdentity});
            String fileName = this.getFileName(location);
            Assert.isTrue((boolean)this.uriByFileName.containsKey(fileName), (String)"Broken invariant: uriByFileName is missing an entry for file name '%s' but URI '%s' is present in uriByIdentity for '%s'", (Object[])new Object[]{fileName, location, deploymentIdentity});
            this.removeState(deploymentIdentity, location, fileName);
            return installArtifact;
        }
    }

    private void updateState(URI location, InstallArtifact installArtifact, String fileName, DeploymentIdentity deploymentIdentity) {
        this.artifactByUri.put(this.getCanonicalFileLocation(location), installArtifact);
        this.uriByIdentity.put(deploymentIdentity, location);
        this.uriByFileName.put(fileName, location);
    }

    private void removeState(DeploymentIdentity deploymentIdentity, URI location, String fileName) {
        this.artifactByUri.remove(this.getCanonicalFileLocation(location));
        this.uriByIdentity.remove(deploymentIdentity);
        this.uriByFileName.remove(fileName);
    }

    private InstallArtifact getArtifactByUri(URI uri) {
        return this.artifactByUri.get(this.getCanonicalFileLocation(uri));
    }

    private URI getCanonicalFileLocation(URI uri) {
        if (SCHEME_FILE.equals(uri.getScheme())) {
            File file = new File(uri);
            try {
                String canonicalPath = file.getCanonicalPath();
                if (canonicalPath.endsWith(File.separator)) {
                    canonicalPath = canonicalPath.substring(0, canonicalPath.length() - 1);
                }
                if (!canonicalPath.startsWith(URI_PATH_SEPARATOR)) {
                    canonicalPath = URI_PATH_SEPARATOR + canonicalPath;
                }
                return new URI(SCHEME_FILE, null, canonicalPath, null);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to calculate canonical file URI for '" + uri + "'", e);
            }
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGCRoot(InstallArtifact installArtifact) {
        Object object = this.monitor;
        synchronized (object) {
            return this.artifactByUri.containsValue(installArtifact);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<InstallArtifact> iterator() {
        Object object = this.monitor;
        synchronized (object) {
            Collection<InstallArtifact> roots = this.artifactByUri.values();
            return new HashSet<InstallArtifact>(roots).iterator();
        }
    }
}

