/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.repository.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.virgo.medic.eventlog.EventLogger;
import org.eclipse.virgo.medic.eventlog.LogEvent;
import org.eclipse.virgo.repository.ArtifactDescriptorPersister;
import org.eclipse.virgo.repository.Repository;
import org.eclipse.virgo.repository.RepositoryCreationException;
import org.eclipse.virgo.repository.RepositoryFactory;
import org.eclipse.virgo.repository.WatchableRepository;
import org.eclipse.virgo.repository.configuration.ExternalStorageRepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.ManagedStorageRepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.RemoteRepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.RepositoryConfiguration;
import org.eclipse.virgo.repository.configuration.WatchedStorageRepositoryConfiguration;
import org.eclipse.virgo.repository.internal.BaseRepository;
import org.eclipse.virgo.repository.internal.LocalRepository;
import org.eclipse.virgo.repository.internal.RepositoryDumpContributor;
import org.eclipse.virgo.repository.internal.RepositoryLogEvents;
import org.eclipse.virgo.repository.internal.cacheing.CacheingRemoteRepository;
import org.eclipse.virgo.repository.internal.cacheing.cache.StandardRepositoryCacheFactory;
import org.eclipse.virgo.repository.internal.chain.ChainedRepository;
import org.eclipse.virgo.repository.internal.external.ExternalStorageRepository;
import org.eclipse.virgo.repository.internal.persistence.NoOpArtifactDescriptorPersister;
import org.eclipse.virgo.repository.internal.remote.RemoteRepository;
import org.eclipse.virgo.repository.internal.watched.WatchedStorageRepository;
import org.eclipse.virgo.util.common.Assert;
import org.eclipse.virgo.util.osgi.ServiceRegistrationTracker;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class StandardRepositoryFactory
implements RepositoryFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardRepositoryFactory.class);
    private final EventLogger eventLogger;
    private final RepositoryDumpContributor dumpContributor;
    private final BundleContext bundleContext;
    private final ServiceRegistrationTracker tracker;

    StandardRepositoryFactory(EventLogger eventLogger, BundleContext bundleContext, ServiceRegistrationTracker tracker, RepositoryDumpContributor dumpContributor) {
        this.eventLogger = eventLogger;
        this.bundleContext = bundleContext;
        this.tracker = tracker;
        this.dumpContributor = dumpContributor;
    }

    @Override
    public Repository createRepository(List<RepositoryConfiguration> repositoryConfigurations) throws RepositoryCreationException {
        Assert.notNull(repositoryConfigurations, (String)"repositoryConfigurations cannot be null", (Object[])new Object[0]);
        Assert.notEmpty(repositoryConfigurations, (String)"repositoryConfigurations cannot be empty", (Object[])new Object[0]);
        ArrayList<Repository> repositories = new ArrayList<Repository>();
        for (RepositoryConfiguration repositoryConfiguration : repositoryConfigurations) {
            try {
                Repository repository = this.createRepository(repositoryConfiguration);
                repositories.add(repository);
            }
            catch (RepositoryCreationException repositoryCreationException) {}
        }
        StringBuilder nameBuilder = new StringBuilder();
        int i = 0;
        while (i < repositories.size()) {
            if (i > 0) {
                nameBuilder.append("-");
            }
            nameBuilder.append(((Repository)repositories.get(i)).getName());
            ++i;
        }
        String chainName = nameBuilder.toString();
        LOGGER.debug("Assembling chain named '{}' containing '{}' repository/ies.", (Object)chainName, (Object)repositories.size());
        return new ChainedRepository(chainName, repositories);
    }

    @Override
    public Repository createRepository(RepositoryConfiguration repositoryConfiguration, ArtifactDescriptorPersister artifactDescriptorPersister) throws RepositoryCreationException {
        BaseRepository repository;
        block7: {
            Assert.notNull((Object)repositoryConfiguration, (String)"repositoryConfiguration cannot be null", (Object[])new Object[0]);
            Class<?> configurationClass = repositoryConfiguration.getClass();
            String repositoryName = repositoryConfiguration.getName();
            try {
                if (configurationClass.equals(ExternalStorageRepositoryConfiguration.class)) {
                    repository = this.createExternalRepository(repositoryConfiguration, artifactDescriptorPersister);
                    break block7;
                }
                if (configurationClass.equals(WatchedStorageRepositoryConfiguration.class)) {
                    repository = this.createWatchedRepository(repositoryConfiguration, artifactDescriptorPersister);
                    break block7;
                }
                if (configurationClass.equals(RemoteRepositoryConfiguration.class)) {
                    repository = this.createRemoteRepository(repositoryConfiguration);
                    break block7;
                }
                if (configurationClass.equals(ManagedStorageRepositoryConfiguration.class)) {
                    throw new RepositoryCreationException("Managed storage repositories are currently not supported");
                }
                throw new RepositoryCreationException(String.format("'%s' is an unrecognised type of RepositoryConfiguration", configurationClass));
            }
            catch (RepositoryCreationException e) {
                this.eventLogger.log((LogEvent)RepositoryLogEvents.REPOSITORY_NOT_CREATED, new Object[]{repositoryName});
                throw e;
            }
        }
        if (this.dumpContributor != null) {
            this.dumpContributor.addDepository(repository.getName(), repository.getDepository());
        }
        repository.start();
        return repository;
    }

    private RemoteRepository createRemoteRepository(RepositoryConfiguration repositoryConfiguration) throws RepositoryCreationException {
        try {
            return new CacheingRemoteRepository((RemoteRepositoryConfiguration)repositoryConfiguration, this.eventLogger, new StandardRepositoryCacheFactory());
        }
        catch (Exception e) {
            throw new RepositoryCreationException("Failed to create remote repository '" + repositoryConfiguration.getName() + "'.", e);
        }
    }

    private final LocalRepository createWatchedRepository(RepositoryConfiguration repositoryConfiguration, ArtifactDescriptorPersister artifactDescriptorPersister) throws RepositoryCreationException {
        try {
            WatchedStorageRepository watchableRepository = artifactDescriptorPersister == null ? new WatchedStorageRepository((WatchedStorageRepositoryConfiguration)repositoryConfiguration, (ArtifactDescriptorPersister)new NoOpArtifactDescriptorPersister(), this.eventLogger) : new WatchedStorageRepository((WatchedStorageRepositoryConfiguration)repositoryConfiguration, artifactDescriptorPersister, this.eventLogger);
            this.tracker.track(this.bundleContext.registerService(WatchableRepository.class, (Object)watchableRepository, null));
            return watchableRepository;
        }
        catch (Exception e) {
            throw new RepositoryCreationException("Failed to create watched repository '" + repositoryConfiguration.getName() + "'.", e);
        }
    }

    private final LocalRepository createExternalRepository(RepositoryConfiguration repositoryConfiguration, ArtifactDescriptorPersister artifactDescriptorPersister) throws RepositoryCreationException {
        try {
            if (artifactDescriptorPersister == null) {
                return new ExternalStorageRepository((ExternalStorageRepositoryConfiguration)repositoryConfiguration, this.eventLogger);
            }
            return new ExternalStorageRepository((ExternalStorageRepositoryConfiguration)repositoryConfiguration, artifactDescriptorPersister, this.eventLogger);
        }
        catch (Exception e) {
            throw new RepositoryCreationException("Failed to create external repository '" + repositoryConfiguration.getName() + "'.", e);
        }
    }

    @Override
    public Repository createRepository(RepositoryConfiguration repositoryConfiguration) throws RepositoryCreationException {
        return this.createRepository(repositoryConfiguration, null);
    }
}

