/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.releng.tools.component.ui;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wtp.releng.tools.component.ILocation;
import org.eclipse.wtp.releng.tools.component.IPluginXML;
import org.eclipse.wtp.releng.tools.component.api.violation.ComponentViolationEmitter;
import org.eclipse.wtp.releng.tools.component.internal.ComponentXML;
import org.eclipse.wtp.releng.tools.component.internal.Plugin;
import org.eclipse.wtp.releng.tools.component.ui.internal.BundleAdapter;
import org.eclipse.wtp.releng.tools.component.ui.internal.ScannableComponent;
import org.eclipse.wtp.releng.tools.component.ui.internal.WorkspaceFileLocation;
import org.eclipse.wtp.releng.tools.component.ui.internal.WorkspacePluginXML;
import org.eclipse.wtp.releng.tools.component.ui.internal.job.AddComponent;
import org.eclipse.wtp.releng.tools.component.ui.internal.job.InitComponentManager;
import org.eclipse.wtp.releng.tools.component.ui.internal.job.RemoveComponent;
import org.osgi.framework.Bundle;

public class ComponentManager
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String MARKER_COMPONENT_VIOLATION = "marker-comp-vio";
    private static ComponentManager manager;
    private Map scannableComps;
    private Map compRefs;
    private ResourceBundle bundle;

    public static ComponentManager getManager() {
        if (manager == null) {
            manager = new ComponentManager();
        }
        return manager;
    }

    private ComponentManager() {
    }

    public void init() {
        InitComponentManager job = new InitComponentManager();
        job.schedule();
        boolean interrupted = true;
        while (interrupted) {
            try {
                job.join();
                interrupted = false;
            }
            catch (InterruptedException interruptedException) {
                interrupted = true;
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                delta.accept((IResourceDeltaVisitor)this);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource res = delta.getResource();
        int type = res.getType();
        int kind = delta.getKind();
        if (type == 1) {
            this.handleFileDelta((IFile)res, kind);
        } else if (type == 4) {
            this.handleProjectDelta((IProject)res, kind);
        }
        return true;
    }

    private boolean handleFileDelta(IFile file, int kind) {
        if (file.getName().equals("component.xml")) {
            if (kind == 1) {
                new AddComponent(file).schedule();
            } else if (kind == 2) {
                new RemoveComponent(file).schedule();
            } else if (kind == 4 || kind == 256) {
                new RemoveComponent(file).schedule();
                new AddComponent(file).schedule();
            }
        }
        return true;
    }

    private boolean handleProjectDelta(IProject project, int kind) {
        if (kind == 2) {
            this.handleProjectDeltaRemoved(project, kind);
        } else if (kind == 1) {
            this.handleProjectDeltaAdded(project, kind);
        }
        return true;
    }

    private boolean handleProjectDeltaAdded(IProject project, int kind) {
        if (project.findMember("plugin.xml") != null) {
            int i;
            Object[] keys;
            String pluginId = project.getName();
            if (this.scannableComps != null) {
                keys = this.scannableComps.keySet().toArray();
                i = 0;
                while (i < keys.length) {
                    ScannableComponent scannableComp = (ScannableComponent)this.scannableComps.get(keys[i]);
                    ComponentXML compXML = scannableComp.getCompXML();
                    if (this.containsPlugin(compXML, pluginId)) {
                        scannableComp.addProject(project);
                        return false;
                    }
                    ++i;
                }
            }
            if (this.compRefs != null) {
                keys = this.compRefs.keySet().toArray();
                i = 0;
                while (i < keys.length) {
                    ComponentXML compXML = (ComponentXML)this.compRefs.get(keys[i]);
                    if (this.containsPlugin(compXML, pluginId)) {
                        this.addScannableComponent(compXML);
                        return false;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    private boolean containsPlugin(ComponentXML compXML, String pluginId) {
        Iterator it = compXML.getPlugins().iterator();
        while (it.hasNext()) {
            if (!pluginId.equals(((Plugin)it.next()).getId())) continue;
            return true;
        }
        return false;
    }

    private boolean handleProjectDeltaRemoved(IProject project, int kind) {
        if (this.scannableComps != null) {
            ScannableComponent scannableComp = null;
            Iterator it = this.scannableComps.values().iterator();
            while (it.hasNext()) {
                ScannableComponent comp = (ScannableComponent)it.next();
                if (!comp.isScanningProject(project)) continue;
                scannableComp = comp;
                break;
            }
            if (scannableComp != null) {
                scannableComp.removeProject(project.getName());
                if (scannableComp.getProjects().size() <= 0) {
                    this.scannableComps.remove(scannableComp);
                }
            }
        }
        return false;
    }

    public ComponentXML getComponentXML(IFile file) {
        String key = new WorkspaceFileLocation(file).getAbsolutePath();
        ScannableComponent scannableComponent = (ScannableComponent)this.getScannableComponents().get(key);
        if (scannableComponent != null) {
            return scannableComponent.getCompXML();
        }
        return (ComponentXML)this.getCompRefs().get(key);
    }

    public List getComponentXMLs() {
        Iterator it;
        ArrayList<Object> compNames = new ArrayList<Object>();
        if (this.compRefs != null) {
            it = this.compRefs.values().iterator();
            while (it.hasNext()) {
                compNames.add(it.next());
            }
        }
        if (this.scannableComps != null) {
            it = this.scannableComps.values().iterator();
            while (it.hasNext()) {
                compNames.add(((ScannableComponent)it.next()).getCompXML());
            }
        }
        return compNames;
    }

    public boolean isWorkspacePlugin(String id) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (projects[i].getName().equals(id) && projects[i].findMember("plugin.xml") != null) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Map getScannableComponents() {
        if (this.scannableComps == null) {
            return new HashMap(0);
        }
        return new HashMap(this.scannableComps);
    }

    public void addScannableComponent(ComponentXML compXML) {
        HashMap<String, ComponentXML> compXMLs = new HashMap<String, ComponentXML>(1);
        compXMLs.put(compXML.getLocation().getAbsolutePath(), compXML);
        Collection plugins = compXML.getPlugins();
        HashMap<String, IPluginXML> pluginId2Plugins = new HashMap<String, IPluginXML>(plugins.size());
        ArrayList<IProject> projects = new ArrayList<IProject>(1);
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            String pluginId = ((Plugin)it.next()).getId();
            IPluginXML pluginXML = this.getPlugin(pluginId);
            if (pluginXML instanceof WorkspacePluginXML) {
                IProject project = ((WorkspacePluginXML)pluginXML).getProject();
                projects.add(project);
            }
            pluginId2Plugins.put(pluginXML.getName(), pluginXML);
        }
        ComponentViolationEmitter emitter = new ComponentViolationEmitter(null);
        emitter.setDebug(true);
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add("java.");
        excludes.add("javax.");
        excludes.add("org.w3c.");
        excludes.add("org.xml.");
        excludes.add("org.apache.");
        excludes.add("sun.");
        emitter.setClassUseExcludes(excludes);
        emitter.init(compXMLs, this.getCompRefs(), pluginId2Plugins, new HashMap(0));
        ScannableComponent scannableComp = new ScannableComponent(compXML, emitter, projects);
        if (this.scannableComps == null) {
            this.scannableComps = new HashMap(1);
        }
        this.scannableComps.put(compXML.getLocation().getAbsolutePath(), scannableComp);
    }

    public ScannableComponent removeScannableComponent(ILocation location) {
        if (this.scannableComps != null) {
            return (ScannableComponent)this.scannableComps.remove(location.getAbsolutePath());
        }
        return null;
    }

    public IPluginXML getPlugin(String id) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            IResource res;
            if (projects[i].getName().equals(id) && (res = projects[i].findMember("plugin.xml")) != null && res.getType() == 1) {
                return new WorkspacePluginXML((IFile)res);
            }
            ++i;
        }
        Bundle bundle = Platform.getBundle((String)id);
        if (bundle != null) {
            return new BundleAdapter(bundle);
        }
        return null;
    }

    public Map getCompRefs() {
        if (this.compRefs == null) {
            return new HashMap(0);
        }
        return new HashMap(this.compRefs);
    }

    public void addCompRef(ComponentXML compRef) {
        if (this.compRefs == null) {
            this.compRefs = new HashMap(1);
        }
        this.compRefs.put(compRef.getLocation().getAbsolutePath(), compRef);
        if (this.scannableComps != null) {
            Iterator it = this.scannableComps.values().iterator();
            while (it.hasNext()) {
                ((ScannableComponent)it.next()).addCompRef(compRef);
            }
        }
    }

    public void removeCompRef(ILocation location) {
        if (this.compRefs != null) {
            this.compRefs.remove(location.getAbsolutePath());
        }
        if (this.scannableComps != null) {
            Iterator it = this.scannableComps.values().iterator();
            while (it.hasNext()) {
                ((ScannableComponent)it.next()).removeCompRef(location);
            }
        }
    }

    public String getMessage(String key) {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceBundle.getBundle("org.eclipse.wtp.releng.tools.component.ui.component");
            }
            catch (MissingResourceException missingResourceException) {
                return key;
            }
        }
        return this.bundle.getString(key);
    }

    public String getMessage(String key, String[] subsitutes) {
        return MessageFormat.format(this.getMessage(key), subsitutes);
    }
}

