/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.UnitOfWork;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.WorkbenchStyledLabelProvider;
import org.eclipse.egit.ui.internal.commit.RepositoryCommit;
import org.eclipse.egit.ui.internal.commit.RepositoryCommitOpener;
import org.eclipse.egit.ui.internal.history.FileDiff;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.lib.AbbrevConfig;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.notes.NoteMap;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.TrackingRefUpdate;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.IWorkbenchAdapter3;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.WorkbenchJob;

public class FetchResultTable {
    private final Composite treePanel;
    private final TreeViewer treeViewer;
    private Repository repo;
    private String remoteBranchOfCurrentBranch;
    private int oidLength = 7;

    public FetchResultTable(Composite parent) {
        this.treePanel = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(this.treePanel);
        this.treeViewer = new TreeViewer(this.treePanel);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setAutoExpandLevel(1);
        this.addToolbar(this.treePanel);
        WorkbenchStyledLabelProvider styleProvider = new WorkbenchStyledLabelProvider(){

            @Override
            public StyledString getStyledText(Object element) {
                if (element instanceof IWorkbenchAdapter3) {
                    return ((IWorkbenchAdapter3)element).getStyledText(element);
                }
                return super.getStyledText(element);
            }
        };
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider(styleProvider){

            public String getToolTipText(Object element) {
                if (element instanceof FetchResultAdapter) {
                    switch (((FetchResultAdapter)((Object)element)).update.getResult()) {
                        case FAST_FORWARD: {
                            return UIText.FetchResultTable_statusDetailFastForward;
                        }
                        case FORCED: 
                        case REJECTED: {
                            return UIText.FetchResultTable_statusDetailNonFastForward;
                        }
                        case IO_FAILURE: {
                            return UIText.FetchResultTable_statusDetailIOError;
                        }
                        case LOCK_FAILURE: {
                            return UIText.FetchResultTable_statusDetailCouldntLock;
                        }
                    }
                    return super.getToolTipText(element);
                }
                return super.getToolTipText(element);
            }
        });
        this.treeViewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof FetchResultAdapter && e2 instanceof FetchResultAdapter) {
                    FetchResultAdapter f1 = (FetchResultAdapter)((Object)e1);
                    FetchResultAdapter f2 = (FetchResultAdapter)((Object)e2);
                    if (f1.isRemoteBranch(FetchResultTable.this.remoteBranchOfCurrentBranch)) {
                        return -1;
                    }
                    if (f2.isRemoteBranch(FetchResultTable.this.remoteBranchOfCurrentBranch)) {
                        return 1;
                    }
                    return CommonUtils.STRING_ASCENDING_COMPARATOR.compare(f1.getName(), f2.getName());
                }
                if (e1 instanceof CommitAdapter && e2 instanceof CommitAdapter) {
                    return 0;
                }
                if (e1 instanceof FileDiff && e2 instanceof FileDiff) {
                    FileDiff f1 = (FileDiff)e1;
                    FileDiff f2 = (FileDiff)e2;
                    return f1.getPath().compareTo(f2.getPath());
                }
                return super.compare(viewer, e1, e2);
            }
        });
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
        Tree tree = this.treeViewer.getTree();
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)tree);
        this.treeViewer.setContentProvider((IContentProvider)new BaseWorkbenchContentProvider(tree){
            private DeferredTreeContentManager loader;
            private Object currentInput;
            {
                this.loader = new DeferredTreeContentManager((AbstractTreeViewer)FetchResultTable.this.treeViewer){

                    protected void addChildren(final Object parentItem, final Object[] children, IProgressMonitor monitor) {
                        WorkbenchJob updateJob = new WorkbenchJob(UIText.FetchResultTable_addingChildren){

                            public IStatus runInUIThread(IProgressMonitor updateMonitor) {
                                int topItems;
                                if (((this).this).FetchResultTable.this.treeViewer.getControl().isDisposed() || updateMonitor.isCanceled()) {
                                    return Status.CANCEL_STATUS;
                                }
                                ((this).this).FetchResultTable.this.treeViewer.add(parentItem, children);
                                ((this).this).FetchResultTable.this.treeViewer.update(parentItem, null);
                                if (children.length > 0 && (topItems = tree.getItemCount()) > 0 && parentItem == tree.getItem(0).getData()) {
                                    ((this).this).FetchResultTable.this.treeViewer.expandToLevel(parentItem, 1, true);
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        updateJob.setSystem(true);
                        updateJob.schedule();
                    }
                };
            }

            public void dispose() {
                if (this.loader != null && this.currentInput != null) {
                    this.loader.cancel(this.currentInput);
                }
                this.currentInput = null;
                this.loader = null;
                super.dispose();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                if (this.loader != null && oldInput != null) {
                    this.loader.cancel(oldInput);
                }
                this.currentInput = newInput;
                super.inputChanged(viewer, oldInput, newInput);
            }

            public Object[] getElements(Object inputElement) {
                if (!(inputElement instanceof FetchResult)) {
                    return new Object[0];
                }
                FetchResult result = (FetchResult)inputElement;
                return result.getTrackingRefUpdates().stream().map(arg_0 -> FetchResultAdapter.new(FetchResultTable.this, arg_0)).toArray();
            }

            public Object[] getChildren(Object element) {
                Object[] children = super.getChildren(element);
                if (children != null) {
                    return children;
                }
                if (this.loader == null) {
                    return new Object[0];
                }
                return this.loader.getChildren(element);
            }

            public boolean hasChildren(Object element) {
                if (element instanceof IDeferredWorkbenchAdapter) {
                    return ((IDeferredWorkbenchAdapter)element).isContainer();
                }
                return super.hasChildren(element);
            }
        });
        RepositoryCommitOpener.setup((StructuredViewer)this.treeViewer);
    }

    private void addToolbar(Composite parent) {
        ToolBar toolbar = new ToolBar(parent, 512);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)toolbar);
        UIUtils.addExpansionItems(toolbar, (AbstractTreeViewer)this.treeViewer);
    }

    public void setData(Repository db, FetchResult fetchResult) {
        this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.treeViewer.setInput(null);
        this.repo = db;
        UnitOfWork.execute((Repository)db, () -> {
            try {
                this.oidLength = AbbrevConfig.parseFromConfig((Repository)db).get();
            }
            catch (InvalidConfigurationException e) {
                Activator.logError(e.getLocalizedMessage(), e);
                this.oidLength = 7;
            }
            try {
                String branch = this.repo.getBranch();
                if (branch != null) {
                    this.remoteBranchOfCurrentBranch = this.repo.getConfig().getString("branch", branch, "merge");
                }
            }
            catch (IOException e) {
                this.remoteBranchOfCurrentBranch = null;
            }
        });
        this.treeViewer.setInput((Object)fetchResult);
    }

    private String safeAbbreviate(ObjectId objectId) {
        return objectId.name().substring(0, this.oidLength);
    }

    public Control getControl() {
        return this.treePanel;
    }

    private static class CommitAdapter
    extends RepositoryCommit
    implements IDeferredWorkbenchAdapter,
    ISchedulingRule {
        private volatile FileDiff[] diffs;

        CommitAdapter(Repository repository, RevCommit commit) {
            super(repository, commit);
        }

        @Override
        public Object[] getChildren(Object o) {
            return this.diffs;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (this.diffs != null) {
                return;
            }
            this.diffs = this.getDiffs();
            collector.add((Object[])this.diffs, monitor);
        }

        public boolean isContainer() {
            return true;
        }

        public ISchedulingRule getRule(Object object) {
            return this;
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }
    }

    private class FetchResultAdapter
    extends WorkbenchAdapter
    implements IDeferredWorkbenchAdapter,
    ISchedulingRule {
        private final TrackingRefUpdate update;
        private volatile Object[] children;
        private boolean loadingTriggered;

        public FetchResultAdapter(TrackingRefUpdate update) {
            this.update = update;
        }

        public String getLabel(Object object) {
            return this.getStyledText(object).getString();
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            switch (this.update.getResult()) {
                case LOCK_FAILURE: 
                case REJECTED: 
                case REJECTED_CURRENT_BRANCH: 
                case IO_FAILURE: {
                    return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_ERROR_TSK");
                }
                case FORCED: {
                    if (this.isPruned()) {
                        ImageDescriptor icon = UIIcons.BRANCH;
                        if (this.update.getLocalName().startsWith("refs/tags/")) {
                            icon = UIIcons.TAG;
                        }
                        if (this.update.getLocalName().startsWith("refs/notes/")) {
                            icon = UIIcons.NOTE;
                        }
                        return new DecorationOverlayIcon(icon, UIIcons.OVR_STAGED_REMOVE, 1);
                    }
                }
                case FAST_FORWARD: 
                case RENAMED: {
                    if (this.update.getRemoteName().startsWith("refs/heads/")) {
                        return UIIcons.BRANCH;
                    }
                    if (this.update.getLocalName().startsWith("refs/tags/")) {
                        return UIIcons.TAG;
                    }
                    if (!this.update.getLocalName().startsWith("refs/notes/")) break;
                    return UIIcons.NOTE;
                }
                case NEW: {
                    if (this.update.getRemoteName().startsWith("refs/heads/")) {
                        return UIIcons.CREATE_BRANCH;
                    }
                    if (this.update.getLocalName().startsWith("refs/tags/")) {
                        return UIIcons.CREATE_TAG;
                    }
                    if (!this.update.getLocalName().startsWith("refs/notes/")) break;
                    return UIIcons.NOTE;
                }
            }
            return super.getImageDescriptor(object);
        }

        private void addCommits(StyledString styled, String separator) {
            styled.append('[', StyledString.DECORATIONS_STYLER);
            styled.append(FetchResultTable.this.safeAbbreviate(this.update.getNewObjectId()), StyledString.DECORATIONS_STYLER);
            styled.append(separator, StyledString.DECORATIONS_STYLER);
            styled.append(FetchResultTable.this.safeAbbreviate(this.update.getOldObjectId()), StyledString.DECORATIONS_STYLER);
            styled.append(']', StyledString.DECORATIONS_STYLER);
            Object[] commits = this.getChildren((Object)this);
            if (commits != null) {
                styled.append(MessageFormat.format(UIText.FetchResultTable_counterCommits, commits.length), StyledString.COUNTER_STYLER);
            } else if (!this.loadingTriggered) {
                this.loadingTriggered = true;
                ((ITreeContentProvider)FetchResultTable.this.treeViewer.getContentProvider()).getChildren((Object)this);
            }
        }

        public Object[] getChildren(Object object) {
            return this.children;
        }

        public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
            if (this.children != null) {
                return;
            }
            switch (this.update.getResult()) {
                case FORCED: {
                    if (!this.isPruned()) break;
                    this.children = NO_CHILDREN;
                    return;
                }
                case FAST_FORWARD: {
                    break;
                }
                default: {
                    this.children = NO_CHILDREN;
                    return;
                }
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (RevWalk walk = new RevWalk(FetchResultTable.this.repo);){
                    walk.setRetainBody(true);
                    walk.markStart(walk.parseCommit((AnyObjectId)this.update.getNewObjectId()));
                    walk.markUninteresting(walk.parseCommit((AnyObjectId)this.update.getOldObjectId()));
                    ArrayList<CommitAdapter> commits = new ArrayList<CommitAdapter>();
                    for (RevCommit commit : walk) {
                        if (monitor.isCanceled()) break;
                        commits.add(new CommitAdapter(FetchResultTable.this.repo, commit));
                    }
                    this.children = commits.toArray();
                    collector.add(this.children, monitor);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.logError("Error parsing commits from fetch result", e);
                this.children = NO_CHILDREN;
            }
        }

        protected String shortenRef(String ref) {
            return NoteMap.shortenRefName((String)Repository.shortenRefName((String)ref));
        }

        public StyledString getStyledText(Object object) {
            StyledString styled = new StyledString();
            String remote = this.update.getRemoteName();
            String local = this.update.getLocalName();
            styled.append(this.shortenRef(remote));
            styled.append(" : ", StyledString.QUALIFIER_STYLER);
            styled.append(this.shortenRef(local), StyledString.QUALIFIER_STYLER);
            styled.append(' ');
            switch (this.update.getResult()) {
                case LOCK_FAILURE: {
                    styled.append(UIText.FetchResultTable_statusLockFailure, StyledString.DECORATIONS_STYLER);
                    break;
                }
                case IO_FAILURE: {
                    styled.append(UIText.FetchResultTable_statusIOError, StyledString.DECORATIONS_STYLER);
                    break;
                }
                case NEW: {
                    if (remote.startsWith("refs/heads/")) {
                        styled.append(UIText.FetchResultTable_statusNewBranch, StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    if (local.startsWith("refs/tags/")) {
                        styled.append(UIText.FetchResultTable_statusNewTag, StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    styled.append(UIText.FetchResultTable_statusNew, StyledString.DECORATIONS_STYLER);
                    break;
                }
                case FORCED: {
                    if (this.isPruned()) {
                        styled.append(UIText.FetchResultTable_statusPruned, StyledString.DECORATIONS_STYLER);
                        break;
                    }
                    this.addCommits(styled, "...");
                    break;
                }
                case FAST_FORWARD: {
                    this.addCommits(styled, "..");
                    break;
                }
                case REJECTED: {
                    styled.append(UIText.FetchResultTable_statusRejected, StyledString.DECORATIONS_STYLER);
                    break;
                }
                case NO_CHANGE: {
                    styled.append(UIText.FetchResultTable_statusUpToDate, StyledString.DECORATIONS_STYLER);
                    break;
                }
            }
            return styled;
        }

        private boolean isPruned() {
            return this.update.getNewObjectId().equals((AnyObjectId)ObjectId.zeroId());
        }

        boolean isRemoteBranch(String branchName) {
            return this.update.getRemoteName().equals(branchName);
        }

        String getName() {
            String result = this.update.getRemoteName();
            if (StringUtils.isEmptyOrNull((String)result)) {
                result = this.update.getLocalName();
            }
            return result;
        }

        public boolean isContainer() {
            switch (this.update.getResult()) {
                case FORCED: {
                    return !this.isPruned();
                }
                case FAST_FORWARD: {
                    return true;
                }
            }
            return false;
        }

        public ISchedulingRule getRule(Object object) {
            return this;
        }

        public boolean contains(ISchedulingRule rule) {
            return this == rule;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }
    }
}

