/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.help.IToc;
import org.eclipse.help.ITopic;
import org.eclipse.help.UAContentFilter;
import org.eclipse.help.base.AbstractHelpScope;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.HelpEvaluationContext;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.internal.base.scope.ScopeUtils;
import org.eclipse.help.internal.webapp.data.ActivitiesData;
import org.eclipse.help.internal.webapp.data.RequestScope;
import org.eclipse.help.internal.webapp.data.TopicFinder;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.internal.webapp.servlet.TocFragmentServlet;

public class TocData
extends ActivitiesData {
    public static final String COMPLETE_PATH_PARAM = "cp";
    private String tocParameter;
    private String topicHref;
    private String expandPathParam;
    private String completePath;
    private int selectedToc = -1;
    private int[] rootPath = null;
    private ITopic[] topicPath = null;
    private String numericPath;
    private IToc[] tocs;
    private AbstractHelpScope scope;

    public TocData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
        String pathStr;
        this.tocParameter = request.getParameter("toc");
        this.topicHref = request.getParameter("topic");
        this.completePath = request.getParameter(COMPLETE_PATH_PARAM);
        this.expandPathParam = request.getParameter("expandPath");
        this.scope = RequestScope.getScope(request, response, false);
        if (this.tocParameter != null && this.tocParameter.length() == 0) {
            this.tocParameter = null;
        }
        if (this.topicHref != null && this.topicHref.length() == 0) {
            this.topicHref = null;
        }
        if (this.expandPathParam != null && this.expandPathParam.length() == 0) {
            this.expandPathParam = null;
        }
        if (this.completePath != null && this.completePath.length() == 0) {
            this.completePath = null;
        }
        String anchor = request.getParameter("anchor");
        if (this.topicHref != null && anchor != null) {
            this.topicHref = String.valueOf(this.topicHref) + '#' + anchor;
        }
        if ((pathStr = request.getParameter("path")) != null && pathStr.length() > 0) {
            String[] paths = pathStr.split("_", -1);
            int[] indexes = new int[paths.length];
            boolean indexesOK = true;
            int i = 0;
            while (i < paths.length) {
                try {
                    indexes[i] = Integer.parseInt(paths[i]);
                }
                catch (NumberFormatException numberFormatException) {
                    indexesOK = false;
                    break;
                }
                if (indexesOK) {
                    this.rootPath = indexes;
                }
                ++i;
            }
        }
        this.loadTocs();
    }

    public boolean isRemoteHelpError() {
        boolean isError;
        boolean bl = isError = RemoteHelp.getError() != null;
        if (isError) {
            RemoteHelp.clearError();
        }
        return isError;
    }

    public int getTocCount() {
        return this.tocs.length;
    }

    public String getTocLabel(int i) {
        return this.tocs[i].getLabel();
    }

    public String getTocHref(int i) {
        return this.tocs[i].getHref();
    }

    public String getTocDescriptionTopic(int i) {
        return UrlUtil.getHelpURL(this.tocs[i].getTopic(null).getHref());
    }

    public int getSelectedToc() {
        return this.selectedToc;
    }

    public String getSelectedTopic() {
        if (this.topicHref != null && this.topicHref.length() > 0) {
            return UrlUtil.getHelpURL(this.topicHref);
        }
        if (this.selectedToc == -1) {
            return null;
        }
        IToc toc = this.tocs[this.selectedToc];
        ITopic tocDescription = toc.getTopic(null);
        if (tocDescription != null) {
            return UrlUtil.getHelpURL(tocDescription.getHref());
        }
        return UrlUtil.getHelpURL(null);
    }

    public String getSelectedTopicWithPath() {
        String href = this.getSelectedTopic();
        if (this.completePath != null) {
            href = TocFragmentServlet.fixupHref(href, this.completePath);
        }
        return href;
    }

    public IToc[] getTocs() {
        return this.tocs;
    }

    public boolean isEnabled(int toc) {
        return ScopeUtils.showInTree((IToc)this.tocs[toc], (AbstractHelpScope)this.scope);
    }

    private boolean isEnabled(IToc toc) {
        return HelpBasePlugin.getActivitySupport().isEnabled(toc.getHref()) && !UAContentFilter.isFiltered((Object)toc, (IEvaluationContext)HelpEvaluationContext.getContext());
    }

    private void loadTocs() {
        this.tocs = HelpPlugin.getTocManager().getTocs(this.getLocale());
        this.selectedToc = -1;
        if (this.isExpandPath()) {
            this.getEnabledTopicPath();
        } else if (this.tocParameter != null && this.tocParameter.length() > 0) {
            int i = 0;
            while (this.selectedToc == -1 && i < this.tocs.length) {
                if (this.tocParameter.equals(this.tocs[i].getHref())) {
                    this.selectedToc = i;
                }
                ++i;
            }
        } else if (this.completePath != null) {
            TopicFinder finder = new TopicFinder("/nav/" + this.completePath, this.tocs, this.scope);
            this.topicPath = finder.getTopicPath();
            this.selectedToc = finder.getSelectedToc();
            this.numericPath = finder.getNumericPath();
        } else {
            TopicFinder finder = new TopicFinder(this.topicHref, this.tocs, this.scope);
            this.topicPath = finder.getTopicPath();
            this.selectedToc = finder.getSelectedToc();
            this.numericPath = finder.getNumericPath();
        }
    }

    private void getEnabledTopicPath() {
        int[] path = UrlUtil.splitPath(this.expandPathParam);
        if (path != null) {
            int enabled = path[0] + 1;
            int i = 0;
            while (enabled > 0 && i < this.tocs.length) {
                if (ScopeUtils.showInTree((IToc)this.tocs[i], (AbstractHelpScope)this.scope) && --enabled == 0) {
                    this.selectedToc = i;
                }
                ++i;
            }
            if (this.selectedToc != -1) {
                this.topicPath = TocData.decodePath(path, this.tocs[this.selectedToc], this.scope);
            }
        } else {
            this.selectedToc = -1;
        }
    }

    public static ITopic[] decodePath(int[] path, IToc toc, AbstractHelpScope scope) {
        ITopic[] topicPath = new ITopic[path.length - 1];
        try {
            if (path.length > 1) {
                ITopic[] topics = toc.getTopics();
                ITopic[] enabledTopics = ScopeUtils.inScopeTopics((ITopic[])topics, (AbstractHelpScope)scope);
                topicPath[0] = enabledTopics[path[1]];
            }
            int i = 1;
            while (i < topicPath.length) {
                ITopic[] topics = topicPath[i - 1].getSubtopics();
                ITopic[] enabledTopics = ScopeUtils.inScopeTopics((ITopic[])topics, (AbstractHelpScope)scope);
                topicPath[i] = enabledTopics[path[i + 1]];
                ++i;
            }
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
        return topicPath;
    }

    public ITopic[] getEnabledSubtopics(Object element) {
        List<ITopic> topics = this.getEnabledSubtopicList(element);
        return topics.toArray(new ITopic[topics.size()]);
    }

    private List<ITopic> getEnabledSubtopicList(Object element) {
        List<ITopic> children;
        if (element instanceof IToc && !this.isEnabled((IToc)element)) {
            return Collections.emptyList();
        }
        if (element instanceof IToc) {
            children = Arrays.asList(((IToc)element).getTopics());
        } else if (element instanceof ITopic) {
            children = Arrays.asList(((ITopic)element).getSubtopics());
        } else {
            return Collections.emptyList();
        }
        ArrayList<ITopic> childTopics = new ArrayList<ITopic>(children.size());
        for (ITopic iTopic : children) {
            ITopic c = iTopic;
            if (c instanceof ITopic) {
                if ((c.getHref() == null || c.getHref().length() <= 0) && this.getEnabledSubtopicList(c).isEmpty() || UAContentFilter.isFiltered((Object)c, (IEvaluationContext)HelpEvaluationContext.getContext())) continue;
                childTopics.add(c);
                continue;
            }
            childTopics.addAll(this.getEnabledSubtopicList(c));
        }
        return childTopics;
    }

    private void generateTopicLinks(ITopic topic, Writer w, int indent) {
        ITopic[] topics;
        String topicHref = topic.getHref();
        try {
            if (indent == 0) {
                w.write("<b>");
            }
            int tab = 0;
            while (tab < indent) {
                w.write("&nbsp;&nbsp;");
                ++tab;
            }
            if (topicHref != null && topicHref.length() > 0) {
                w.write("<a href=\"");
                if ('/' == topicHref.charAt(0)) {
                    w.write("topic");
                }
                w.write(topicHref);
                w.write("\">");
                w.write(UrlUtil.htmlEncode(topic.getLabel()));
                w.write("</a>");
            } else {
                w.write(UrlUtil.htmlEncode(topic.getLabel()));
            }
            w.write("<br>\n");
            if (indent == 0) {
                w.write("</b>");
            }
        }
        catch (IOException iOException) {}
        ITopic[] iTopicArray = topics = topic.getSubtopics();
        int n = topics.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic topic2 = iTopicArray[n2];
            this.generateTopicLinks(topic2, w, indent + 1);
            ++n2;
        }
    }

    public void generateLinks(Writer out) {
        IToc[] iTocArray = this.tocs;
        int n = this.tocs.length;
        int n2 = 0;
        while (n2 < n) {
            ITopic[] topics;
            IToc toc = iTocArray[n2];
            ITopic tocTopic = toc.getTopic(null);
            this.generateTopicLinks(tocTopic, out, 0);
            ITopic[] iTopicArray = topics = toc.getTopics();
            int n3 = topics.length;
            int n4 = 0;
            while (n4 < n3) {
                ITopic topic = iTopicArray[n4];
                this.generateTopicLinks(topic, out, 1);
                ++n4;
            }
            ++n2;
        }
    }

    public ITopic[] getTopicPathFromRootPath(IToc toc) {
        int[] rootPath = this.getRootPath();
        if (rootPath == null) {
            return null;
        }
        int pathLength = rootPath.length;
        ITopic[] topicPath = new ITopic[pathLength];
        ITopic[] children = toc.getTopics();
        int i = 0;
        while (i < pathLength) {
            int index = rootPath[i];
            if (index >= children.length) {
                return null;
            }
            topicPath[i] = children[index];
            children = topicPath[i].getSubtopics();
            ++i;
        }
        return topicPath;
    }

    public ITopic[] getTopicPath() {
        return this.topicPath;
    }

    public int[] getRootPath() {
        return this.rootPath;
    }

    public String getTopicHref() {
        return this.topicHref;
    }

    public String getNumericPath() {
        return this.numericPath;
    }

    public boolean isExpandPath() {
        return this.expandPathParam != null;
    }
}

