/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.RSEPreferencesManager;
import org.eclipse.rse.core.model.Host;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.osgi.framework.Bundle;

public abstract class AbstractRSESystemType
extends PlatformObject
implements IRSESystemType {
    protected String id = null;
    protected String name = null;
    protected String label = null;
    protected String description = null;
    protected Bundle definingBundle = null;
    protected Map properties;

    protected AbstractRSESystemType() {
    }

    public AbstractRSESystemType(String id, String name, String label, String description, Bundle definingBundle) {
        this.id = id;
        this.name = name;
        this.label = label == null ? name : label;
        this.description = description == null ? "" : description;
        this.definingBundle = definingBundle;
        this.properties = new HashMap();
    }

    public boolean equals(Object obj) {
        if (obj instanceof IRSESystemType) {
            return this.id.equals(((IRSESystemType)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        if (this.label == null) {
            return this.getName();
        }
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Bundle getDefiningBundle() {
        return this.definingBundle;
    }

    public String getProperty(String key) {
        return (String)this.properties.get(key);
    }

    public boolean testProperty(String key, boolean expectedValue) {
        Object val = this.properties.get(key);
        if (val instanceof String) {
            return Boolean.valueOf((String)val) == expectedValue;
        }
        return false;
    }

    public boolean isEnabled() {
        if (RSEPreferencesManager.getIsSystemTypeEnabled(this)) {
            ISubSystemConfigurationProxy[] proxies = RSECorePlugin.getTheSystemRegistry().getSubSystemConfigurationProxies();
            int i = 0;
            while (i < proxies.length) {
                if (proxies[i].appliesToSystemType(this)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isLocal() {
        return "org.eclipse.rse.systemtype.local".equals(this.getId()) || this.testProperty("isLocal", true);
    }

    public boolean isWindows() {
        return "org.eclipse.rse.systemtype.windows".equals(this.getId()) || this.isLocal() && System.getProperty("os.name").toLowerCase().startsWith("win") || this.testProperty("isWindows", true);
    }

    public IHost createNewHostInstance(ISystemProfile profile) {
        return new Host(profile);
    }

    public String toString() {
        return String.valueOf(this.getLabel()) + " (" + this.getId() + ")";
    }
}

