/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.databinding.viewers;

import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.property.Properties;
import org.eclipse.core.databinding.property.list.IListProperty;
import org.eclipse.core.databinding.property.set.ISetProperty;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.jface.databinding.swt.DisplayRealm;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableListTreeContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableSetTreeContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;

public class ViewerSupport {
    public static <E> void bind(StructuredViewer viewer, IObservableList<E> input, IValueProperty<? super E, ?> labelProperty) {
        IValueProperty[] labelPropertyArray = new IValueProperty[]{labelProperty};
        ViewerSupport.bind(viewer, input, labelPropertyArray);
    }

    @SafeVarargs
    public static <E> void bind(StructuredViewer viewer, IObservableList<E> input, IValueProperty<? super E, ?> ... labelProperties) {
        ObservableListContentProvider contentProvider = new ObservableListContentProvider();
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }

    public static <E> void bind(StructuredViewer viewer, IObservableSet<E> input, IValueProperty<? super E, ?> labelProperty) {
        IValueProperty[] labelPropertyArray = new IValueProperty[]{labelProperty};
        ViewerSupport.bind(viewer, input, labelPropertyArray);
    }

    @SafeVarargs
    public static <E> void bind(StructuredViewer viewer, IObservableSet<E> input, IValueProperty<? super E, ?> ... labelProperties) {
        ObservableSetContentProvider contentProvider = new ObservableSetContentProvider();
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }

    public static <E> void bind(AbstractTreeViewer viewer, E input, IListProperty<? super E, ? extends E> childrenProperty, IValueProperty<? super E, ?> labelProperty) {
        IValueProperty[] labelPropertyArray = new IValueProperty[]{labelProperty};
        ViewerSupport.bind(viewer, input, childrenProperty, labelPropertyArray);
    }

    @SafeVarargs
    public static <E> void bind(AbstractTreeViewer viewer, E input, IListProperty<? super E, ? extends E> childrenProperty, IValueProperty<? super E, ?> ... labelProperties) {
        Realm realm = DisplayRealm.getRealm(viewer.getControl().getDisplay());
        ObservableListTreeContentProvider contentProvider = new ObservableListTreeContentProvider(childrenProperty.listFactory(realm), null);
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }

    public static <E> void bind(AbstractTreeViewer viewer, E input, ISetProperty<? super E, ? extends E> childrenProperty, IValueProperty<? super E, ?> labelProperty) {
        IValueProperty[] labelPropertyArray = new IValueProperty[]{labelProperty};
        ViewerSupport.bind(viewer, input, childrenProperty, labelPropertyArray);
    }

    @SafeVarargs
    public static <E> void bind(AbstractTreeViewer viewer, E input, ISetProperty<? super E, ? extends E> childrenProperty, IValueProperty<? super E, ?> ... labelProperties) {
        Realm realm = DisplayRealm.getRealm(viewer.getControl().getDisplay());
        ObservableSetTreeContentProvider contentProvider = new ObservableSetTreeContentProvider(childrenProperty.setFactory(realm), null);
        if (viewer.getInput() != null) {
            viewer.setInput(null);
        }
        viewer.setContentProvider(contentProvider);
        viewer.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(Properties.observeEach(contentProvider.getKnownElements(), labelProperties)));
        if (input != null) {
            viewer.setInput(input);
        }
    }
}

