/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files;

import java.util.Vector;
import org.eclipse.rse.services.files.DefaultFileServiceCodePageConverter;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IFileServiceCodePageConverter;

public class CodePageConverterManager {
    private static IFileServiceCodePageConverter _defaultCodePageConverter;
    protected static Vector _codePageConverters;

    static {
        _codePageConverters = new Vector();
    }

    public static void registerCodePageConverter(IFileServiceCodePageConverter converter) {
        _codePageConverters.add(converter);
    }

    public static IFileServiceCodePageConverter getDefaultCodePageConverter() {
        if (_defaultCodePageConverter == null) {
            _defaultCodePageConverter = new DefaultFileServiceCodePageConverter();
        }
        return _defaultCodePageConverter;
    }

    public static IFileServiceCodePageConverter getCodePageConverter(String serverEncoding, IFileService fileService) {
        IFileServiceCodePageConverter matchingCodePageConverter = null;
        if (_codePageConverters != null) {
            int i = 0;
            while (i < _codePageConverters.size()) {
                IFileServiceCodePageConverter codePageConverter = (IFileServiceCodePageConverter)_codePageConverters.elementAt(i);
                if (codePageConverter.isServerEncodingSupported(serverEncoding, fileService)) {
                    if (matchingCodePageConverter != null) {
                        int matchingPriority = matchingCodePageConverter.getPriority(serverEncoding, fileService);
                        int newPriority = codePageConverter.getPriority(serverEncoding, fileService);
                        if (newPriority < matchingPriority) {
                            matchingCodePageConverter = codePageConverter;
                        }
                    } else {
                        matchingCodePageConverter = codePageConverter;
                    }
                }
                ++i;
            }
        }
        if (matchingCodePageConverter == null) {
            matchingCodePageConverter = CodePageConverterManager.getDefaultCodePageConverter();
        }
        return matchingCodePageConverter;
    }
}

