/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.view;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SystemComboBoxCellEditor
extends CellEditor {
    private boolean readOnly = false;
    private String[] items;
    private int selection = 0;
    private CCombo comboBox;

    public SystemComboBoxCellEditor(Composite parent, String[] items) {
        super(parent);
        if (items != null) {
            this.setItems(items);
        } else {
            this.setValueValid(true);
        }
    }

    public SystemComboBoxCellEditor(Composite parent) {
        super(parent);
        this.setValueValid(true);
    }

    public void setItems(String[] items) {
        this.items = items;
        this.populateComboBoxItems();
        this.setValueValid(true);
    }

    protected Control createControl(Composite parent) {
        this.comboBox = !this.readOnly ? new CCombo(parent, 0) : new CCombo(parent, 8);
        this.comboBox.setFont(parent.getFont());
        this.comboBox.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                SystemComboBoxCellEditor.this.keyReleaseOccured(e);
            }
        });
        this.comboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (SystemComboBoxCellEditor.this.selection == SystemComboBoxCellEditor.this.comboBox.getSelectionIndex() && SystemComboBoxCellEditor.this.comboBox.getText().equals(SystemComboBoxCellEditor.this.comboBox.getItem(SystemComboBoxCellEditor.this.comboBox.getSelectionIndex()))) {
                    return;
                }
                SystemComboBoxCellEditor.this.selection = SystemComboBoxCellEditor.this.comboBox.getSelectionIndex();
                Object newValue = SystemComboBoxCellEditor.this.doGetValue();
                boolean newValidState = SystemComboBoxCellEditor.this.isCorrect(newValue);
                if (newValidState) {
                    SystemComboBoxCellEditor.this.doSetValue(newValue);
                } else {
                    SystemComboBoxCellEditor.this.setErrorMessage(NLS.bind((String)SystemComboBoxCellEditor.this.getErrorMessage(), (Object)SystemComboBoxCellEditor.this.items[SystemComboBoxCellEditor.this.selection]));
                }
                SystemComboBoxCellEditor.this.fireApplyEditorValue();
            }
        });
        this.comboBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.detail == 2 || e.detail == 4) {
                    e.doit = false;
                }
            }
        });
        return this.comboBox;
    }

    protected Object doGetValue() {
        return new Integer(this.selection);
    }

    protected void doSetFocus() {
        this.comboBox.setFocus();
    }

    protected void doSetValue(Object value) {
        if (!(value instanceof Integer)) {
            String[] items = this.comboBox.getItems();
            int i = 0;
            while (i < items.length) {
                String item = items[i];
                if (item.equals(value)) {
                    this.selection = i;
                }
                ++i;
            }
            return;
        }
        int newselection = (Integer)value;
        if (newselection != this.selection) {
            this.selection = newselection;
        }
        String curText = this.comboBox.getText();
        if (!this.comboBox.getItem(this.selection).equals(curText)) {
            this.comboBox.select(this.selection);
        }
    }

    private void populateComboBoxItems() {
        if (this.comboBox != null && this.items != null) {
            this.comboBox.removeAll();
            int i = 0;
            while (i < this.items.length) {
                this.comboBox.add(this.items[i], i);
                ++i;
            }
            this.setValueValid(true);
        }
    }
}

