/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.ContentTypeToLanguageServerDefinition;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.part.FileEditorInput;

public class LanguageServiceAccessor {
    private static final Set<@NonNull LanguageServerWrapper> startedServers = new CopyOnWriteArraySet<LanguageServerWrapper>();
    private static final Map<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition> providersToLSDefinitions = new HashMap<StreamConnectionProvider, LanguageServersRegistry.LanguageServerDefinition>();

    private LanguageServiceAccessor() {
    }

    public static void clearStartedServers() {
        startedServers.removeIf(server -> {
            server.stop();
            server.stopDispatcher();
            return true;
        });
    }

    @Deprecated(forRemoval=true)
    public static @NonNull List<CompletableFuture<LanguageServer>> getInitializedLanguageServers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) throws IOException {
        return LanguageServiceAccessor.getLSWrappers(file, request).stream().map(LanguageServerWrapper::getInitializedServer).toList();
    }

    public static void disableLanguageServerContentType(@NonNull ContentTypeToLanguageServerDefinition contentTypeToLSDefinition) {
        IContentType contentType;
        Optional<LanguageServerWrapper> result = startedServers.stream().filter(server -> server.serverDefinition.equals(contentTypeToLSDefinition.getValue())).findFirst();
        if (result.isPresent() && (contentType = (IContentType)contentTypeToLSDefinition.getKey()) != null) {
            result.get().disconnectContentType(contentType);
        }
    }

    @Deprecated(forRemoval=true)
    public static boolean isStillRunning(LanguageServer server) {
        return startedServers.stream().anyMatch(wrapper -> wrapper.isWrapperFor(server) && wrapper.isActive());
    }

    /*
     * WARNING - void declaration
     */
    public static void enableLanguageServerContentType(@NonNull ContentTypeToLanguageServerDefinition contentTypeToLSDefinition, @NonNull IEditorReference[] editors) {
        IContentType contentType = (IContentType)contentTypeToLSDefinition.getKey();
        if (contentType == null) {
            return;
        }
        LanguageServersRegistry.LanguageServerDefinition lsDefinition = (LanguageServersRegistry.LanguageServerDefinition)contentTypeToLSDefinition.getValue();
        if (lsDefinition == null) {
            return;
        }
        IEditorReference[] iEditorReferenceArray = editors;
        int n = editors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference editor = iEditorReferenceArray[n2];
            try {
                IEditorInput iEditorInput = editor.getEditorInput();
                if (iEditorInput instanceof FileEditorInput) {
                    void editorInput;
                    FileEditorInput cfr_ignored_0 = (FileEditorInput)iEditorInput;
                    FileEditorInput cfr_ignored_1 = (FileEditorInput)iEditorInput;
                    IFile editorFile = editorInput.getFile();
                    IContentDescription contentDesc = editorFile.getContentDescription();
                    if (contentDesc != null && contentType.equals(contentDesc.getContentType()) && contentTypeToLSDefinition.isEnabled(editorFile.getLocationURI())) {
                        LanguageServiceAccessor.getInitializedLanguageServer((IResource)editorFile, lsDefinition, (ServerCapabilities capabilities) -> true);
                    }
                }
            }
            catch (Exception e) {
                LanguageServerPlugin.logError(e);
            }
            ++n2;
        }
    }

    @Deprecated(forRemoval=true)
    public static LanguageServer getLanguageServer(@NonNull IFile file, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper(file.getProject(), lsDefinition, file.getFullPath());
        if (LanguageServiceAccessor.capabilitiesComply(wrapper, capabilitiesPredicate)) {
            wrapper.connect(file, null);
            return wrapper.getServer();
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static CompletableFuture<LanguageServer> getInitializedLanguageServer(@NonNull IResource resource, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapper(resource.getProject(), lsDefinition, resource.getFullPath());
        if (LanguageServiceAccessor.capabilitiesComply(wrapper, capabilitiesPredicate)) {
            return wrapper.getInitializedServer();
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    public static CompletableFuture<LanguageServer> getInitializedLanguageServer(@NonNull IDocument document, @NonNull LanguageServersRegistry.LanguageServerDefinition lsDefinition, Predicate<ServerCapabilities> capabilitiesPredicate) throws IOException {
        IPath initialPath = LSPEclipseUtils.toPath(document);
        LanguageServerWrapper wrapper = LanguageServiceAccessor.getLSWrapperForConnection(document, lsDefinition, initialPath);
        if (LanguageServiceAccessor.capabilitiesComply(wrapper, capabilitiesPredicate)) {
            return wrapper.getInitializedServer();
        }
        return null;
    }

    private static boolean capabilitiesComply(LanguageServerWrapper wrapper, Predicate<ServerCapabilities> capabilitiesPredicate) {
        return capabilitiesPredicate == null || wrapper.getServerCapabilities() == null || capabilitiesPredicate.test(wrapper.getServerCapabilities());
    }

    public static @NonNull List<LanguageServerWrapper> getLSWrappers(@NonNull IFile file, @Nullable Predicate<ServerCapabilities> request) throws IOException {
        IProject project = file.getProject();
        if (project == null) {
            return Collections.emptyList();
        }
        LanguageServersRegistry lsRegistry = LanguageServersRegistry.getInstance();
        URI fileURI = file.getLocationURI();
        List<@NonNull LanguageServerWrapper> wrappers = LanguageServiceAccessor.getStartedWrappers(file.getProject(), request, true);
        wrappers.removeIf(wrapper -> !wrapper.isConnectedTo(fileURI) || !lsRegistry.matches(file, wrapper.serverDefinition));
        List<IContentType> directContentTypes = LSPEclipseUtils.getFileContentTypes(file);
        ArrayDeque<IContentType> contentTypesToProcess = new ArrayDeque<IContentType>(directContentTypes);
        HashSet<IContentType> processedContentTypes = new HashSet<IContentType>(directContentTypes.size());
        while (!contentTypesToProcess.isEmpty()) {
            IContentType contentType = contentTypesToProcess.poll();
            if (contentType == null || processedContentTypes.contains(contentType)) continue;
            for (ContentTypeToLanguageServerDefinition mapping : lsRegistry.findProviderFor(contentType)) {
                LanguageServerWrapper wrapper2;
                LanguageServersRegistry.LanguageServerDefinition serverDefinition;
                if (!mapping.isEnabled(fileURI) || (serverDefinition = (LanguageServersRegistry.LanguageServerDefinition)mapping.getValue()) == null || wrappers.contains(wrapper2 = LanguageServiceAccessor.getLSWrapper(project, serverDefinition, file.getFullPath())) || !LanguageServiceAccessor.capabilitiesComply(wrapper2, request)) continue;
                wrappers.add(wrapper2);
            }
            if (contentType.getBaseType() != null) {
                contentTypesToProcess.add(contentType.getBaseType());
            }
            processedContentTypes.add(contentType);
        }
        return wrappers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(forRemoval=true)
    static @NonNull Collection<LanguageServerWrapper> getLSWrappers(@NonNull IDocument document) {
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return Collections.emptyList();
        }
        LanguageServersRegistry lsRegistry = LanguageServersRegistry.getInstance();
        Predicate<LanguageServerWrapper> selectServersForDocument = wrapper -> {
            try {
                return wrapper.isConnectedTo(uri) || lsRegistry.matches(document, wrapper.serverDefinition) && wrapper.canOperate(document);
            }
            catch (Exception ex) {
                LanguageServerPlugin.logError(ex);
                return false;
            }
        };
        @NonNull LinkedHashSet res = startedServers.stream().filter(selectServersForDocument).collect(Collectors.toCollection(LinkedHashSet::new));
        List<IContentType> directContentTypes = LSPEclipseUtils.getDocumentContentTypes(document);
        ArrayDeque<IContentType> contentTypesToProcess = new ArrayDeque<IContentType>(directContentTypes);
        HashSet<IContentType> processedContentTypes = new HashSet<IContentType>(directContentTypes.size());
        Path path = new Path(uri.getPath());
        IFile file = LSPEclipseUtils.getFile(document);
        while (!contentTypesToProcess.isEmpty()) {
            IContentType contentType = contentTypesToProcess.poll();
            if (contentType == null || processedContentTypes.contains(contentType)) continue;
            for (ContentTypeToLanguageServerDefinition mapping : lsRegistry.findProviderFor(contentType)) {
                LanguageServersRegistry.LanguageServerDefinition serverDefinition;
                if (!mapping.isEnabled(uri) || (serverDefinition = (LanguageServersRegistry.LanguageServerDefinition)mapping.getValue()) == null) continue;
                Predicate<LanguageServerWrapper> selectServersWithEqualDefinition = wrapper -> wrapper.serverDefinition.equals(serverDefinition);
                if (res.stream().anyMatch(selectServersWithEqualDefinition)) continue;
                Set<LanguageServerWrapper> set = startedServers;
                synchronized (set) {
                    startedServers.stream().filter(selectServersForDocument).forEach(res::add);
                    if (res.stream().anyMatch(selectServersWithEqualDefinition)) {
                        continue;
                    }
                    IProject fileProject = file != null ? file.getProject() : null;
                    LanguageServerWrapper wrapper2 = fileProject != null ? new LanguageServerWrapper(fileProject, serverDefinition) : new LanguageServerWrapper(serverDefinition, (IPath)path);
                    startedServers.add(wrapper2);
                    res.add(wrapper2);
                }
            }
            if (contentType.getBaseType() != null) {
                contentTypesToProcess.add(contentType.getBaseType());
            }
            processedContentTypes.add(contentType);
        }
        return res;
    }

    public static @NonNull LanguageServerWrapper getLSWrapper(@Nullable IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) throws IOException {
        return LanguageServiceAccessor.getLSWrapper(project, serverDefinition, null);
    }

    @Deprecated(forRemoval=true)
    public static LanguageServerWrapper getLSWrapperForConnection(@NonNull IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) throws IOException {
        return LanguageServiceAccessor.getLSWrapper(project, serverDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static @NonNull LanguageServerWrapper getLSWrapper(@Nullable IProject project, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) throws IOException {
        Predicate<LanguageServerWrapper> serverSelector = wrapper -> project != null && wrapper.canOperate(project) && wrapper.serverDefinition.equals(serverDefinition);
        Optional<LanguageServerWrapper> matchingServer = startedServers.stream().filter(serverSelector).findFirst();
        if (matchingServer.isPresent()) {
            return matchingServer.get();
        }
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            matchingServer = startedServers.stream().filter(serverSelector).findFirst();
            if (matchingServer.isPresent()) {
                return matchingServer.get();
            }
            LanguageServerWrapper wrapper2 = project != null ? new LanguageServerWrapper(project, serverDefinition) : new LanguageServerWrapper(serverDefinition, initialPath);
            wrapper2.start();
            startedServers.add(wrapper2);
            return wrapper2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull LanguageServerWrapper startLanguageServer(@NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition) throws IOException {
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            LanguageServerWrapper wrapper = startedServers.stream().filter(w -> w.serverDefinition == serverDefinition).findFirst().orElseGet(() -> {
                LanguageServerWrapper w = new LanguageServerWrapper(serverDefinition, null);
                startedServers.add(w);
                return w;
            });
            if (!wrapper.isActive()) {
                wrapper.start();
            }
            return wrapper;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LanguageServerWrapper getLSWrapperForConnection(@NonNull IDocument document, @NonNull LanguageServersRegistry.LanguageServerDefinition serverDefinition, @Nullable IPath initialPath) throws IOException {
        Predicate<LanguageServerWrapper> serverSelector = wrapper -> wrapper.canOperate(document) && wrapper.serverDefinition.equals(serverDefinition);
        Optional<LanguageServerWrapper> matchingServer = startedServers.stream().filter(serverSelector).findFirst();
        if (matchingServer.isPresent()) {
            return matchingServer.get();
        }
        Set<LanguageServerWrapper> set = startedServers;
        synchronized (set) {
            matchingServer = startedServers.stream().filter(serverSelector).findFirst();
            if (matchingServer.isPresent()) {
                return matchingServer.get();
            }
            LanguageServerWrapper wrapper2 = new LanguageServerWrapper(serverDefinition, initialPath);
            wrapper2.start();
            startedServers.add(wrapper2);
            return wrapper2;
        }
    }

    public static @NonNull List<@NonNull LanguageServerWrapper> getStartedWrappers(@Nullable IProject project, Predicate<ServerCapabilities> request, boolean onlyActiveLS) {
        ArrayList<@NonNull LanguageServerWrapper> result = new ArrayList<LanguageServerWrapper>();
        for (LanguageServerWrapper wrapper : startedServers) {
            if (onlyActiveLS && !wrapper.isActive() || project != null && !wrapper.canOperate(project) || !LanguageServiceAccessor.capabilitiesComply(wrapper, request)) continue;
            result.add(wrapper);
        }
        return result;
    }

    @Deprecated(forRemoval=true)
    public static @NonNull List<@NonNull LanguageServer> getActiveLanguageServers(Predicate<ServerCapabilities> request) {
        return LanguageServiceAccessor.getLanguageServers(null, request, true);
    }

    @Deprecated(forRemoval=true)
    public static @NonNull List<@NonNull LanguageServer> getLanguageServers(@NonNull IProject project, Predicate<ServerCapabilities> request) {
        return LanguageServiceAccessor.getLanguageServers(project, request, false);
    }

    @Deprecated(forRemoval=true)
    public static @NonNull List<@NonNull LanguageServer> getLanguageServers(@Nullable IProject project, Predicate<ServerCapabilities> request, boolean onlyActiveLS) {
        List<@NonNull LanguageServerWrapper> wrappers = LanguageServiceAccessor.getStartedWrappers(project, request, onlyActiveLS);
        ArrayList<LanguageServer> servers = new ArrayList<LanguageServer>(wrappers.size());
        for (LanguageServerWrapper wrapper : wrappers) {
            @Nullable LanguageServer server = wrapper.getServer();
            if (server == null) continue;
            servers.add(server);
        }
        return servers;
    }

    protected static LanguageServersRegistry.LanguageServerDefinition getLSDefinition(@NonNull StreamConnectionProvider provider) {
        return providersToLSDefinitions.get(provider);
    }

    @Deprecated(forRemoval=true)
    public static @NonNull List<@NonNull LSPDocumentInfo> getLSPDocumentInfosFor(@NonNull IDocument document, @NonNull Predicate<ServerCapabilities> capabilityRequest) {
        URI fileUri = LSPEclipseUtils.toUri(document);
        ArrayList<LSPDocumentInfo> res = new ArrayList<LSPDocumentInfo>();
        try {
            LanguageServiceAccessor.getLSWrappers(document).stream().filter(wrapper -> wrapper.getServerCapabilities() == null || capabilityRequest.test(wrapper.getServerCapabilities())).forEach(wrapper -> {
                try {
                    wrapper.connect(document);
                }
                catch (IOException e) {
                    LanguageServerPlugin.logError(e);
                }
                res.add(new LSPDocumentInfo(fileUri, document, (LanguageServerWrapper)wrapper));
            });
        }
        catch (Exception e) {
            LanguageServerPlugin.logError(e);
        }
        return res;
    }

    @Deprecated(forRemoval=true)
    public static @NonNull CompletableFuture<List<@NonNull LanguageServer>> getLanguageServers(@NonNull IDocument document, Predicate<ServerCapabilities> filter) {
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        List res = Collections.synchronizedList(new ArrayList());
        try {
            return CompletableFuture.allOf((CompletableFuture[])LanguageServiceAccessor.getLSWrappers(document).stream().map(wrapper -> ((CompletableFuture)wrapper.getInitializedServer().thenComposeAsync(server -> {
                if (server != null && (filter == null || filter.test(wrapper.getServerCapabilities()))) {
                    try {
                        return wrapper.connect(document);
                    }
                    catch (IOException ex) {
                        LanguageServerPlugin.logError(ex);
                    }
                }
                return CompletableFuture.completedFuture(null);
            })).thenAccept(server -> {
                if (server != null) {
                    res.add(server);
                }
            })).toArray(CompletableFuture[]::new)).thenApply(theVoid -> res);
        }
        catch (Exception e) {
            LanguageServerPlugin.logError(e);
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
    }

    static void shutdownAllDispatchers() {
        startedServers.forEach(LanguageServerWrapper::stopDispatcher);
    }

    @Deprecated(forRemoval=true)
    public static boolean checkCapability(LanguageServer languageServer, Predicate<ServerCapabilities> condition) {
        return startedServers.stream().filter(wrapper -> wrapper.isActive() && wrapper.getServer() == languageServer).anyMatch(wrapper -> condition.test(wrapper.getServerCapabilities()));
    }

    @Deprecated(forRemoval=true)
    public static Optional<LanguageServerWrapper> resolveLanguageServerWrapper(LanguageServer languageServer) {
        return startedServers.stream().filter(wrapper -> languageServer.equals(wrapper.getServer())).findFirst();
    }

    @Deprecated(forRemoval=true)
    public static Optional<LanguageServersRegistry.LanguageServerDefinition> resolveServerDefinition(LanguageServer languageServer) {
        return LanguageServiceAccessor.resolveLanguageServerWrapper(languageServer).map(w -> w.serverDefinition);
    }

    @Deprecated(forRemoval=true)
    public static class LSPDocumentInfo {
        private final @NonNull URI fileUri;
        private final @NonNull IDocument document;
        private final @NonNull LanguageServerWrapper wrapper;

        private LSPDocumentInfo(@NonNull URI fileUri, @NonNull IDocument document, @NonNull LanguageServerWrapper wrapper) {
            this.fileUri = fileUri;
            this.document = document;
            this.wrapper = wrapper;
        }

        public @NonNull IDocument getDocument() {
            return this.document;
        }

        public @NonNull URI getFileUri() {
            return this.fileUri;
        }

        @Deprecated(forRemoval=true)
        public LanguageServer getLanguageClient() {
            try {
                return this.wrapper.getInitializedServer().get();
            }
            catch (ExecutionException e) {
                LanguageServerPlugin.logError(e);
                return this.wrapper.getServer();
            }
            catch (InterruptedException e) {
                LanguageServerPlugin.logError(e);
                Thread.currentThread().interrupt();
                return this.wrapper.getServer();
            }
        }

        public LanguageServerWrapper getLanguageServerWrapper() {
            return this.wrapper;
        }

        public int getVersion() {
            return this.wrapper.getVersion(this.fileUri);
        }

        @Deprecated(forRemoval=true)
        public CompletableFuture<LanguageServer> getInitializedLanguageClient() {
            return this.wrapper.getInitializedServer();
        }

        public @Nullable ServerCapabilities getCapabilites() {
            return this.wrapper.getServerCapabilities();
        }

        public boolean isActive() {
            return this.wrapper.isActive();
        }
    }

    @FunctionalInterface
    private static interface ServerSupplier {
        public LanguageServerWrapper get() throws IOException;
    }
}

