/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.format;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.commands.ExpressionContext;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServersRegistry;
import org.eclipse.lsp4e.VersionedEdits;
import org.eclipse.lsp4e.operations.format.LSPFormatter;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class LSPFormatFilesHandler
extends AbstractHandler {
    private static final int SINGLE_FILE_TIMEOUT_MS = 5000;
    protected final LSPFormatter formatter = new LSPFormatter();

    /*
     * WARNING - void declaration
     */
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object object = event.getApplicationContext();
        if (object instanceof ExpressionContext) {
            void ctx;
            ExpressionContext expressionContext = (ExpressionContext)object;
            ExpressionContext cfr_ignored_0 = (ExpressionContext)object;
            Job job = Job.create((String)Messages.LSPFormatFilesHandler_FormattingSelectedFiles, arg_0 -> this.lambda$0((ExpressionContext)ctx, arg_0));
            job.setPriority(40);
            job.schedule();
        }
        return null;
    }

    protected void formatFile(@NonNull IFile file, IProgressMonitor monitor) {
        if (!file.exists() || !LanguageServersRegistry.getInstance().canUseLanguageServer(file)) {
            return;
        }
        IDocumentProvider docProvider = this.getDocumentProvider(file);
        try {
            docProvider.connect((Object)file);
            IDocument doc = docProvider.getDocument((Object)file);
            if (doc == null) {
                return;
            }
            try {
                monitor.setTaskName(NLS.bind((String)Messages.LSPFormatFilesHandler_FormattingFile, (Object)file.getFullPath()));
                Optional<VersionedEdits> formatting = this.formatter.requestFormatting(doc, (ITextSelection)new TextSelection(0, 0)).get(5000L, TimeUnit.MILLISECONDS);
                formatting.ifPresent(edits -> {
                    docProvider.aboutToChange((Object)doc);
                    UI.getDisplay().syncExec(() -> {
                        try {
                            edits.apply();
                        }
                        catch (ConcurrentModificationException | BadLocationException e) {
                            LanguageServerPlugin.logError(e);
                        }
                    });
                    docProvider.changed((Object)doc);
                    try {
                        docProvider.saveDocument(monitor, (Object)file, doc, true);
                    }
                    catch (CoreException e) {
                        LanguageServerPlugin.logError(e);
                    }
                });
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                LanguageServerPlugin.logError(ex);
            }
            catch (Exception ex) {
                LanguageServerPlugin.logError(ex);
            }
        }
        finally {
            docProvider.disconnect((Object)file);
        }
    }

    protected IDocumentProvider getDocumentProvider(IFile file) {
        return DocumentProviderRegistry.getDefault().getDocumentProvider((IEditorInput)new FileEditorInput(file));
    }

    /*
     * WARNING - void declaration
     */
    protected Set<@NonNull IFile> getSelectedFiles(ExpressionContext ctx) {
        Collection<?> selection = this.getSelection(ctx);
        if (selection.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<IFile> files = new HashSet<IFile>();
        for (Object item : selection) {
            try {
                void resource;
                Object obj = item;
                if (!(obj instanceof IResource)) continue;
                IResource cfr_ignored_0 = (IResource)obj;
                IResource cfr_ignored_1 = (IResource)obj;
                void var11_10 = resource;
                if (var11_10 instanceof IFile) {
                    void file;
                    IFile cfr_ignored_2 = (IFile)var11_10;
                    IFile cfr_ignored_3 = (IFile)var11_10;
                    files.add((IFile)file);
                    continue;
                }
                if (!(resource instanceof IProject) && !(resource instanceof IFolder)) continue;
                resource.accept(childResource -> {
                    if (childResource.isLinked() || childResource.isVirtual()) {
                        return false;
                    }
                    IResource iResource = childResource;
                    if (iResource instanceof IFile) {
                        void file;
                        IFile iFile = (IFile)iResource;
                        IFile cfr_ignored_0 = (IFile)iResource;
                        files.add((IFile)file);
                        return false;
                    }
                    return true;
                });
            }
            catch (CoreException ex) {
                LanguageServerPlugin.logError(ex);
            }
        }
        return files;
    }

    /*
     * WARNING - void declaration
     */
    protected Collection<?> getSelection(ExpressionContext ctx) {
        Object defVariable = ctx.getDefaultVariable();
        Object object = defVariable;
        if (object instanceof Collection) {
            void defVariableAsCollection;
            Collection collection = (Collection)object;
            Collection cfr_ignored_0 = (Collection)object;
            return defVariableAsCollection;
        }
        return List.of(defVariable);
    }

    /*
     * WARNING - void declaration
     */
    public void setEnabled(Object evaluationContext) {
        block5: {
            Collection<?> selection;
            block7: {
                block6: {
                    void ctx;
                    Object object = evaluationContext;
                    if (!(object instanceof ExpressionContext)) break block5;
                    ExpressionContext expressionContext = (ExpressionContext)object;
                    ExpressionContext cfr_ignored_0 = (ExpressionContext)object;
                    selection = this.getSelection((ExpressionContext)ctx);
                    if (selection.isEmpty()) {
                        this.setBaseEnabled(false);
                        return;
                    }
                    if (selection.size() > 1) break block6;
                    if (!selection.stream().anyMatch(IContainer.class::isInstance)) break block7;
                }
                this.setBaseEnabled(true);
                return;
            }
            Object obj = selection.iterator().next();
            if (obj instanceof IFile) {
                void file;
                IFile iFile = (IFile)obj;
                IFile cfr_ignored_1 = (IFile)obj;
                this.setBaseEnabled(LanguageServersRegistry.getInstance().canUseLanguageServer((IFile)file));
                return;
            }
        }
        this.setBaseEnabled(false);
    }

    private /* synthetic */ void lambda$0(ExpressionContext expressionContext, IProgressMonitor monitor) throws CoreException {
        Set<IFile> selectedFiles = this.getSelectedFiles(expressionContext);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)selectedFiles.size());
        for (IFile file : selectedFiles) {
            if (subMonitor.isCanceled()) {
                return;
            }
            this.formatFile(file, monitor);
            subMonitor.worked(1);
        }
        subMonitor.done();
    }
}

