/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.TaskContainer;
import org.apache.tools.ant.taskdefs.optional.ssh.SSHBase;

public class SSHSession
extends SSHBase {
    private long maxwait = 0L;
    private final List<LocalTunnel> localTunnels = new Vector<LocalTunnel>();
    private final Set<Integer> localPortsUsed = new TreeSet<Integer>();
    private final List<RemoteTunnel> remoteTunnels = new Vector<RemoteTunnel>();
    private final Set<Integer> remotePortsUsed = new TreeSet<Integer>();
    private NestedSequential nestedSequential = null;
    private static final String TIMEOUT_MESSAGE = "Timeout period exceeded, connection dropped.";
    private final List<Task> nestedTasks = new Vector<Task>();

    public void addTask(Task nestedTask) {
        this.nestedTasks.add(nestedTask);
    }

    public void setTimeout(long timeout) {
        this.maxwait = timeout;
    }

    public void setLocaltunnels(String tunnels) {
        for (String tunnelSpec : tunnels.split(", ")) {
            if (tunnelSpec.isEmpty()) continue;
            String[] spec = tunnelSpec.split(":", 3);
            int lport = Integer.parseInt(spec[0]);
            String rhost = spec[1];
            int rport = Integer.parseInt(spec[2]);
            LocalTunnel tunnel = this.createLocalTunnel();
            tunnel.setLPort(lport);
            tunnel.setRHost(rhost);
            tunnel.setRPort(rport);
        }
    }

    public void setRemotetunnels(String tunnels) {
        for (String tunnelSpec : tunnels.split(", ")) {
            if (tunnelSpec.isEmpty()) continue;
            String[] spec = tunnelSpec.split(":", 3);
            int rport = Integer.parseInt(spec[0]);
            String lhost = spec[1];
            int lport = Integer.parseInt(spec[2]);
            RemoteTunnel tunnel = this.createRemoteTunnel();
            tunnel.setRPort(rport);
            tunnel.setLHost(lhost);
            tunnel.setLPort(lport);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws BuildException {
        if (this.getHost() == null) {
            throw new BuildException("Host is required.");
        }
        this.loadSshConfig();
        if (this.getUserInfo().getName() == null) {
            throw new BuildException("Username is required.");
        }
        if (this.getUserInfo().getKeyfile() == null && this.getUserInfo().getPassword() == null) {
            throw new BuildException("Password or Keyfile is required.");
        }
        if (this.nestedSequential == null) {
            throw new BuildException("Missing sequential element.");
        }
        Session session = null;
        try {
            session = this.openSession();
            session.setTimeout((int)this.maxwait);
            for (LocalTunnel localTunnel : this.localTunnels) {
                session.setPortForwardingL(localTunnel.getLPort(), localTunnel.getRHost(), localTunnel.getRPort());
            }
            for (RemoteTunnel remoteTunnel : this.remoteTunnels) {
                session.setPortForwardingR(remoteTunnel.getRPort(), remoteTunnel.getLHost(), remoteTunnel.getLPort());
            }
            this.nestedSequential.getNested().forEach(Task::perform);
        }
        catch (JSchException e) {
            if (e.getMessage().contains("session is down")) {
                if (this.getFailonerror()) {
                    throw new BuildException(TIMEOUT_MESSAGE, (Throwable)e);
                }
                this.log(TIMEOUT_MESSAGE, 0);
            } else {
                if (this.getFailonerror()) {
                    throw new BuildException((Throwable)e);
                }
                this.log("Caught exception: " + e.getMessage(), 0);
            }
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            if (this.getFailonerror()) {
                throw new BuildException((Throwable)e);
            }
            this.log("Caught exception: " + e.getMessage(), 0);
        }
        finally {
            if (session != null && session.isConnected()) {
                session.disconnect();
            }
        }
    }

    public LocalTunnel createLocalTunnel() {
        LocalTunnel tunnel = new LocalTunnel();
        this.localTunnels.add(tunnel);
        return tunnel;
    }

    public RemoteTunnel createRemoteTunnel() {
        RemoteTunnel tunnel = new RemoteTunnel();
        this.remoteTunnels.add(tunnel);
        return tunnel;
    }

    public NestedSequential createSequential() {
        if (this.nestedSequential != null) {
            throw new BuildException("Only one sequential allowed");
        }
        this.nestedSequential = new NestedSequential();
        return this.nestedSequential;
    }

    public static class NestedSequential
    implements TaskContainer {
        private final List<Task> nested = new ArrayList<Task>();

        public void addTask(Task task) {
            this.nested.add(task);
        }

        public List<Task> getNested() {
            return this.nested;
        }
    }

    public class RemoteTunnel {
        int lport = 0;
        String lhost = null;
        int rport = 0;

        public void setLPort(int lport) {
            this.lport = lport;
        }

        public void setLHost(String lhost) {
            this.lhost = lhost;
        }

        public void setRPort(int rport) {
            Integer portKey = rport;
            if (SSHSession.this.remotePortsUsed.contains(portKey)) {
                throw new BuildException("Multiple remote tunnels defined to use same remote port %d", new Object[]{rport});
            }
            SSHSession.this.remotePortsUsed.add(portKey);
            this.rport = rport;
        }

        public int getLPort() {
            if (this.lport == 0) {
                throw new BuildException("lport is required for RemoteTunnel.");
            }
            return this.lport;
        }

        public String getLHost() {
            if (this.lhost == null) {
                throw new BuildException("lhost is required for RemoteTunnel.");
            }
            return this.lhost;
        }

        public int getRPort() {
            if (this.rport == 0) {
                throw new BuildException("rport is required for RemoteTunnel.");
            }
            return this.rport;
        }
    }

    public class LocalTunnel {
        int lport = 0;
        String rhost = null;
        int rport = 0;

        public void setLPort(int lport) {
            Integer portKey = lport;
            if (SSHSession.this.localPortsUsed.contains(portKey)) {
                throw new BuildException("Multiple local tunnels defined to use same local port %d", new Object[]{lport});
            }
            SSHSession.this.localPortsUsed.add(portKey);
            this.lport = lport;
        }

        public void setRHost(String rhost) {
            this.rhost = rhost;
        }

        public void setRPort(int rport) {
            this.rport = rport;
        }

        public int getLPort() {
            if (this.lport == 0) {
                throw new BuildException("lport is required for LocalTunnel.");
            }
            return this.lport;
        }

        public String getRHost() {
            if (this.rhost == null) {
                throw new BuildException("rhost is required for LocalTunnel.");
            }
            return this.rhost;
        }

        public int getRPort() {
            if (this.rport == 0) {
                throw new BuildException("rport is required for LocalTunnel.");
            }
            return this.rport;
        }
    }
}

