/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.artifact.processors.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureList;
import org.bouncycastle.openpgp.bc.BcPGPObjectFactory;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.bc.BcPGPContentVerifierBuilderProvider;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.Messages;
import org.eclipse.equinox.internal.p2.artifact.processors.pgp.PGPPublicKeyStore;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.processing.ProcessingStep;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IProcessingStepDescriptor;
import org.eclipse.equinox.p2.repository.artifact.spi.ArtifactDescriptor;
import org.eclipse.equinox.p2.repository.spi.PGPPublicKeyService;
import org.eclipse.osgi.util.NLS;

public final class PGPSignatureVerifier
extends ProcessingStep {
    public static final String ID = "org.eclipse.equinox.p2.processing.PGPSignatureCheck";
    public static final String PGP_SIGNER_KEYS_PROPERTY_NAME = "pgp.publicKeys";
    public static final String PGP_SIGNATURES_PROPERTY_NAME = "pgp.signatures";
    private PGPPublicKeyService keyService;
    private IArtifactDescriptor sourceDescriptor;
    private Map<PGPSignature, List<PGPContentVerifier>> signaturesToVerify = new LinkedHashMap<PGPSignature, List<PGPContentVerifier>>();
    private Map<PGPContentVerifier, PGPPublicKey> verifierKeys = new LinkedHashMap<PGPContentVerifier, PGPPublicKey>();
    private List<OutputStream> signatureVerifiers = new ArrayList<OutputStream>();

    public PGPSignatureVerifier() {
        this.link(PGPSignatureVerifier.nullOutputStream(), (IProgressMonitor)new NullProgressMonitor());
    }

    public static Collection<PGPSignature> getSignatures(IArtifactDescriptor artifact) throws IOException, PGPException {
        String signatureText = PGPSignatureVerifier.unnormalizedPGPProperty(artifact.getProperty(PGP_SIGNATURES_PROPERTY_NAME));
        if (signatureText == null) {
            return Collections.emptyList();
        }
        ArrayList<PGPSignature> res = new ArrayList<PGPSignature>();
        Throwable throwable = null;
        Object var4_5 = null;
        try (ArmoredInputStream in = new ArmoredInputStream((InputStream)new ByteArrayInputStream(signatureText.getBytes(StandardCharsets.US_ASCII)));){
            BcPGPObjectFactory pgpFactory = new BcPGPObjectFactory((InputStream)in);
            Object o = pgpFactory.nextObject();
            PGPSignatureList signatureList = new PGPSignatureList(new PGPSignature[0]);
            if (o instanceof PGPCompressedData) {
                PGPCompressedData pgpCompressData = (PGPCompressedData)o;
                pgpFactory = new BcPGPObjectFactory(pgpCompressData.getDataStream());
                signatureList = (PGPSignatureList)pgpFactory.nextObject();
            } else if (o instanceof PGPSignatureList) {
                signatureList = (PGPSignatureList)o;
            }
            signatureList.iterator().forEachRemaining(res::add);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return res;
    }

    public static PGPPublicKeyStore getKeys(IArtifactDescriptor artifact) {
        PGPPublicKeyStore keyStore = new PGPPublicKeyStore();
        String keyText = artifact.getProperty(PGP_SIGNER_KEYS_PROPERTY_NAME);
        PGPPublicKeyStore.readPublicKeys(keyText).stream().forEach(keyStore::addKey);
        return keyStore;
    }

    @Override
    public void initialize(IProvisioningAgent agent, IProcessingStepDescriptor descriptor, IArtifactDescriptor context) {
        Collection<PGPSignature> signatures;
        super.initialize(agent, descriptor, context);
        this.sourceDescriptor = context;
        this.keyService = (PGPPublicKeyService)agent.getService(PGPPublicKeyService.class);
        String signatureText = PGPSignatureVerifier.unnormalizedPGPProperty(context.getProperty(PGP_SIGNATURES_PROPERTY_NAME));
        if (signatureText == null) {
            this.setStatus(Status.OK_STATUS);
            return;
        }
        try {
            signatures = PGPSignatureVerifier.getSignatures(context);
        }
        catch (Exception ex) {
            this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", Messages.Error_CouldNotLoadSignature, (Throwable)ex));
            return;
        }
        if (signatures.isEmpty()) {
            this.setStatus(Status.OK_STATUS);
            return;
        }
        IArtifactRepository repository = context.getRepository();
        PGPPublicKeyStore.readPublicKeys(context.getProperty(PGP_SIGNER_KEYS_PROPERTY_NAME)).forEach(arg_0 -> ((PGPPublicKeyService)this.keyService).addKey(arg_0));
        if (repository != null) {
            PGPPublicKeyStore.readPublicKeys(repository.getProperty(PGP_SIGNER_KEYS_PROPERTY_NAME)).forEach(arg_0 -> ((PGPPublicKeyService)this.keyService).addKey(arg_0));
        }
        for (PGPSignature signature : signatures) {
            long keyID = signature.getKeyID();
            Collection keys = this.keyService.getKeys(keyID);
            if (keys.isEmpty()) {
                LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Warning_publicKeyNotFound, (Object)PGPPublicKeyService.toHex((long)keyID), (Object)context.getArtifactKey().getId())));
                continue;
            }
            try {
                PGPContentVerifierBuilder verifierBuilder = new BcPGPContentVerifierBuilderProvider().get(signature.getKeyAlgorithm(), signature.getHashAlgorithm());
                ArrayList<PGPContentVerifier> verifiers = new ArrayList<PGPContentVerifier>();
                this.signaturesToVerify.put(signature, verifiers);
                for (PGPPublicKey key : keys) {
                    PGPContentVerifier verifier = verifierBuilder.build(key);
                    this.verifierKeys.put(verifier, key);
                    verifiers.add(verifier);
                    this.signatureVerifiers.add(verifier.getOutputStream());
                }
            }
            catch (PGPException ex) {
                this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", ex.getMessage(), (Throwable)ex));
                return;
            }
        }
    }

    static String unnormalizedPGPProperty(String armoredPGPBlock) {
        if (armoredPGPBlock == null) {
            return null;
        }
        if (armoredPGPBlock.contains("\n") || armoredPGPBlock.contains("\r")) {
            return armoredPGPBlock;
        }
        return armoredPGPBlock.replace(' ', '\n').replace("-----BEGIN\nPGP\nSIGNATURE-----", "-----BEGIN PGP SIGNATURE-----").replace("-----END\nPGP\nSIGNATURE-----", "-----END PGP SIGNATURE-----").replace("-----BEGIN\nPGP\nPUBLIC\nKEY\nBLOCK-----", "-----BEGIN PGP PUBLIC KEY BLOCK-----").replace("-----END\nPGP\nPUBLIC\nKEY\nBLOCK-----", "-----END PGP PUBLIC KEY BLOCK-----");
    }

    @Override
    public void write(int b) throws IOException {
        this.getDestination().write(b);
        for (OutputStream verifier : this.signatureVerifiers) {
            verifier.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.getDestination().write(b, off, len);
        for (OutputStream verifier : this.signatureVerifiers) {
            verifier.write(b, off, len);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.getStatus().isOK()) {
                return;
            }
            if (this.signaturesToVerify.isEmpty()) {
                return;
            }
            PGPPublicKeyStore keyStore = new PGPPublicKeyStore();
            for (Map.Entry<PGPSignature, List<PGPContentVerifier>> entry : this.signaturesToVerify.entrySet()) {
                PGPSignature signature = entry.getKey();
                List<PGPContentVerifier> verifiers = entry.getValue();
                boolean verified = false;
                for (PGPContentVerifier verifier : verifiers) {
                    PGPPublicKey verifyingKey;
                    block16: {
                        verifier.getOutputStream().write(signature.getSignatureTrailer());
                        if (!verifier.verify(signature.getSignature())) continue;
                        verifyingKey = this.verifierKeys.get(verifier);
                        if (!Boolean.FALSE.toString().equalsIgnoreCase(System.getProperty("p2.pgp.verifyExpiration")) && PGPPublicKeyService.compareSignatureTimeToKeyValidityTime((PGPSignature)signature, (PGPPublicKey)verifyingKey) != 0L) {
                            LogHelper.log((IStatus)new Status(2, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Error_SignatureAfterKeyExpiration, (Object)PGPPublicKeyService.toHexFingerprint((PGPPublicKey)verifyingKey))));
                        }
                        if (Boolean.FALSE.toString().equalsIgnoreCase(System.getProperty("p2.pgp.verifyRevocation")) || this.keyService.isCreatedBeforeRevocation(signature, verifyingKey)) break block16;
                        this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", NLS.bind((String)Messages.Error_SignatureAfterKeyRevocation, (Object)PGPPublicKeyService.toHexFingerprint((PGPPublicKey)verifyingKey))));
                        return;
                    }
                    try {
                        keyStore.addKey(verifyingKey);
                        verified = true;
                        break;
                    }
                    catch (PGPException ex) {
                        LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", ex.getMessage(), (Throwable)ex));
                    }
                }
                if (verified) continue;
                this.setStatus((IStatus)new Status(4, "org.eclipse.equinox.p2.artifact.repository", Messages.Error_SignatureAndFileDontMatch));
                return;
            }
            OutputStream destination = this.getDestination();
            if (destination instanceof IAdaptable) {
                ArtifactDescriptor destinationDescriptor = (ArtifactDescriptor)((IAdaptable)destination).getAdapter(ArtifactDescriptor.class);
                destinationDescriptor.setProperty(PGP_SIGNATURES_PROPERTY_NAME, this.sourceDescriptor.getProperty(PGP_SIGNATURES_PROPERTY_NAME));
                destinationDescriptor.setProperty(PGP_SIGNER_KEYS_PROPERTY_NAME, keyStore.toArmoredString());
            }
            this.setStatus(Status.OK_STATUS);
        }
        finally {
            super.close();
        }
    }
}

