/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.discovery.internal.wizard;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wst.server.discovery.internal.ExtensionUtility;
import org.eclipse.wst.server.discovery.internal.ImageResource;
import org.eclipse.wst.server.discovery.internal.Messages;
import org.eclipse.wst.server.discovery.internal.Trace;
import org.eclipse.wst.server.discovery.internal.model.Extension;
import org.eclipse.wst.server.discovery.internal.wizard.ExtensionContentProvider;
import org.eclipse.wst.server.discovery.internal.wizard.ExtensionTableLabelProvider;

public class ExtensionComposite
extends Composite {
    private static final String ROOT = "root";
    protected Table table;
    protected TableViewer tableViewer;
    protected Font font;
    protected HashMap<String, Image> images;
    protected String progress;
    protected int totalWork;
    protected double currentWork;
    protected int count;
    public ExtensionSelectionListener listener;

    public ExtensionComposite(Composite parent, int style, ExtensionSelectionListener listener) {
        super(parent, style);
        this.listener = listener;
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        this.setLayout((Layout)layout);
        Font currentFont = this.getFont();
        FontData[] fd = currentFont.getFontData();
        int size2 = fd.length;
        int i = 0;
        while (i < size2) {
            fd[i].setHeight(fd[i].getHeight() + 2);
            fd[i].setStyle(1);
            ++i;
        }
        this.font = new Font((Device)this.getDisplay(), fd);
        this.table = new Table((Composite)this, 68354);
        GridData data = new GridData(1808);
        data.widthHint = 350;
        this.table.setLayoutData((Object)data);
        this.table.setHeaderVisible(false);
        this.tableViewer = new TableViewer(this.table);
        this.table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ExtensionComposite.this.disposeResources();
            }
        });
        TableLayout tableLayout = new TableLayout();
        this.table.setLayout((Layout)tableLayout);
        tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, 250, false));
        TableColumn col = new TableColumn(this.table, 0);
        col.setText("null");
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.gc.setFont(ExtensionComposite.this.font);
                Point size = event.gc.textExtent("A");
                int h = 9 + size.y;
                size = event.gc.textExtent("A");
                event.gc.setFont(null);
                h += size.y;
                h = Math.max(h, 46);
                event.height = Math.max(event.height, h);
            }
        });
        this.table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                event.detail &= 0xFFFFFFEF;
            }
        });
        this.table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                Object obj = item.getData();
                int width = ExtensionComposite.this.table.getColumn(0).getWidth();
                GC gc = event.gc;
                if (obj instanceof String) {
                    String s = (String)obj;
                    if (ExtensionComposite.this.progress != null) {
                        s = ExtensionComposite.this.progress;
                    }
                    int h = event.y + event.height / 2;
                    Point size = event.gc.textExtent(s);
                    gc.drawText(s, event.x + 3, h - size.y / 2, true);
                    int hh = event.y + event.height - 5 - 3 - 1;
                    gc.setLineWidth(2);
                    Color color = ExtensionComposite.this.getDisplay().getSystemColor(26);
                    gc.setBackground(color);
                    int width2 = 0;
                    int step = 9;
                    if (ExtensionComposite.this.totalWork > 0) {
                        width2 = (int)((double)(width - step * 2 - 15 - 6) * ExtensionComposite.this.currentWork / (double)ExtensionComposite.this.totalWork);
                    }
                    int i = 0;
                    while (i < width2) {
                        gc.fillRectangle(event.x + 3 + i, hh, step - 2, 5);
                        i += step;
                    }
                    return;
                }
                if (obj instanceof List) {
                    List list = (List)obj;
                    int size = list.size();
                    String[] hosts = new String[size];
                    list.toArray(hosts);
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (i < size) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        sb.append(hosts[i]);
                        ++i;
                    }
                    String s = NLS.bind((String)Messages.discoverSiteError, (Object)sb.toString());
                    gc.drawText(s, event.x + 3, event.y + 3, true);
                    return;
                }
                Extension ei = (Extension)obj;
                if (ei == null) {
                    return;
                }
                String name = ei.getName();
                String provider = ei.getProvider();
                String version = ei.getVersion().toString();
                Image image = ei.getImage();
                if (image == null) {
                    image = ImageResource.getImage("wizard");
                }
                int iw = image.getBounds().width;
                int ih = image.getBounds().height;
                gc.drawImage(image, 0, 0, iw, ih, event.x + 3, event.y + 3, 40, 40);
                iw = 46;
                int yOffset = 3;
                gc.setFont(ExtensionComposite.this.font);
                Point size = new Point(0, 0);
                if (name != null) {
                    gc.drawText(name, event.x + iw, event.y + yOffset, true);
                    size = event.gc.textExtent(name);
                }
                gc.setFont(null);
                gc.drawText(provider, event.x + iw, event.y + (yOffset += size.y + 3), true);
                size = event.gc.textExtent(version);
                gc.drawText(version, event.x + width - 9 - size.x, event.y + yOffset, true);
            }
        });
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof Extension && !(e2 instanceof Extension)) {
                    return -1;
                }
                if (!(e1 instanceof Extension) && e2 instanceof Extension) {
                    return 1;
                }
                try {
                    Extension f1 = (Extension)e1;
                    Extension f2 = (Extension)e2;
                    return f1.getName().compareToIgnoreCase(f2.getName());
                }
                catch (Exception exception) {
                    return 0;
                }
            }
        });
        final Label description = new Label((Composite)this, 64);
        description.setText("Multi\nLine\nMessage");
        Dialog.applyDialogFont((Control)this);
        Point p = description.computeSize(-1, -1);
        description.setText("");
        data = new GridData(772);
        data.horizontalSpan = 2;
        data.heightHint = p.y > 10 ? p.y : 42;
        description.setLayoutData((Object)data);
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection sel = (StructuredSelection)ExtensionComposite.this.tableViewer.getSelection();
                Object obj = sel.getFirstElement();
                Extension extension = null;
                if (obj instanceof Extension) {
                    extension = (Extension)obj;
                }
                ExtensionComposite.this.handleSelection(extension);
                if (extension != null) {
                    description.setText(extension.getDescription());
                } else {
                    description.setText("");
                }
            }
        });
        this.deferInitialization();
    }

    protected Image getImage(URL url) {
        if (url == null) {
            return null;
        }
        try {
            Image image = this.images.get(url.toString());
            if (image != null) {
                return image;
            }
        }
        catch (Exception exception) {}
        try {
            ImageDescriptor id = ImageDescriptor.createFromURL((URL)url);
            Image image = id.createImage();
            if (this.images == null) {
                this.images = new HashMap();
            }
            this.images.put(url.toString(), image);
            return image;
        }
        catch (Exception e) {
            Trace.trace((byte)1, "Could not create image", e);
            return null;
        }
    }

    protected void disposeResources() {
        try {
            this.font.dispose();
            if (this.images != null) {
                for (Image image : this.images.values()) {
                    image.dispose();
                }
            }
        }
        catch (Exception e) {
            Trace.trace((byte)2, "Could not dispose - possible resource leak", e);
        }
    }

    protected void handleSelection(Extension extension) {
        this.listener.extensionSelected(extension);
    }

    protected void deferInitialization() {
        Runnable[] animator;
        final List<String> list = Collections.synchronizedList(new ArrayList());
        list.add(Messages.viewInitializing);
        this.tableViewer.setContentProvider((IContentProvider)new ExtensionContentProvider(list));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ExtensionTableLabelProvider());
        this.tableViewer.setInput((Object)ROOT);
        final Thread t = new Thread("Deferred Initialization"){

            @Override
            public void run() {
                ExtensionComposite.this.deferredInitialize(list, new IProgressMonitor(){

                    public void beginTask(String name, int totalWork2) {
                        (this).ExtensionComposite.this.totalWork = totalWork2;
                        (this).ExtensionComposite.this.progress = name;
                    }

                    public void setTaskName(String name) {
                        (this).ExtensionComposite.this.progress = name;
                    }

                    public void subTask(String name) {
                        (this).ExtensionComposite.this.progress = name;
                    }

                    public void done() {
                    }

                    public void internalWorked(double work) {
                        (this).ExtensionComposite.this.currentWork += work;
                    }

                    public boolean isCanceled() {
                        return false;
                    }

                    public void setCanceled(boolean value) {
                    }

                    public void worked(int work) {
                        (this).ExtensionComposite.this.currentWork += (double)work;
                    }
                });
            }
        };
        t.setDaemon(true);
        t.start();
        final Display display = this.getDisplay();
        animator = new Runnable[]{new Runnable(){

            @Override
            public void run() {
                if (t.isAlive()) {
                    ++ExtensionComposite.this.count;
                    if (!ExtensionComposite.this.table.isDisposed()) {
                        ExtensionComposite.this.tableViewer.refresh((Object)ExtensionComposite.ROOT);
                    }
                    display.timerExec(100, animator[0]);
                }
            }
        }};
        display.timerExec(100, animator[0]);
    }

    public void deferredInitialize(final List<Object> list, IProgressMonitor monitor) {
        final ArrayList failedSites = new ArrayList();
        ExtensionUtility.ExtensionListener listener2 = new ExtensionUtility.ExtensionListener(){

            @Override
            public void extensionFound(Extension extension) {
                list.add(extension);
                if (ExtensionComposite.this.progress != null) {
                    list.set(0, ExtensionComposite.this.progress);
                }
            }

            @Override
            public void extensionRemoved(Extension feature) {
                list.remove(feature);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void siteFailure(String host) {
                List list2 = failedSites;
                synchronized (list2) {
                    if (!list.contains(failedSites)) {
                        list.add(failedSites);
                    }
                    failedSites.add(host);
                }
            }
        };
        String id = "org.eclipse.wst.server.core.serverAdapter";
        try {
            ExtensionUtility.getAllExtensions(id, listener2, monitor);
        }
        catch (CoreException ce) {
            Trace.trace((byte)2, "Error downloading server adapter info", ce);
        }
        list.remove(0);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ExtensionComposite.this.table.isDisposed()) {
                    ExtensionComposite.this.tableViewer.refresh((Object)ExtensionComposite.ROOT);
                }
            }
        });
    }

    protected Object getSelection(ISelection sel2) {
        IStructuredSelection sel = (IStructuredSelection)sel2;
        return sel.getFirstElement();
    }

    public static interface ExtensionSelectionListener {
        public void extensionSelected(Extension var1);
    }
}

