/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.reader;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import org.sat4j.reader.ParseFormatException;

public class EfficientScanner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final int TAILLE_BUF = 16384;
    private final transient BufferedInputStream in;
    private static final char EOF = '\uffff';
    private final char commentChar;

    public EfficientScanner(InputStream input, char commentChar) {
        this.in = new BufferedInputStream(input, 16384);
        this.commentChar = commentChar;
    }

    public EfficientScanner(InputStream input) {
        this(input, 'c');
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void skipComments() throws IOException {
        char currentChar;
        while ((currentChar = this.currentChar()) == this.commentChar) {
            this.skipRestOfLine();
            if (currentChar != '\uffff') continue;
            break;
        }
    }

    public int nextInt() throws IOException, ParseFormatException {
        int val = 0;
        boolean neg = false;
        char currentChar = this.skipSpaces();
        if (currentChar == '-') {
            neg = true;
            currentChar = (char)this.in.read();
        } else if (currentChar == '+') {
            currentChar = (char)this.in.read();
        } else if (currentChar >= '0' && currentChar <= '9') {
            val = currentChar - 48;
            currentChar = (char)this.in.read();
        } else {
            throw new ParseFormatException("Unknown character " + currentChar);
        }
        while (currentChar >= '0' && currentChar <= '9') {
            val = val * 10 + currentChar - 48;
            currentChar = (char)this.in.read();
        }
        if (currentChar == '\r') {
            this.in.read();
        }
        return neg ? -val : val;
    }

    public BigInteger nextBigInteger() throws IOException, ParseFormatException {
        StringBuilder stb = new StringBuilder();
        char currentChar = this.skipSpaces();
        if (currentChar == '-') {
            stb.append(currentChar);
            currentChar = (char)this.in.read();
        } else if (currentChar == '+') {
            currentChar = (char)this.in.read();
        } else if (currentChar >= '0' && currentChar <= '9') {
            stb.append(currentChar);
            currentChar = (char)this.in.read();
        } else {
            throw new ParseFormatException("Unknown character " + currentChar);
        }
        while (currentChar >= '0' && currentChar <= '9') {
            stb.append(currentChar);
            currentChar = (char)this.in.read();
        }
        return new BigInteger(stb.toString());
    }

    public String next() throws IOException, ParseFormatException {
        StringBuilder stb = new StringBuilder();
        char currentChar = this.skipSpaces();
        while (currentChar != ' ' && currentChar != '\n') {
            stb.append(currentChar);
            currentChar = (char)this.in.read();
        }
        return stb.toString();
    }

    public char skipSpaces() throws IOException {
        char car;
        while ((car = (char)this.in.read()) == ' ' || car == '\n') {
        }
        return car;
    }

    public String nextLine() throws IOException {
        char car;
        StringBuilder stb = new StringBuilder();
        do {
            car = (char)this.in.read();
            stb.append(car);
        } while (car != '\n' && car != '\uffff');
        return stb.toString();
    }

    public void skipRestOfLine() throws IOException {
        char car;
        while ((car = (char)this.in.read()) != '\n' && car != '\uffff') {
        }
    }

    public boolean eof() throws IOException {
        return this.currentChar() == '\uffff';
    }

    public char currentChar() throws IOException {
        this.in.mark(10);
        char car = (char)this.in.read();
        this.in.reset();
        return car;
    }
}

