/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.viewers.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.internal.ui.viewers.model.IInternalTreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.ILabelUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.ITreeModelViewer;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.TreeModelLabelProvider;
import org.eclipse.debug.internal.ui.viewers.model.ViewerAdapterService;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentation;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IColumnPresentationFactory;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelChangedListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IModelSelectionPolicy;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IStateUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdateListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IVirtualItemListener;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IVirtualItemValidator;
import org.eclipse.debug.internal.ui.viewers.model.provisional.ModelDelta;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualItem;
import org.eclipse.debug.internal.ui.viewers.model.provisional.VirtualTree;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;

public class InternalVirtualTreeModelViewer
extends Viewer
implements IVirtualItemListener,
ITreeModelViewer,
IInternalTreeModelViewer {
    private static final String VISIBLE_COLUMNS = "VISIBLE_COLUMNS";
    private static final String SHOW_COLUMNS = "SHOW_COLUMNS";
    private static final String SIZE = "SIZE";
    private static final String COLUMN = "COLUMN";
    private static final String TREE_PATH_KEY = "TREE_PATH_KEY";
    private ViewerFilter[] fFilters = new ViewerFilter[0];
    private Display fDisplay;
    private IPresentationContext fContext;
    private Object fInput;
    private VirtualTree fTree;
    private Map<Object, List<VirtualItem>> fItemsMap = new HashMap<Object, List<VirtualItem>>();
    private boolean fNotifyUnmap = true;
    private TreeModelLabelProvider fLabelProvider;
    private TreeModelContentProvider fContentProvider;
    private boolean fPreservingSelecction;
    private boolean fRestoreSelection;
    private int fAutoExpandToLevel = 0;
    private IColumnPresentation fColumnPresentation = null;
    private Map<String, String[]> fVisibleColumns = new HashMap<String, String[]>();
    private Map<String, Boolean> fShowColumns = new HashMap<String, Boolean>();
    private Runnable fValidateRunnable;
    public static int ALL_LEVELS = -1;
    private static final VirtualItem[] EMPTY_ITEMS_ARRAY = new VirtualItem[0];

    public InternalVirtualTreeModelViewer(Display display, int style, IPresentationContext context, IVirtualItemValidator itemValidator) {
        this.fDisplay = display;
        this.fContext = context;
        this.fTree = new VirtualTree(style, itemValidator);
        this.fTree.addItemListener(this);
        this.fContentProvider = new TreeModelContentProvider();
        this.fLabelProvider = new TreeModelLabelProvider(this);
        if ((style & 8) != 0) {
            this.getContentProvider().setModelDeltaMask(-120586241);
        }
    }

    @Override
    public Object getInput() {
        return this.fInput;
    }

    public Control getControl() {
        return null;
    }

    @Override
    public Display getDisplay() {
        return this.fDisplay;
    }

    @Override
    public void setInput(Object input) {
        Object oldInput = this.fInput;
        this.getContentProvider().inputChanged(this, oldInput, input);
        this.fItemsMap.clear();
        this.fTree.clearAll();
        this.fInput = input;
        this.mapElement(this.fInput, this.getTree());
        this.getContentProvider().postInputChanged(this, oldInput, input);
        this.fTree.setData(this.fInput);
        this.fTree.setSelection(EMPTY_ITEMS_ARRAY);
        this.inputChanged(this.fInput, oldInput);
        this.refresh();
    }

    @Override
    public void replace(Object parentElementOrTreePath, int index, Object element) {
        VirtualItem[] itemsToDisassociate;
        VirtualItem[] selectedItems = this.fTree.getSelection();
        TreeSelection selection = (TreeSelection)this.getSelection();
        if (parentElementOrTreePath instanceof TreePath) {
            TreePath elementPath = ((TreePath)parentElementOrTreePath).createChildPath(element);
            itemsToDisassociate = this.findItems(elementPath);
        } else {
            itemsToDisassociate = this.findItems(element);
        }
        VirtualItem[] virtualItemArray = this.findItems(parentElementOrTreePath);
        int n = virtualItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualItem parentItem = virtualItemArray[n2];
            if (index < parentItem.getItemCount()) {
                VirtualItem item = parentItem.getItem(new VirtualItem.Index(index));
                selection = this.adjustSelectionForReplace(selectedItems, selection, item, element, parentItem.getData());
                VirtualItem[] virtualItemArray2 = itemsToDisassociate;
                int n3 = itemsToDisassociate.length;
                int n4 = 0;
                while (n4 < n3) {
                    VirtualItem itemToDisassociate = virtualItemArray2[n4];
                    if (itemToDisassociate != item && itemToDisassociate.getParent() == parentItem) {
                        this.disassociate(itemToDisassociate);
                        itemToDisassociate.getParent().clear(itemToDisassociate.getIndex());
                    }
                    ++n4;
                }
                this.associate(element, item);
                this.doUpdate(item);
                virtualItemArray2 = item.getItems();
                n3 = virtualItemArray2.length;
                n4 = 0;
                while (n4 < n3) {
                    VirtualItem childitem = virtualItemArray2[n4];
                    childitem.setNeedsDataUpdate();
                    ++n4;
                }
            }
            ++n2;
        }
        if (!this.fPreservingSelecction) {
            this.internalSetSelection((ISelection)selection, false);
            ISelection newSelection = this.getSelection();
            if (!newSelection.equals(selection)) {
                this.handleInvalidSelection((ISelection)selection, newSelection);
            }
        }
        this.validate();
    }

    public VirtualTree getTree() {
        return this.fTree;
    }

    @Override
    public void insert(Object parentOrTreePath, Object element, int position) {
        VirtualItem parentItem;
        if (parentOrTreePath instanceof TreePath && (parentItem = this.findItem((TreePath)parentOrTreePath)) != null) {
            VirtualItem item = parentItem.addItem(position);
            item.setData(element);
            this.mapElement(element, item);
            this.doUpdate(item);
        }
        this.validate();
    }

    @Override
    public void remove(Object parentOrTreePath, int index) {
        LinkedList<TreePath> oldSelection = new LinkedList<TreePath>(Arrays.asList(((TreeSelection)this.getSelection()).getPaths()));
        this.preservingSelection(() -> {
            TreePath removedPath = null;
            VirtualItem[] virtualItemArray = this.findItems(parentOrTreePath);
            int n2 = virtualItemArray.length;
            int n3 = 0;
            while (n3 < n2) {
                VirtualItem parentItem = virtualItemArray[n3];
                if (!parentItem.isDisposed()) {
                    if (!parentItem.getExpanded()) {
                        parentItem.setNeedsCountUpdate();
                        parentItem.setItemCount(-1);
                        this.virtualLazyUpdateHasChildren(parentItem);
                    }
                    if (index < parentItem.getItemCount()) {
                        VirtualItem item = parentItem.getItem(new VirtualItem.Index(index));
                        if (item.getData() != null) {
                            removedPath = this.getTreePathFromItem(item);
                            this.disassociate(item);
                        }
                        parentItem.remove(item.getIndex());
                    }
                }
                ++n3;
            }
            if (removedPath != null) {
                boolean removed = false;
                Iterator it = oldSelection.iterator();
                while (it.hasNext()) {
                    TreePath path = (TreePath)it.next();
                    if (!path.startsWith(removedPath, null)) continue;
                    it.remove();
                    removed = true;
                }
                if (removed) {
                    this.setSelection((ISelection)new TreeSelection(oldSelection.toArray(new TreePath[oldSelection.size()])), false);
                }
            }
        });
    }

    @Override
    public void remove(Object elementOrPath) {
        if (elementOrPath.equals(this.getInput()) || TreePath.EMPTY.equals(elementOrPath)) {
            this.setInput(null);
            return;
        }
        VirtualItem[] virtualItemArray = this.findItems(elementOrPath);
        int n = virtualItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualItem item = virtualItemArray[n2];
            this.disassociate(item);
            item.getParent().remove(item.getIndex());
            ++n2;
        }
    }

    private TreeSelection adjustSelectionForReplace(VirtualItem[] selectedItems, TreeSelection selection, VirtualItem item, Object element, Object parentElement) {
        if (item.getData() != null || selectedItems.length == selection.size() || parentElement == null) {
            return selection;
        }
        VirtualItem[] virtualItemArray = selectedItems;
        int n = selectedItems.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualItem selectedItem = virtualItemArray[n2];
            if (item == selectedItem) {
                TreePath[] originalPaths = selection.getPaths();
                int length = originalPaths.length;
                TreePath[] paths = new TreePath[length + 1];
                System.arraycopy(originalPaths, 0, paths, 0, length);
                item.setData(element);
                paths[length] = this.getTreePathFromItem(item);
                item.setData(null);
                return new TreeSelection(paths, selection.getElementComparer());
            }
            ++n2;
        }
        return selection;
    }

    @Override
    public void reveal(TreePath path, int index) {
        VirtualItem parentItem = this.findItem(path);
        if (parentItem != null && parentItem.getItemCount() >= index) {
            VirtualItem revealItem = parentItem.getItem(new VirtualItem.Index(index));
            this.getTree().showItem(revealItem);
            this.getTree().validate();
        }
    }

    @Override
    public int findElementIndex(TreePath parentPath, Object element) {
        VirtualItem item;
        VirtualItem parentItem = this.findItem(parentPath);
        if (parentItem != null && (item = parentItem.findItem(element)) != null) {
            return item.getIndex().intValue();
        }
        return -1;
    }

    @Override
    public boolean getElementChildrenRealized(TreePath parentPath) {
        VirtualItem parentItem = this.findItem(parentPath);
        if (parentItem != null) {
            return !parentItem.childrenNeedDataUpdate();
        }
        return true;
    }

    private ITreeModelLabelProvider getLabelProvider() {
        return this.fLabelProvider;
    }

    private ITreeModelContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    @Override
    public void refresh() {
        this.refresh(this.fTree);
        this.validate();
    }

    @Override
    public void refresh(Object element) {
        VirtualItem[] virtualItemArray = this.findItems(element);
        int n = virtualItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualItem item = virtualItemArray[n2];
            this.refresh(item);
            this.validate();
            ++n2;
        }
    }

    private void refresh(VirtualItem item) {
        this.getContentProvider().preserveState(this.getTreePathFromItem(item));
        if (!item.needsDataUpdate()) {
            if (item.getParent() != null) {
                item.setNeedsLabelUpdate();
                this.virtualLazyUpdateHasChildren(item);
            }
            VirtualItem[] virtualItemArray = item.getItems();
            int n = virtualItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualItem childItem = virtualItemArray[n2];
                childItem.setNeedsDataUpdate();
                ++n2;
            }
        }
        this.refreshStruct(item);
    }

    private void refreshStruct(VirtualItem item) {
        boolean expanded = false;
        if (item.getParent() == null) {
            this.virtualLazyUpdateChildCount(item);
            expanded = true;
        } else if (item.getExpanded()) {
            this.virtualLazyUpdateData(item);
            expanded = true;
        }
        VirtualItem[] items = item.getItems();
        int i = 0;
        while (i < items.length) {
            if (expanded) {
                this.refreshStruct(items[i]);
            } else {
                item.clear(new VirtualItem.Index(i));
            }
            ++i;
        }
    }

    private void validate() {
        if (this.fValidateRunnable == null) {
            this.fValidateRunnable = () -> {
                if (!this.fTree.isDisposed()) {
                    this.fValidateRunnable = null;
                    this.fTree.validate();
                }
            };
            this.getDisplay().asyncExec(this.fValidateRunnable);
        }
    }

    protected void inputChanged(Object input, Object oldInput) {
        this.resetColumns(input);
    }

    @Override
    public int getAutoExpandLevel() {
        return this.fAutoExpandToLevel;
    }

    @Override
    public void setAutoExpandLevel(int level) {
        this.fAutoExpandToLevel = level;
    }

    public VirtualItem findItem(TreePath path) {
        if (path.getSegmentCount() == 0) {
            return this.fTree;
        }
        List<VirtualItem> itemsList = this.fItemsMap.get(path.getLastSegment());
        if (itemsList != null) {
            for (VirtualItem item : itemsList) {
                if (!path.equals((Object)this.getTreePathFromItem(item))) continue;
                return item;
            }
        }
        return null;
    }

    public VirtualItem[] findItems(Object elementOrTreePath) {
        List<VirtualItem> itemsList;
        Object element = elementOrTreePath;
        if (elementOrTreePath instanceof TreePath) {
            TreePath path = (TreePath)elementOrTreePath;
            if (path.getSegmentCount() == 0) {
                return new VirtualItem[]{this.getTree()};
            }
            element = path.getLastSegment();
        }
        if ((itemsList = this.fItemsMap.get(element)) == null) {
            return EMPTY_ITEMS_ARRAY;
        }
        return itemsList.toArray(new VirtualItem[itemsList.size()]);
    }

    @Override
    public void setElementData(TreePath path, int numColumns, String[] labels, ImageDescriptor[] images, FontData[] fontDatas, RGB[] foregrounds, RGB[] backgrounds) {
        VirtualItem item = this.findItem(path);
        if (item != null) {
            item.setData("LABEL_KEY", labels);
            item.setData("IMAGE_KEY", images);
            item.setData("FOREGROUND_KEY", foregrounds);
            item.setData("BACKGROUND_KEY", backgrounds);
            item.setData("FONT_KEY", fontDatas);
        }
    }

    @Override
    public void setChildCount(Object elementOrTreePath, int count) {
        this.preservingSelection(() -> {
            VirtualItem[] virtualItemArray = this.findItems(elementOrTreePath);
            int n2 = virtualItemArray.length;
            int n3 = 0;
            while (n3 < n2) {
                VirtualItem item = virtualItemArray[n3];
                VirtualItem[] virtualItemArray2 = item.getItems();
                int n4 = virtualItemArray2.length;
                int n5 = 0;
                while (n5 < n4) {
                    VirtualItem element = virtualItemArray2[n5];
                    if (element.getData() != null && element.getIndex().intValue() >= count) {
                        this.disassociate(element);
                    }
                    ++n5;
                }
                item.setItemCount(count);
                ++n3;
            }
        });
        this.validate();
    }

    @Override
    public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
        this.preservingSelection(() -> {
            VirtualItem[] virtualItemArray = this.findItems(elementOrTreePath);
            int n = virtualItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualItem item = virtualItemArray[n2];
                if (!hasChildren) {
                    VirtualItem[] virtualItemArray2 = item.getItems();
                    int n3 = virtualItemArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        VirtualItem element = virtualItemArray2[n4];
                        if (element.getData() != null) {
                            this.disassociate(element);
                        }
                        ++n4;
                    }
                }
                item.setHasItems(hasChildren);
                if (hasChildren) {
                    if (!item.getExpanded()) {
                        item.setItemCount(-1);
                    } else {
                        this.virtualLazyUpdateChildCount(item);
                    }
                }
                ++n2;
            }
        });
    }

    @Override
    public boolean getHasChildren(Object elementOrTreePath) {
        VirtualItem[] items = this.findItems(elementOrTreePath);
        if (items.length > 0) {
            return items[0].hasItems();
        }
        return false;
    }

    private void virtualLazyUpdateHasChildren(VirtualItem item) {
        TreePath treePath = this.getTreePathFromItem(item);
        item.clearNeedsCountUpdate();
        this.getContentProvider().updateHasChildren(treePath);
    }

    private void virtualLazyUpdateChildCount(VirtualItem item) {
        item.clearNeedsCountUpdate();
        this.getContentProvider().updateChildCount(this.getTreePathFromItem(item), item.getItemCount());
    }

    private void virtualLazyUpdateData(VirtualItem item) {
        item.clearNeedsDataUpdate();
        this.getContentProvider().updateElement(this.getTreePathFromItem(item.getParent()), item.getIndex().intValue());
    }

    private void virtualLazyUpdateLabel(VirtualItem item) {
        item.clearNeedsLabelUpdate();
        if (!this.getLabelProvider().update(this.getTreePathFromItem(item)) && item.getData() instanceof String) {
            item.setData("LABEL_KEY", new String[]{(String)item.getData()});
        }
    }

    private TreePath getTreePathFromItem(VirtualItem item) {
        LinkedList<Object> segments = new LinkedList<Object>();
        while (item.getParent() != null) {
            segments.add(0, item.getData());
            item = item.getParent();
        }
        return new TreePath(segments.toArray());
    }

    private void unmapElement(Object element, VirtualItem item) {
        List<VirtualItem> itemsList;
        ITreeModelContentProvider provider;
        if (this.fNotifyUnmap && (provider = this.getContentProvider()) instanceof TreeModelContentProvider) {
            ((TreeModelContentProvider)provider).unmapPath((TreePath)item.getData(TREE_PATH_KEY));
        }
        if ((itemsList = this.fItemsMap.get(element)) != null) {
            itemsList.remove(item);
            if (itemsList.isEmpty()) {
                this.fItemsMap.remove(element);
            }
        }
    }

    private void mapElement(Object element, VirtualItem item) {
        List<VirtualItem> itemsList = this.fItemsMap.remove(element);
        if (itemsList == null) {
            itemsList = new ArrayList<VirtualItem>(1);
        }
        if (!itemsList.contains(item)) {
            itemsList.add(item);
        }
        this.fItemsMap.put(element, itemsList);
        item.setData(TREE_PATH_KEY, this.getTreePathFromItem(item));
    }

    @Override
    public void revealed(VirtualItem item) {
        if (item.needsDataUpdate()) {
            this.virtualLazyUpdateData(item);
        } else if (item.getData() != null) {
            if (item.needsLabelUpdate()) {
                this.virtualLazyUpdateLabel(item);
            }
            if (item.needsCountUpdate() && item.getExpanded()) {
                this.virtualLazyUpdateChildCount(item);
            }
        }
    }

    @Override
    public void disposed(VirtualItem item) {
        Object data;
        if (!this.fTree.isDisposed() && (data = item.getData()) != null) {
            this.unmapElement(data, item);
        }
    }

    private void associate(Object element, VirtualItem item) {
        Object data = item.getData();
        if (data != null && data != element && data.equals(element)) {
            try {
                this.fNotifyUnmap = false;
                this.doAssociate(element, item);
            }
            finally {
                this.fNotifyUnmap = true;
            }
        } else {
            this.doAssociate(element, item);
        }
    }

    private void doAssociate(Object element, VirtualItem item) {
        Object data = item.getData();
        if (data != null && data != element && data.equals(element)) {
            this.unmapElement(data, item);
            item.setData(element);
            this.mapElement(element, item);
        } else {
            if (data != element) {
                if (data != null) {
                    this.unmapElement(element, item);
                    this.disassociate(item);
                }
                item.setData(element);
            }
            this.mapElement(element, item);
        }
    }

    private void disassociate(VirtualItem item) {
        this.unmapElement(item.getData(), item);
        item.setData(null);
        VirtualItem[] virtualItemArray = item.getItems();
        int n = virtualItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualItem childItem = virtualItemArray[n2];
            if (childItem.getData() != null) {
                this.disassociate(childItem);
            }
            ++n2;
        }
    }

    public void setSelection(ISelection selection, boolean reveal) {
        this.setSelection(selection, reveal, false);
    }

    @Override
    public void setSelection(ISelection selection, boolean reveal, boolean force) {
        this.trySelection(selection, reveal, force);
    }

    @Override
    public boolean trySelection(ISelection selection, boolean reveal, boolean force) {
        if (!force && !this.overrideSelection(this.getSelection(), selection)) {
            return false;
        }
        if (!this.fPreservingSelecction) {
            this.internalSetSelection(selection, reveal);
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        } else {
            this.fRestoreSelection = false;
            this.internalSetSelection(selection, reveal);
        }
        return true;
    }

    private void internalSetSelection(ISelection selection, boolean reveal) {
        if (selection instanceof ITreeSelection) {
            TreePath[] paths = ((ITreeSelection)selection).getPaths();
            ArrayList<VirtualItem> newSelection = new ArrayList<VirtualItem>(paths.length);
            TreePath[] treePathArray = paths;
            int n = paths.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                VirtualItem item = this.findItem(path);
                if (item != null) {
                    newSelection.add(item);
                }
                ++n2;
            }
            this.fTree.setSelection(newSelection.toArray(new VirtualItem[newSelection.size()]));
            if (reveal && newSelection.size() > 0) {
                int i = newSelection.size() - 1;
                while (i >= 0) {
                    this.fTree.showItem((VirtualItem)newSelection.get(i));
                    --i;
                }
            }
        } else {
            this.fTree.setSelection(EMPTY_ITEMS_ARRAY);
        }
        this.validate();
    }

    @Override
    public void update(Object element) {
        VirtualItem[] virtualItemArray = this.findItems(element);
        int n = virtualItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualItem item = virtualItemArray[n2];
            this.doUpdate(item);
            ++n2;
        }
    }

    public void doUpdate(VirtualItem item) {
        item.setNeedsLabelUpdate();
        this.validate();
    }

    @Override
    public ISelection getSelection() {
        if (this.fTree.isDisposed()) {
            return TreeSelection.EMPTY;
        }
        VirtualItem[] items = this.fTree.getSelection();
        ArrayList<TreePath> list = new ArrayList<TreePath>(items.length);
        LinkedHashMap<VirtualItem, TreePath> map = new LinkedHashMap<VirtualItem, TreePath>(items.length * 4 / 3);
        VirtualItem[] virtualItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualItem item = virtualItemArray[n2];
            TreePath path = null;
            if (item.getData() != null) {
                path = this.getTreePathFromItem(item);
                list.add(path);
            }
            map.put(item, path);
            ++n2;
        }
        return new TreeSelection(list.toArray(new TreePath[list.size()]));
    }

    private void preservingSelection(Runnable updateCode) {
        ISelection oldSelection = null;
        try {
            oldSelection = this.getSelection();
            this.fRestoreSelection = true;
            this.fPreservingSelecction = true;
            updateCode.run();
        }
        finally {
            ISelection newSelection;
            this.fPreservingSelecction = false;
            if (this.fRestoreSelection) {
                this.internalSetSelection(oldSelection, false);
            }
            if (!(newSelection = this.getSelection()).equals(oldSelection)) {
                this.handleInvalidSelection(oldSelection, newSelection);
            }
        }
    }

    @Override
    public void expandToLevel(Object elementOrTreePath, int level) {
        VirtualItem[] items = this.findItems(elementOrTreePath);
        if (items.length > 0) {
            this.expandToLevel(items[0], level);
        }
        this.validate();
    }

    @Override
    public void setExpandedState(Object elementOrTreePath, boolean expanded) {
        VirtualItem[] virtualItemArray = this.findItems(elementOrTreePath);
        int n = virtualItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            VirtualItem item = virtualItemArray[n2];
            item.setExpanded(expanded);
            ++n2;
        }
        this.validate();
    }

    @Override
    public boolean getExpandedState(Object elementOrTreePath) {
        VirtualItem[] items = this.findItems(elementOrTreePath);
        if (items.length > 0) {
            return items[0].getExpanded();
        }
        return false;
    }

    private void expandToLevel(VirtualItem item, int level) {
        if (level == ALL_LEVELS || level > 0) {
            if (!item.hasItems()) {
                return;
            }
            item.setExpanded(true);
            if (item.getData() == null) {
                this.virtualLazyUpdateData(item);
                return;
            }
            if (level == ALL_LEVELS || level > 1) {
                int newLevel = level == ALL_LEVELS ? ALL_LEVELS : level - 1;
                VirtualItem[] virtualItemArray = item.getItems();
                int n = virtualItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    VirtualItem element = virtualItemArray[n2];
                    this.expandToLevel(element, newLevel);
                    ++n2;
                }
            }
        }
    }

    private void handleInvalidSelection(ISelection selection, ISelection newSelection) {
        IModelSelectionPolicy selectionPolicy = ViewerAdapterService.getSelectionPolicy(selection, this.getPresentationContext());
        if (selectionPolicy != null) {
            while (!selection.equals(newSelection)) {
                ISelection temp = newSelection;
                if ((selection = selectionPolicy.replaceInvalidSelection(selection, newSelection)) == null) {
                    selection = TreeSelection.EMPTY;
                }
                if (temp.equals(selection)) break;
                this.internalSetSelection(selection, false);
                newSelection = this.getSelection();
            }
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, newSelection));
    }

    @Override
    public boolean overrideSelection(ISelection current, ISelection candidate) {
        IModelSelectionPolicy selectionPolicy = ViewerAdapterService.getSelectionPolicy(current, this.getPresentationContext());
        if (selectionPolicy == null) {
            return true;
        }
        if (selectionPolicy.contains(candidate, this.getPresentationContext())) {
            return selectionPolicy.overrides(current, candidate, this.getPresentationContext());
        }
        return !selectionPolicy.isSticky(current, this.getPresentationContext());
    }

    @Override
    public ViewerFilter[] getFilters() {
        return this.fFilters;
    }

    @Override
    public void addFilter(ViewerFilter filter) {
        ViewerFilter[] newFilters = new ViewerFilter[this.fFilters.length + 1];
        System.arraycopy(this.fFilters, 0, newFilters, 0, this.fFilters.length);
        newFilters[this.fFilters.length] = filter;
        this.fFilters = newFilters;
    }

    @Override
    public void setFilters(ViewerFilter ... filters) {
        this.fFilters = filters;
    }

    public void dispose() {
        if (this.fColumnPresentation != null) {
            this.fColumnPresentation.dispose();
        }
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
            this.fContentProvider = null;
        }
        if (this.fLabelProvider != null) {
            this.fLabelProvider.dispose();
            this.fLabelProvider = null;
        }
        this.fTree.removeItemListener(this);
        this.fTree.dispose();
    }

    @Override
    public IPresentationContext getPresentationContext() {
        return this.fContext;
    }

    private void resetColumns(Object input) {
        if (input != null) {
            IColumnPresentationFactory factory = ViewerAdapterService.getColumnPresentationFactory(input);
            PresentationContext context = (PresentationContext)this.getPresentationContext();
            String type = null;
            if (factory != null) {
                type = factory.getColumnPresentationId(context, input);
            }
            if (type != null && factory != null) {
                if (this.fColumnPresentation != null && !this.fColumnPresentation.getId().equals(type)) {
                    this.fColumnPresentation.dispose();
                    this.fColumnPresentation = null;
                }
                if (this.fColumnPresentation == null) {
                    this.fColumnPresentation = factory.createColumnPresentation(context, input);
                    if (this.fColumnPresentation != null) {
                        this.fColumnPresentation.init(context);
                        this.configureColumns();
                    }
                }
            } else if (this.fColumnPresentation != null) {
                this.fColumnPresentation.dispose();
                this.fColumnPresentation = null;
                this.configureColumns();
            }
        }
    }

    protected void configureColumns() {
        if (this.fColumnPresentation != null) {
            IColumnPresentation build = null;
            if (this.isShowColumns(this.fColumnPresentation.getId())) {
                build = this.fColumnPresentation;
            }
            this.buildColumns(build);
        } else {
            this.buildColumns(null);
        }
    }

    public void setShowColumns(boolean show) {
        if (show) {
            if (!this.isShowColumns()) {
                this.fShowColumns.remove(this.fColumnPresentation.getId());
            }
        } else if (this.isShowColumns()) {
            this.fShowColumns.put(this.fColumnPresentation.getId(), Boolean.FALSE);
        }
        this.refreshColumns();
    }

    protected void refreshColumns() {
        this.configureColumns();
        this.refresh();
    }

    public boolean isShowColumns() {
        if (this.fColumnPresentation != null) {
            return this.isShowColumns(this.fColumnPresentation.getId());
        }
        return false;
    }

    public boolean canToggleColumns() {
        return this.fColumnPresentation != null && this.fColumnPresentation.isOptional();
    }

    protected boolean isShowColumns(String columnPresentationId) {
        Boolean bool = this.fShowColumns.get(columnPresentationId);
        if (bool == null) {
            return true;
        }
        return bool;
    }

    protected void buildColumns(IColumnPresentation presentation) {
        PresentationContext presentationContext = (PresentationContext)this.getPresentationContext();
        if (presentation != null) {
            presentationContext.setColumns(this.getVisibleColumns());
        } else {
            presentationContext.setColumns(null);
        }
    }

    @Override
    public String[] getVisibleColumns() {
        IColumnPresentation presentation;
        if (this.isShowColumns() && (presentation = this.getColumnPresentation()) != null) {
            String[] columns = this.fVisibleColumns.get(presentation.getId());
            if (columns == null) {
                return presentation.getInitialColumns();
            }
            return columns;
        }
        return null;
    }

    public void setVisibleColumns(String[] ids) {
        IColumnPresentation presentation;
        if (ids != null && ids.length == 0) {
            ids = null;
        }
        if ((presentation = this.getColumnPresentation()) != null) {
            this.fVisibleColumns.remove(presentation.getId());
            if (ids != null) {
                String[] columns = presentation.getInitialColumns();
                if (columns.length == ids.length) {
                    int i = 0;
                    while (i < columns.length) {
                        if (!ids[i].equals(columns[i])) {
                            this.fVisibleColumns.put(presentation.getId(), ids);
                            break;
                        }
                        ++i;
                    }
                } else {
                    this.fVisibleColumns.put(presentation.getId(), ids);
                }
            }
            PresentationContext presentationContext = (PresentationContext)this.getPresentationContext();
            presentationContext.setColumns(this.getVisibleColumns());
            this.refreshColumns();
        }
    }

    public IColumnPresentation getColumnPresentation() {
        return this.fColumnPresentation;
    }

    public void saveState(IMemento memento) {
        IPresentationContext iPresentationContext;
        if (!this.fShowColumns.isEmpty()) {
            for (Map.Entry<String, Boolean> entry : this.fShowColumns.entrySet()) {
                IMemento sizes = memento.createChild(SHOW_COLUMNS, entry.getKey());
                sizes.putString(SHOW_COLUMNS, entry.getValue().toString());
            }
        }
        if (!this.fVisibleColumns.isEmpty()) {
            for (Map.Entry<String, Boolean> entry : this.fVisibleColumns.entrySet()) {
                IMemento visible = memento.createChild(VISIBLE_COLUMNS, entry.getKey());
                String[] columns = (String[])entry.getValue();
                visible.putInteger(SIZE, columns.length);
                int i = 0;
                while (i < columns.length) {
                    visible.putString(COLUMN + i, columns[i]);
                    ++i;
                }
            }
        }
        if ((iPresentationContext = this.getPresentationContext()) instanceof PresentationContext) {
            PresentationContext pc = (PresentationContext)iPresentationContext;
            pc.saveProperites(memento);
        }
    }

    public void initState(IMemento memento) {
        String id;
        IMemento child;
        IMemento[] iMementoArray = memento.getChildren(SHOW_COLUMNS);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = iMementoArray[n2];
            id = child.getID();
            Boolean bool = Boolean.valueOf(child.getString(SHOW_COLUMNS));
            if (!bool.booleanValue()) {
                this.fShowColumns.put(id, bool);
            }
            ++n2;
        }
        iMementoArray = memento.getChildren(VISIBLE_COLUMNS);
        n = iMementoArray.length;
        n2 = 0;
        while (n2 < n) {
            child = iMementoArray[n2];
            id = child.getID();
            Integer integer = child.getInteger(SIZE);
            if (integer != null) {
                int length = integer;
                String[] columns = new String[length];
                int j = 0;
                while (j < length) {
                    columns[j] = child.getString(COLUMN + j);
                    ++j;
                }
                this.fVisibleColumns.put(id, columns);
            }
            ++n2;
        }
        IPresentationContext context = this.getPresentationContext();
        if (context instanceof PresentationContext) {
            PresentationContext pc = (PresentationContext)context;
            pc.initProperties(memento);
        }
    }

    @Override
    public void addViewerUpdateListener(IViewerUpdateListener listener) {
        this.getContentProvider().addViewerUpdateListener(listener);
    }

    @Override
    public void removeViewerUpdateListener(IViewerUpdateListener listener) {
        ITreeModelContentProvider cp = this.getContentProvider();
        if (cp != null) {
            cp.removeViewerUpdateListener(listener);
        }
    }

    @Override
    public void addModelChangedListener(IModelChangedListener listener) {
        this.getContentProvider().addModelChangedListener(listener);
    }

    @Override
    public void removeModelChangedListener(IModelChangedListener listener) {
        ITreeModelContentProvider cp = this.getContentProvider();
        if (cp != null) {
            cp.removeModelChangedListener(listener);
        }
    }

    @Override
    public void addStateUpdateListener(IStateUpdateListener listener) {
        this.getContentProvider().addStateUpdateListener(listener);
    }

    @Override
    public void removeStateUpdateListener(IStateUpdateListener listener) {
        ITreeModelContentProvider cp = this.getContentProvider();
        if (cp != null) {
            cp.removeStateUpdateListener(listener);
        }
    }

    @Override
    public void addLabelUpdateListener(ILabelUpdateListener listener) {
        this.getLabelProvider().addLabelUpdateListener(listener);
    }

    @Override
    public void removeLabelUpdateListener(ILabelUpdateListener listener) {
        this.getLabelProvider().removeLabelUpdateListener(listener);
    }

    @Override
    public void autoExpand(TreePath elementPath) {
        int level = this.getAutoExpandLevel();
        if (!(level <= 0 && level != -1 || level != -1 && level <= elementPath.getSegmentCount())) {
            this.expandToLevel(elementPath, 1);
        }
    }

    @Override
    public int getChildCount(TreePath path) {
        int childCount = -1;
        VirtualItem[] items = this.findItems(path);
        if (items.length > 0 && (childCount = items[0].getItemCount()) == -1) {
            childCount = items[0].hasItems() ? 1 : 0;
        }
        return childCount;
    }

    @Override
    public Object getChildElement(TreePath path, int index) {
        VirtualItem[] items = this.findItems(path);
        if (items.length > 0 && index < items[0].getItemCount()) {
            return items[0].getItem(new VirtualItem.Index(index)).getData();
        }
        return null;
    }

    @Override
    public TreePath getTopElementPath() {
        return null;
    }

    @Override
    public boolean saveElementState(TreePath path, ModelDelta delta, int flagsToSave) {
        VirtualTree tree = this.getTree();
        VirtualItem[] selection = tree.getSelection();
        HashSet<VirtualItem> set = new HashSet<VirtualItem>();
        Collections.addAll(set, selection);
        VirtualItem parent = this.findItem(path);
        if (parent != null) {
            delta.setChildCount(((TreeModelContentProvider)this.getContentProvider()).viewToModelCount(path, parent.getItemCount()));
            if (parent.getExpanded()) {
                if ((flagsToSave & 0x100000) != 0) {
                    delta.setFlags(delta.getFlags() | 0x100000);
                }
            } else if ((flagsToSave & 0x2000000) != 0 && parent.hasItems()) {
                delta.setFlags(delta.getFlags() | 0x2000000);
            }
            if (set.contains(parent) && (flagsToSave & 0x200000) != 0) {
                delta.setFlags(delta.getFlags() | 0x200000);
            }
            VirtualItem[] virtualItemArray = parent.getItems();
            int n = virtualItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualItem item = virtualItemArray[n2];
                this.doSaveElementState(path, delta, item, set, flagsToSave);
                ++n2;
            }
            return true;
        }
        return false;
    }

    private void doSaveElementState(TreePath parentPath, ModelDelta delta, VirtualItem item, Collection<VirtualItem> set, int flagsToSave) {
        Object element = item.getData();
        if (element != null) {
            boolean expanded = item.getExpanded();
            boolean selected = set.contains(item);
            int flags = 0;
            if (expanded && (flagsToSave & 0x100000) != 0) {
                flags |= 0x100000;
            }
            if (!expanded && (flagsToSave & 0x2000000) != 0 && item.hasItems()) {
                flags |= 0x2000000;
            }
            if (selected && (flagsToSave & 0x200000) != 0) {
                flags |= 0x200000;
            }
            if (expanded || flags != 0) {
                int modelIndex = ((TreeModelContentProvider)this.getContentProvider()).viewToModelIndex(parentPath, item.getIndex().intValue());
                TreePath elementPath = parentPath.createChildPath(element);
                int numChildren = ((TreeModelContentProvider)this.getContentProvider()).viewToModelCount(elementPath, item.getItemCount());
                ModelDelta childDelta = delta.addNode(element, modelIndex, flags, numChildren);
                if (expanded) {
                    VirtualItem[] virtualItemArray = item.getItems();
                    int n = virtualItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VirtualItem childItem = virtualItemArray[n2];
                        this.doSaveElementState(elementPath, childDelta, childItem, set, flagsToSave);
                        ++n2;
                    }
                }
            }
        }
    }

    @Override
    public void updateViewer(IModelDelta delta) {
        this.getContentProvider().updateModel(delta, -1);
    }

    @Override
    public ViewerLabel getElementLabel(TreePath path, String columnId) {
        VirtualItem item;
        if (path.getSegmentCount() == 0) {
            return null;
        }
        int columnIdx = -1;
        String[] visibleColumns = this.getVisibleColumns();
        if (columnId != null && visibleColumns != null) {
            int i = 0;
            i = 0;
            while (i < visibleColumns.length) {
                if (columnId.equals(this.getVisibleColumns()[i])) {
                    columnIdx = i;
                    break;
                }
                ++i;
            }
            if (i == visibleColumns.length) {
                return null;
            }
        } else {
            columnIdx = 0;
        }
        if ((item = this.findItem(path)) != null) {
            ViewerLabel label = new ViewerLabel(this.getText(item, columnIdx), this.getImage(item, columnIdx));
            label.setFont(this.getFont(item, columnIdx));
            label.setBackground(this.getBackground(item, columnIdx));
            label.setForeground(this.getForeground(item, columnIdx));
            return label;
        }
        return null;
    }

    @Override
    public TreePath[] getElementPaths(Object element) {
        VirtualItem[] items = this.findItems(element);
        TreePath[] paths = new TreePath[items.length];
        int i = 0;
        while (i < items.length) {
            paths[i] = this.getTreePathFromItem(items[i]);
            ++i;
        }
        return paths;
    }

    public String getText(VirtualItem item, int columnIdx) {
        String[] texts = (String[])item.getData("LABEL_KEY");
        if (texts != null && texts.length > columnIdx) {
            return texts[columnIdx];
        }
        return null;
    }

    public Image getImage(VirtualItem item, int columnIdx) {
        ImageDescriptor[] imageDescriptors = (ImageDescriptor[])item.getData("IMAGE_KEY");
        if (imageDescriptors != null && imageDescriptors.length > columnIdx) {
            return this.getLabelProvider().getImage(imageDescriptors[columnIdx]);
        }
        return null;
    }

    public Font getFont(VirtualItem item, int columnIdx) {
        FontData[] fontDatas = (FontData[])item.getData("FONT_KEY");
        if (fontDatas != null) {
            return this.getLabelProvider().getFont(fontDatas[columnIdx]);
        }
        return null;
    }

    public Color getForeground(VirtualItem item, int columnIdx) {
        RGB[] rgbs = (RGB[])item.getData("FOREGROUND_KEY");
        if (rgbs != null) {
            return this.getLabelProvider().getColor(rgbs[columnIdx]);
        }
        return null;
    }

    public Color getBackground(VirtualItem item, int columnIdx) {
        RGB[] rgbs = (RGB[])item.getData("BACKGROUND_KEY");
        if (rgbs != null) {
            return this.getLabelProvider().getColor(rgbs[columnIdx]);
        }
        return null;
    }

    @Override
    public void clearSelectionQuiet() {
        this.getTree().setSelection(EMPTY_ITEMS_ARRAY);
    }

    @Override
    public boolean getElementChecked(TreePath path) {
        return false;
    }

    @Override
    public boolean getElementGrayed(TreePath path) {
        return false;
    }

    @Override
    public void setElementChecked(TreePath path, boolean checked, boolean grayed) {
    }

    public String toString() {
        return this.getTree().toString();
    }
}

