/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.resources.IEncodedStorage;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.editors.text.DocumentReader;
import org.eclipse.ui.editors.text.IStorageDocumentProvider;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.internal.editors.text.EditorsPlugin;
import org.eclipse.ui.internal.editors.text.NLSUtility;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;
import org.osgi.framework.Bundle;

public class StorageDocumentProvider
extends AbstractDocumentProvider
implements IStorageDocumentProvider {
    protected static final int DEFAULT_FILE_SIZE = 15360;
    private static final QualifiedName[] NO_PROPERTIES = new QualifiedName[0];

    @Deprecated
    protected void setDocumentContent(IDocument document, InputStream contentStream) throws CoreException {
        this.setDocumentContent(document, contentStream, null);
    }

    protected void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
        if (encoding == null) {
            encoding = this.getDefaultEncoding();
        }
        try {
            try {
                String content = new String(contentStream.readAllBytes(), encoding);
                document.set(content);
            }
            catch (IOException x) {
                String message = x.getMessage() != null ? x.getMessage() : "";
                Status s = new Status(4, "org.eclipse.ui", 0, message, (Throwable)x);
                throw new CoreException((IStatus)s);
            }
        }
        catch (Throwable throwable) {
            try {
                contentStream.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            contentStream.close();
        }
        catch (IOException iOException) {}
    }

    @Deprecated
    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput) throws CoreException {
        return this.setDocumentContent(document, editorInput, null);
    }

    protected boolean setDocumentContent(IDocument document, IEditorInput editorInput, String encoding) throws CoreException {
        if (editorInput instanceof IStorageEditorInput) {
            IStorage storage = ((IStorageEditorInput)editorInput).getStorage();
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (InputStream stream = storage.getContents();){
                    this.setDocumentContent(document, stream, encoding);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            return true;
        }
        return false;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected IDocument createEmptyDocument() {
        return new Document();
    }

    protected IDocument createDocument(Object element) throws CoreException {
        IDocument document;
        if (element instanceof IEditorInput && this.setDocumentContent(document = this.createEmptyDocument(), (IEditorInput)element, this.getEncoding(element))) {
            this.setupDocument(element, document);
            return document;
        }
        return null;
    }

    protected void setupDocument(Object element, IDocument document) {
    }

    protected AbstractDocumentProvider.ElementInfo createElementInfo(Object element) throws CoreException {
        if (element instanceof IStorageEditorInput) {
            IDocument document = null;
            IStatus status = null;
            try {
                document = this.createDocument(element);
            }
            catch (CoreException x) {
                status = x.getStatus();
                document = this.createEmptyDocument();
            }
            StorageInfo info = new StorageInfo(document, this.createAnnotationModel(element));
            info.fStatus = status;
            info.fEncoding = this.getPersistedEncoding(element);
            return info;
        }
        return super.createElementInfo(element);
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
    }

    protected void handleCoreException(CoreException exception, String message) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog log = ILog.of((Bundle)bundle);
        if (message != null) {
            log.log((IStatus)new Status(4, "org.eclipse.ui", 0, message, (Throwable)exception));
        } else {
            log.log(exception.getStatus());
        }
    }

    protected void updateCache(IStorageEditorInput input) throws CoreException {
        StorageInfo info = (StorageInfo)this.getElementInfo(input);
        if (info != null) {
            try {
                IStorage storage = input.getStorage();
                if (storage != null) {
                    boolean readOnly;
                    info.fIsReadOnly = readOnly = storage.isReadOnly();
                    info.fIsModifiable = !readOnly;
                }
            }
            catch (CoreException x) {
                this.handleCoreException(x, TextEditorMessages.StorageDocumentProvider_updateCache);
            }
            info.fUpdateCache = false;
        }
    }

    public boolean isReadOnly(Object element) {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            if (info.fUpdateCache) {
                try {
                    this.updateCache((IStorageEditorInput)element);
                }
                catch (CoreException x) {
                    this.handleCoreException(x, TextEditorMessages.StorageDocumentProvider_isReadOnly);
                }
            }
            return info.fIsReadOnly;
        }
        return super.isReadOnly(element);
    }

    public boolean isNotSynchronizedException(Object element, CoreException ex) {
        IStatus status = ex.getStatus();
        if (status == null || status instanceof MultiStatus) {
            return false;
        }
        if (status.getException() != null) {
            return false;
        }
        return status.getCode() == 274;
    }

    public boolean isModifiable(Object element) {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            if (info.fUpdateCache) {
                try {
                    this.updateCache((IStorageEditorInput)element);
                }
                catch (CoreException x) {
                    this.handleCoreException(x, TextEditorMessages.StorageDocumentProvider_isModifiable);
                }
            }
            return info.fIsModifiable;
        }
        return super.isModifiable(element);
    }

    protected void doUpdateStateCache(Object element) throws CoreException {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            info.fUpdateCache = true;
        }
        super.doUpdateStateCache(element);
    }

    @Override
    public String getDefaultEncoding() {
        return ResourcesPlugin.getEncoding();
    }

    @Override
    public String getEncoding(Object element) {
        if (element instanceof IStorageEditorInput) {
            StorageInfo info = (StorageInfo)this.getElementInfo(element);
            if (info != null) {
                return info.fEncoding;
            }
            return this.getPersistedEncoding(element);
        }
        return null;
    }

    @Override
    public void setEncoding(Object element, String encoding) {
        StorageInfo info;
        if (element instanceof IStorageEditorInput && (info = (StorageInfo)this.getElementInfo(element)) != null) {
            info.fEncoding = encoding;
            try {
                this.persistEncoding(element, encoding);
            }
            catch (CoreException ex) {
                EditorsPlugin.log(ex.getStatus());
            }
        }
    }

    public IContentType getContentType(Object element) throws CoreException {
        if (element instanceof IStorageEditorInput) {
            IStorage storage = ((IStorageEditorInput)element).getStorage();
            try {
                IContentDescription desc;
                block23: {
                    IDocument document = this.getDocument(element);
                    if (document != null) {
                        Throwable throwable = null;
                        Object var6_10 = null;
                        try (DocumentReader reader = new DocumentReader(document);){
                            desc = Platform.getContentTypeManager().getDescriptionFor((Reader)reader, storage.getName(), NO_PROPERTIES);
                            break block23;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    Throwable throwable = null;
                    Object var6_12 = null;
                    try (InputStream stream = storage.getContents();){
                        desc = Platform.getContentTypeManager().getDescriptionFor(stream, storage.getName(), NO_PROPERTIES);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                if (desc != null && desc.getContentType() != null) {
                    return desc.getContentType();
                }
            }
            catch (IOException x) {
                IPath path = storage.getFullPath();
                String name = path != null ? path.toOSString() : storage.getName();
                String message = name != null ? NLSUtility.format(TextEditorMessages.StorageDocumentProvider_getContentDescriptionFor, name) : TextEditorMessages.StorageDocumentProvider_getContentDescription;
                throw new CoreException((IStatus)new Status(4, "org.eclipse.ui.editors", 0, message, (Throwable)x));
            }
        }
        return super.getContentType(element);
    }

    protected String getPersistedEncoding(Object element) {
        if (element instanceof IStorageEditorInput) {
            try {
                IStorage storage = ((IStorageEditorInput)element).getStorage();
                if (storage instanceof IEncodedStorage) {
                    return ((IEncodedStorage)storage).getCharset();
                }
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return null;
    }

    protected void persistEncoding(Object element, String encoding) throws CoreException {
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor monitor) {
        return null;
    }

    protected class StorageInfo
    extends AbstractDocumentProvider.ElementInfo {
        public boolean fIsModifiable;
        public boolean fIsReadOnly;
        public boolean fUpdateCache;
        public String fEncoding;

        public StorageInfo(IDocument document, IAnnotationModel model) {
            super((AbstractDocumentProvider)StorageDocumentProvider.this, document, model);
            this.fIsModifiable = false;
            this.fIsReadOnly = true;
            this.fUpdateCache = true;
            this.fEncoding = null;
        }
    }
}

