/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.parser;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tm4e.core.internal.parser.PropertySettable;
import org.eclipse.tm4e.core.internal.parser.TMParser;
import org.eclipse.tm4e.core.internal.parser.TMParserPropertyPath;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public final class TMParserPList
implements TMParser {
    private static final System.Logger LOGGER = System.getLogger(TMParserPList.class.getName());
    private static final String PLIST_ARRAY = "array";
    private static final String PLIST_DICT = "dict";
    public static final TMParserPList INSTANCE = new TMParserPList();

    protected TMParserPList() {
    }

    @Override
    public <T extends PropertySettable<?>> T parse(Reader source, TMParser.ObjectFactory<T> factory) throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        SAXParser saxParser = spf.newSAXParser();
        saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        XMLReader xmlReader = saxParser.getXMLReader();
        xmlReader.setEntityResolver((publicId, systemId) -> new InputSource(new ByteArrayInputStream("<?xml version='1.0' encoding='UTF-8'?>".getBytes())));
        T root = factory.createRoot();
        xmlReader.setContentHandler(new DefaultHandler((PropertySettable)root, factory){
            final List<ParentRef> parents = new ArrayList<ParentRef>();
            final TMParserPropertyPath path = new TMParserPropertyPath();
            final StringBuilder text = new StringBuilder();
            private final /* synthetic */ PropertySettable val$root;
            private final /* synthetic */ TMParser.ObjectFactory val$factory;
            {
                this.val$root = propertySettable;
                this.val$factory = objectFactory;
            }

            @Override
            public void characters(char @Nullable [] chars, int start, int count) {
                this.text.append(chars, start, count);
            }

            @Override
            @NonNullByDefault(value={})
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                this.text.setLength(0);
                switch (localName) {
                    case "dict": {
                        if (this.parents.isEmpty()) {
                            this.parents.add(new ParentRef(localName, this.val$root));
                            return;
                        }
                        this.parents.add(new ParentRef(localName, this.val$factory.createChild(this.path, Map.class)));
                        break;
                    }
                    case "array": {
                        ParentRef newParentRef = new ParentRef(localName, this.val$factory.createChild(this.path, List.class));
                        this.parents.add(newParentRef);
                        newParentRef.nextPropertyToSet = 0;
                        this.path.add(newParentRef.nextPropertyToSet);
                    }
                }
            }

            @Override
            @NonNullByDefault(value={})
            public void endElement(String uri, String localName, String qName) {
                switch (localName) {
                    case "array": {
                        ParentRef parentRef = this.parents.remove(this.parents.size() - 1);
                        this.path.removeLast();
                        this.setCurrentProperty(parentRef.parent);
                        break;
                    }
                    case "dict": {
                        ParentRef parentRef = this.parents.remove(this.parents.size() - 1);
                        if (this.parents.isEmpty()) break;
                        this.setCurrentProperty(parentRef.parent);
                        break;
                    }
                    case "key": {
                        ParentRef parentRef = this.parents.get(this.parents.size() - 1);
                        if (!TMParserPList.PLIST_DICT.equals(parentRef.sourceKind)) {
                            LOGGER.log(System.Logger.Level.ERROR, "<key> tag can only be used inside an open <dict> element");
                            break;
                        }
                        String key = this.text.toString();
                        parentRef.nextPropertyToSet = key;
                        this.path.add(key);
                        break;
                    }
                    case "string": 
                    case "data": {
                        this.setCurrentProperty(this.text.toString());
                        break;
                    }
                    case "date": {
                        try {
                            this.setCurrentProperty(ZonedDateTime.parse(this.text.toString()));
                        }
                        catch (DateTimeParseException ex) {
                            LOGGER.log(System.Logger.Level.ERROR, "Failed to parse date '" + String.valueOf(this.text) + "'. " + String.valueOf(ex));
                        }
                        break;
                    }
                    case "integer": {
                        try {
                            this.setCurrentProperty(Integer.parseInt(this.text.toString()));
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.log(System.Logger.Level.ERROR, "Failed to parse integer '" + String.valueOf(this.text) + "'. " + String.valueOf(ex));
                        }
                        break;
                    }
                    case "real": {
                        try {
                            this.setCurrentProperty(Float.valueOf(Float.parseFloat(this.text.toString())));
                        }
                        catch (NumberFormatException ex) {
                            LOGGER.log(System.Logger.Level.ERROR, "Failed to parse real as float '" + String.valueOf(this.text) + "'. " + String.valueOf(ex));
                        }
                        break;
                    }
                    case "true": {
                        this.setCurrentProperty(Boolean.TRUE);
                        break;
                    }
                    case "false": {
                        this.setCurrentProperty(Boolean.FALSE);
                        break;
                    }
                    default: {
                        LOGGER.log(System.Logger.Level.ERROR, "Invalid tag name: " + localName);
                    }
                    case "plist": 
                }
            }

            private void setCurrentProperty(Object value) {
                this.path.removeLast();
                ParentRef obj = this.parents.get(this.parents.size() - 1);
                switch (obj.sourceKind) {
                    case "array": {
                        Integer idx = NullSafetyHelper.castNonNull((Integer)obj.nextPropertyToSet);
                        obj.parent.setProperty(idx.toString(), value);
                        obj.nextPropertyToSet = idx + 1;
                        this.path.add(obj.nextPropertyToSet);
                        break;
                    }
                    case "dict": {
                        obj.parent.setProperty(NullSafetyHelper.castNonNull(obj.nextPropertyToSet).toString(), value);
                    }
                }
            }
        });
        xmlReader.parse(new InputSource(source));
        return root;
    }

    private static final class ParentRef {
        final String sourceKind;
        final PropertySettable<?> parent;
        @Nullable Object nextPropertyToSet;

        ParentRef(String sourceKind, PropertySettable<?> parent) {
            this.sourceKind = sourceKind;
            this.parent = parent;
        }
    }
}

