import type { CompilerOptions, LanguageService, LanguageServiceHost, ModuleResolutionHost, Program, TypeAcquisition } from 'typescript/lib/tsserverlibrary';
import { type Project } from './project';
import { PackageJsonAutoImportPreference } from './projectService';
import { SymlinkCache } from './symlinkCache';
export declare function createAutoImportProviderProjectStatic(tsBase: typeof import('typescript/lib/tsserverlibrary'), host: LanguageServiceHost, createLanguageService: (host: LanguageServiceHost) => LanguageService): {
    maxDependencies: number;
    compilerOptionsOverrides: {
        diagnostics: boolean;
        skipLibCheck: boolean;
        sourceMap: boolean;
        types: any;
        lib: any;
        noLib: boolean;
    };
    getRootFileNames(dependencySelection: PackageJsonAutoImportPreference, hostProject: Project, moduleResolutionHost: ModuleResolutionHost, compilerOptions: CompilerOptions): string[];
    create(dependencySelection: PackageJsonAutoImportPreference, hostProject: Project, moduleResolutionHost: ModuleResolutionHost): {
        projectVersion: number;
        getProjectVersion(): string;
        rootFileNames: string[] | undefined;
        hostProject: {
            dirty: boolean;
            hostProject: any;
            languageServiceEnabled: boolean;
            languageService: LanguageService | undefined;
            projectService: {
                serverMode: import("typescript").LanguageServiceMode;
                host: import("typescript").System;
                currentDirectory: any;
                toCanonicalFileName: any;
                toPath(fileName: string): any;
                getExecutingFilePath(): any;
                getNormalizedAbsolutePath(fileName: string): any;
                packageJsonCache: import("./packageJsonCache").PackageJsonCache;
                getPackageJsonsVisibleToFile(fileName: string, rootDir?: string | undefined): readonly import("./packageJsonCache").ProjectPackageJsonInfo[];
                includePackageJsonAutoImports(): PackageJsonAutoImportPreference;
                fileExists(fileName: import("typescript").server.NormalizedPath): boolean;
            };
            getCanonicalFileName: any;
            exportMapCache: import("./exportInfoMap").ExportInfoMap | undefined;
            getCachedExportInfoMap(): any;
            clearCachedExportInfoMap(): void;
            moduleSpecifierCache: import("./moduleSpecifierCache").ModuleSpecifierCache;
            getModuleSpecifierCache(): import("./moduleSpecifierCache").ModuleSpecifierCache;
            compilerOptions: CompilerOptions;
            getCompilationSettings(): CompilerOptions;
            getCompilerOptions(): CompilerOptions;
            program: Program | undefined;
            getCurrentProgram(): Program | undefined;
            currentDirectory: any;
            getCurrentDirectory(): string;
            symlinks: SymlinkCache | undefined;
            getSymlinkCache(): SymlinkCache;
            packageJsonsForAutoImport: Set<string> | undefined;
            getPackageJsonsForAutoImport(rootDir?: string | undefined): readonly import("./packageJsonCache").ProjectPackageJsonInfo[];
            getPackageJsonsVisibleToFile(fileName: string, rootDir?: string | undefined): readonly import("./packageJsonCache").ProjectPackageJsonInfo[];
            getModuleResolutionHostForAutoImportProvider(): ModuleResolutionHost;
            autoImportProviderHost: false | {
                getCurrentProgram(): Program | undefined;
                isEmpty(): boolean;
                close(): void;
                markAsDirty(): void;
            } | undefined;
            getPackageJsonAutoImportProvider(): Program | undefined;
            includePackageJsonAutoImports(): PackageJsonAutoImportPreference;
            close(): void;
            log(_message: string): void;
            sendPerformanceEvent(_kind: "UpdateGraph" | "CreatePackageJsonAutoImportProvider", _durationMs: number): void;
            toPath(fileName: string): any;
            getGlobalTypingsCacheLocation(): undefined;
            useSourceOfProjectReferenceRedirect(): boolean;
            onAutoImportProviderSettingsChanged(): void;
        };
        isEmpty(): boolean;
        isOrphan(): boolean;
        updateGraph(): void;
        scheduleInvalidateResolutionsOfFailedLookupLocations(): void;
        hasRoots(): boolean;
        markAsDirty(): void;
        getScriptFileNames(): any;
        getLanguageService(): never;
        onAutoImportProviderSettingsChanged(): never;
        onPackageJsonChange(): never;
        getModuleResolutionHostForAutoImportProvider(): never;
        includePackageJsonAutoImports(): PackageJsonAutoImportPreference;
        getTypeAcquisition(): TypeAcquisition;
        getSymlinkCache(): SymlinkCache;
        getModuleResolutionCache(): any;
        dirty: boolean;
        languageServiceEnabled: boolean;
        languageService: LanguageService | undefined;
        projectService: {
            serverMode: import("typescript").LanguageServiceMode;
            host: import("typescript").System;
            currentDirectory: any;
            toCanonicalFileName: any;
            toPath(fileName: string): any;
            getExecutingFilePath(): any;
            getNormalizedAbsolutePath(fileName: string): any;
            packageJsonCache: import("./packageJsonCache").PackageJsonCache;
            getPackageJsonsVisibleToFile(fileName: string, rootDir?: string | undefined): readonly import("./packageJsonCache").ProjectPackageJsonInfo[];
            includePackageJsonAutoImports(): PackageJsonAutoImportPreference;
            fileExists(fileName: import("typescript").server.NormalizedPath): boolean;
        };
        getCanonicalFileName: any;
        exportMapCache: import("./exportInfoMap").ExportInfoMap | undefined;
        getCachedExportInfoMap(): any;
        clearCachedExportInfoMap(): void;
        moduleSpecifierCache: import("./moduleSpecifierCache").ModuleSpecifierCache;
        getModuleSpecifierCache(): import("./moduleSpecifierCache").ModuleSpecifierCache;
        compilerOptions: CompilerOptions;
        getCompilationSettings(): CompilerOptions;
        getCompilerOptions(): CompilerOptions;
        program: Program | undefined;
        getCurrentProgram(): Program | undefined;
        currentDirectory: any;
        getCurrentDirectory(): string;
        symlinks: SymlinkCache | undefined;
        packageJsonsForAutoImport: Set<string> | undefined;
        getPackageJsonsForAutoImport(rootDir?: string | undefined): readonly import("./packageJsonCache").ProjectPackageJsonInfo[];
        getPackageJsonsVisibleToFile(fileName: string, rootDir?: string | undefined): readonly import("./packageJsonCache").ProjectPackageJsonInfo[];
        autoImportProviderHost: false | {
            getCurrentProgram(): Program | undefined;
            isEmpty(): boolean;
            close(): void;
            markAsDirty(): void;
        } | undefined;
        getPackageJsonAutoImportProvider(): Program | undefined;
        close(): void;
        log(_message: string): void;
        sendPerformanceEvent(_kind: "UpdateGraph" | "CreatePackageJsonAutoImportProvider", _durationMs: number): void;
        toPath(fileName: string): any;
        getGlobalTypingsCacheLocation(): undefined;
        useSourceOfProjectReferenceRedirect(): boolean;
    } | undefined;
};
