/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.xwt.model.jface;

import java.lang.reflect.Method;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildAddAfter;
import org.eclipse.wb.internal.core.utils.state.GlobalState;
import org.eclipse.wb.internal.core.xml.model.EditorContext;
import org.eclipse.wb.internal.core.xml.model.IWrapperInfo;
import org.eclipse.wb.internal.core.xml.model.XmlObjectInfo;
import org.eclipse.wb.internal.core.xml.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.xml.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.xml.model.utils.XmlObjectUtils;
import org.eclipse.wb.internal.xwt.model.jface.ViewerControlCreationSupport;
import org.eclipse.wb.internal.xwt.model.jface.ViewerCreationSupport;
import org.eclipse.wb.internal.xwt.model.property.editor.style.StylePropertyEditor;
import org.eclipse.wb.internal.xwt.model.widgets.ControlInfo;

public class ViewerInfo
extends XmlObjectInfo
implements IWrapperInfo {
    private ControlInfo m_wrappedControl;
    private boolean m_deleting;

    public ViewerInfo(EditorContext context, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(context, description, creationSupport);
        StylePropertyEditor.addStyleProperty(this);
        if (GlobalState.isParsing()) {
            this.addBroadcastListener(new ObjectInfoChildAddAfter(){

                public void invoke(ObjectInfo parent, ObjectInfo child) throws Exception {
                    if (child == ViewerInfo.this) {
                        ViewerInfo.this.removeBroadcastListener(this);
                        ViewerInfo.this.rebindHierarchy();
                    }
                }
            });
        }
    }

    public ControlInfo getControl() {
        return (ControlInfo)this.getParent();
    }

    public ControlInfo getWrapped() throws Exception {
        if (this.m_wrappedControl == null) {
            Method method = this.getWrapperMethod();
            String property = ViewerInfo.getPropertyName(method);
            this.m_wrappedControl = (ControlInfo)XmlObjectUtils.createObject((EditorContext)this.getContext(), method.getReturnType(), (CreationSupport)new ViewerCreationSupport(this, method, property));
        }
        return this.m_wrappedControl;
    }

    public void delete() throws Exception {
        if (!this.m_deleting) {
            this.m_deleting = true;
            ControlInfo wrapped = this.getControl();
            if (!wrapped.isDeleting()) {
                this.m_deleting = true;
                try {
                    wrapped.delete();
                }
                finally {
                    this.m_deleting = false;
                }
                return;
            }
        }
        super.delete();
    }

    private void rebindHierarchy() throws Exception {
        Method method = this.getWrapperMethod();
        String property = ViewerInfo.getPropertyName(method);
        XmlObjectInfo control = XmlObjectUtils.createObject((EditorContext)this.getContext(), method.getReturnType(), (CreationSupport)new ViewerControlCreationSupport(this, method, property));
        ObjectInfo parent = this.getParent();
        parent.addChild((ObjectInfo)control, (ObjectInfo)this);
        parent.removeChild((ObjectInfo)this);
        control.addChild((ObjectInfo)this);
    }

    private Method getWrapperMethod() throws NoSuchMethodException {
        String methodName = XmlObjectUtils.getParameter((XmlObjectInfo)this, (String)"viewer.control.method");
        return this.getDescription().getComponentClass().getMethod(methodName, new Class[0]);
    }

    private static String getPropertyName(Method method) {
        String property = StringUtils.removeStart((String)method.getName(), (String)"get");
        return StringUtils.uncapitalize((String)property);
    }
}

