/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor.palette.model;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.xml.editor.palette.model.CategoryInfo;
import org.eclipse.wb.internal.core.xml.editor.palette.model.EntryInfo;

public final class PaletteInfo {
    private final List<CategoryInfo> m_categories = Lists.newArrayList();

    public String toString() {
        return StringUtils.join(this.m_categories.iterator(), (String)",\n\t");
    }

    public List<CategoryInfo> getCategories() {
        return this.m_categories;
    }

    public void addCategory(CategoryInfo category) {
        Assert.isLegal((!this.m_categories.contains(category) ? 1 : 0) != 0, (String)("Duplicate category with id = " + category.getId()));
        this.m_categories.add(category);
    }

    public void moveCategory(String id, String nextId) {
        if (id.equals(nextId)) {
            return;
        }
        CategoryInfo category = this.getCategory(id);
        if (category == null) {
            return;
        }
        this.m_categories.remove(category);
        CategoryInfo nextCategory = this.getCategory(nextId);
        if (nextCategory != null) {
            int index = this.m_categories.indexOf(nextCategory);
            this.m_categories.add(index, category);
        } else {
            this.m_categories.add(category);
        }
    }

    public CategoryInfo getCategory(String id) {
        for (CategoryInfo category : this.m_categories) {
            if (!category.getId().equals(id)) continue;
            return category;
        }
        return null;
    }

    public EntryInfo getEntry(String id) {
        for (CategoryInfo category : this.m_categories) {
            for (EntryInfo entry : category.getEntries()) {
                if (!entry.getId().equals(id)) continue;
                return entry;
            }
        }
        return null;
    }
}

