/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.gef.core.requests;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.wb.gef.core.EditPart;

public class Request {
    public static final String REQ_OPEN = "open";
    public static final String REQ_SELECTION = "selection";
    public static final String REQ_MOVE = "move";
    public static final String REQ_ADD = "add children";
    public static final String REQ_ORPHAN = "orphan children";
    public static final String REQ_CREATE = "create child";
    public static final String REQ_DELETE = "delete";
    public static final String REQ_PASTE = "paste";
    public static final String REQ_KEY_EVENT = "key event";
    private Object m_type;
    private EditPart m_target;
    private int m_stateMask;
    private boolean m_eraseFeedback;
    private int m_dndFeedback;
    private Map<Object, Object> m_arbitraryMap;

    public Request() {
    }

    public Request(Object type) {
        this.setType(type);
    }

    public final Object getType() {
        return this.m_type;
    }

    public final void setType(Object type) {
        this.m_type = type;
    }

    public EditPart getTarget() {
        return this.m_target;
    }

    public void setTarget(EditPart target) {
        this.m_target = target;
    }

    public final boolean isAltKeyPressed() {
        return (this.m_stateMask & 0x10000) != 0;
    }

    public final boolean isControlKeyPressed() {
        return (this.m_stateMask & 0x40000) != 0;
    }

    public final boolean isShiftKeyPressed() {
        return (this.m_stateMask & 0x20000) != 0;
    }

    public final boolean isLeftMouseButtonPressed() {
        return (this.m_stateMask & 0x80000) != 0;
    }

    public final boolean isRightMouseButtonPressed() {
        return (this.m_stateMask & 0x200000) != 0;
    }

    public final boolean isAnyMouseButtonPressed() {
        return (this.m_stateMask & 0x380000) != 0;
    }

    public final int getStateMask() {
        return this.m_stateMask;
    }

    public final void setStateMask(int stateMask) {
        this.m_stateMask = stateMask;
    }

    public String toString() {
        return "Request(type=" + this.m_type + ", stateMask=" + this.m_stateMask + ")";
    }

    protected static String safeToString(Object o) {
        try {
            return o == null ? null : o.toString();
        }
        catch (Throwable e) {
            return "<exception>";
        }
    }

    public boolean isEraseFeedback() {
        return this.m_eraseFeedback;
    }

    public void setEraseFeedback(boolean eraseFeedback) {
        this.m_eraseFeedback = eraseFeedback;
    }

    public int getDNDFeedback() {
        return this.m_dndFeedback;
    }

    public void setDNDFeedback(int dndFeedback) {
        this.m_dndFeedback = dndFeedback;
    }

    public final void putArbitraryValue(Object key, Object value) {
        if (this.m_arbitraryMap == null) {
            this.m_arbitraryMap = new HashMap<Object, Object>();
        }
        this.m_arbitraryMap.put(key, value);
    }

    public final Object getArbitraryValue(Object key) {
        if (this.m_arbitraryMap != null) {
            return this.m_arbitraryMap.get(key);
        }
        return null;
    }
}

