/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.os.macosx;

import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.os.macosx.OSSupportMacOSX;
import org.eclipse.wb.internal.swt.VisualDataMockupProvider;

public abstract class OSSupportMacOSXCocoa<H extends Number>
extends OSSupportMacOSX {
    static {
        try {
            System.loadLibrary("wbp-cocoa");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected void makeShellVisible(Shell shell) {
        shell.setVisible(true);
        OSSupportMacOSXCocoa._orderOut(this.getID(shell, "window"));
    }

    public Image makeShot(Control control) throws Exception {
        Rectangle bounds;
        block8: {
            bounds = control.getBounds();
            if (bounds.width > 0 && bounds.height > 0) break block8;
            return null;
        }
        try {
            H view = this.getID(control, "view");
            Image image = new Image((Device)control.getDisplay(), bounds);
            GC gc = new GC((Drawable)image);
            H context = this.getID(gc, "handle");
            if (control instanceof Shell) {
                OSSupportMacOSXCocoa._makeWindowShot(view, context);
            } else {
                Composite parent = control.getParent();
                OSSupportMacOSXCocoa._makeShot(view, this.getID(parent, "view"), context);
            }
            gc.dispose();
            control.setData("WBP_IMAGE", (Object)image);
            if (control instanceof Composite && !(control instanceof Browser)) {
                Composite composite = (Composite)control;
                Control[] children = composite.getChildren();
                int i = 0;
                while (i < children.length) {
                    Image childImage;
                    Control child = children[children.length - 1 - i];
                    if (child.isVisible() && (childImage = this.makeShot(child)) != null) {
                        child.setData("WBP_IMAGE", (Object)childImage);
                    }
                    ++i;
                }
            }
            return image;
        }
        catch (Throwable e) {
            throw ReflectionUtils.propagate((Throwable)e);
        }
    }

    protected abstract H getID(Object var1, String var2);

    public int getDefaultMenuBarHeight() {
        return OSSupportMacOSXCocoa._getMenuBarHeight();
    }

    public Image getMenuPopupVisualData(Menu menu, int[] bounds) throws Exception {
        H handle = this.getID(menu, "nsMenu");
        int[] menuSize = new int[4];
        int[] itemsBounds = new int[bounds.length];
        OSSupportMacOSXCocoa._fetchPopupMenuBounds(handle, menuSize);
        Image image = new Image((Device)menu.getDisplay(), menuSize[2], menuSize[3]);
        GC gc = new GC((Drawable)image);
        OSSupportMacOSXCocoa._fetchPopupMenuVisualData(handle, this.getID(gc, "handle"), itemsBounds);
        this.fixupSeparatorItems(menu, bounds, menuSize, itemsBounds);
        gc.dispose();
        return image;
    }

    public int getAlpha(Shell shell) {
        return OSSupportMacOSXCocoa._getAlpha(this.getID(shell, "window"));
    }

    public void setAlpha(Shell shell, int alpha) {
        OSSupportMacOSXCocoa._setAlpha(this.getID(shell, "window"), alpha);
    }

    public Image makeShotAwt(final Object component, final int width, final int height) {
        final Image[] toReturn = new Image[1];
        final Display display = DesignerPlugin.getStandardDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                toReturn[0] = OSSupportMacOSXCocoa.this.makeShotAwt0(display, component, width, height);
            }
        });
        return toReturn[0];
    }

    private Image makeShotAwt0(Display display, Object component, int width, int height) {
        GC gc = null;
        try {
            Image image = new Image((Device)display, width, height);
            gc = new GC((Drawable)image);
            H context = this.getID(gc, "handle");
            Number peerId = OSSupportMacOSXCocoa.getComponentPeerId(component);
            Number parentId = OSSupportMacOSXCocoa.findParentComponentPeerId(component);
            if (peerId == null || parentId == null || peerId.equals(parentId)) {
                return null;
            }
            OSSupportMacOSXCocoa._makeShot(peerId, parentId, context);
            Image image2 = image;
            return image2;
        }
        catch (Throwable throwable) {
        }
        finally {
            if (gc != null) {
                gc.dispose();
            }
        }
        return null;
    }

    private static Number findParentComponentPeerId(Object component) throws Exception {
        component = OSSupportMacOSXCocoa.getParentComponent(component);
        while (component != null) {
            Number peerId = OSSupportMacOSXCocoa.getComponentPeerId(component);
            if (peerId != null) {
                return peerId;
            }
            component = OSSupportMacOSXCocoa.getParentComponent(component);
        }
        return null;
    }

    private static Object getParentComponent(Object component) throws Exception {
        return ReflectionUtils.invokeMethod2((Object)component, (String)"getParent");
    }

    private static Number getComponentPeerId(Object component) {
        try {
            Object peer;
            boolean hasPeer = (Boolean)ReflectionUtils.invokeMethod2((Object)component, (String)"isDisplayable");
            if (hasPeer && (peer = ReflectionUtils.getFieldObject((Object)component, (String)"peer")) != null) {
                return (Number)ReflectionUtils.invokeMethod2((Object)peer, (String)"getViewPtr");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static native <H extends Number> void _orderOut(H var0);

    private static native <H extends Number> void _makeShot(H var0, H var1, H var2);

    private static native <H extends Number> void _makeWindowShot(H var0, H var1);

    private static native int _getMenuBarHeight();

    private static native <H extends Number> void _fetchPopupMenuVisualData(H var0, H var1, int[] var2);

    private static native <H extends Number> void _fetchPopupMenuBounds(H var0, int[] var1);

    private static native <H extends Number> void _setAlpha(H var0, int var1);

    private static native <H extends Number> int _getAlpha(H var0);

    public static final class Cocoa64
    extends OSSupportMacOSXCocoa<Long> {
        private final VisualDataMockupProvider mockupProvider = new VisualDataMockupProvider();

        @Override
        protected Long getID(Object control, String string) {
            Object fieldObject = ReflectionUtils.getFieldObject((Object)control, (String)string);
            return (Long)ReflectionUtils.getFieldObject((Object)fieldObject, (String)"id");
        }

        @Override
        public Image getMenuPopupVisualData(Menu menu, int[] bounds) throws Exception {
            return this.mockupProvider.mockMenuPopupVisualData(menu, bounds);
        }
    }
}

