/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.draw2d;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.wb.draw2d.Figure;
import org.eclipse.wb.draw2d.FigureUtils;
import org.eclipse.wb.draw2d.ILocator;
import org.eclipse.wb.draw2d.IPositionConstants;

public abstract class AbstractRelativeLocator
implements ILocator,
IPositionConstants {
    private final double m_relativeX;
    private final double m_relativeY;

    public AbstractRelativeLocator(double relativeX, double relativeY) {
        this.m_relativeX = relativeX;
        this.m_relativeY = relativeY;
    }

    public AbstractRelativeLocator(int location) {
        switch (location & 5) {
            case 1: {
                this.m_relativeY = 0.0;
                break;
            }
            case 4: {
                this.m_relativeY = 1.0;
                break;
            }
            default: {
                this.m_relativeY = 0.5;
            }
        }
        switch (location & 0x18) {
            case 8: {
                this.m_relativeX = 0.0;
                break;
            }
            case 16: {
                this.m_relativeX = 1.0;
                break;
            }
            default: {
                this.m_relativeX = 0.5;
            }
        }
    }

    @Override
    public final void relocate(Figure target) {
        Rectangle reference = this.getReferenceRectangle();
        FigureUtils.translateAbsoluteToFigure(target, (Translatable)reference);
        Dimension targetSize = target.getSize();
        int x = reference.x + (int)((double)reference.width * this.m_relativeX) - (targetSize.width + 1) / 2;
        int y = reference.y + (int)((double)reference.height * this.m_relativeY) - (targetSize.height + 1) / 2;
        target.setLocation(new Point(x, y));
    }

    protected abstract Rectangle getReferenceRectangle();
}

