/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gefTree.policy.menu;

import java.util.List;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.wb.core.gef.command.EditCommand;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.policies.ILayoutRequestValidator;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.CreateRequest;
import org.eclipse.wb.gef.core.requests.PasteRequest;
import org.eclipse.wb.gef.tree.policies.LayoutEditPolicy;
import org.eclipse.wb.internal.core.model.menu.IMenuInfo;
import org.eclipse.wb.internal.core.model.menu.IMenuPolicy;

public final class MenuLayoutEditPolicy
extends LayoutEditPolicy {
    private final ObjectInfo m_menuInfo;
    private final IMenuInfo m_menuObject;
    private final IMenuPolicy m_menuPolicy;
    private final ILayoutRequestValidator VALIDATOR = new ILayoutRequestValidator(){

        @Override
        public boolean validateCreateRequest(EditPart host, CreateRequest request) {
            return MenuLayoutEditPolicy.this.m_menuPolicy.validateCreate(request.getNewObject());
        }

        @Override
        public boolean validatePasteRequest(EditPart host, PasteRequest request) {
            return MenuLayoutEditPolicy.this.m_menuPolicy.validatePaste(request.getMemento());
        }

        @Override
        public boolean validateMoveRequest(EditPart host, ChangeBoundsRequest request) {
            for (EditPart editPart : request.getEditParts()) {
                if (MenuLayoutEditPolicy.this.m_menuPolicy.validateMove(editPart.getModel())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean validateAddRequest(EditPart host, ChangeBoundsRequest request) {
            return this.validateMoveRequest(host, request);
        }
    };

    public MenuLayoutEditPolicy(ObjectInfo menuInfo, IMenuInfo menuObject) {
        this.m_menuInfo = menuInfo;
        this.m_menuObject = menuObject;
        this.m_menuPolicy = this.m_menuObject.getPolicy();
    }

    @Override
    protected boolean isGoodReferenceChild(Request request, EditPart editPart) {
        return true;
    }

    @Override
    protected Command getCreateCommand(final Object newObject, final Object referenceObject) {
        return new EditCommand(this.m_menuInfo){

            @Override
            public void executeEdit() throws Exception {
                MenuLayoutEditPolicy.this.m_menuPolicy.commandCreate(newObject, referenceObject);
            }
        };
    }

    @Override
    protected Command getPasteCommand(final PasteRequest request, final Object referenceObject) {
        return new EditCommand(this.m_menuInfo){

            @Override
            public void executeEdit() throws Exception {
                MenuLayoutEditPolicy.this.m_menuPolicy.commandPaste(request.getMemento(), referenceObject);
            }
        };
    }

    @Override
    protected Command getMoveCommand(final List<EditPart> moveParts, final Object referenceObject) {
        return new EditCommand(this.m_menuInfo){

            @Override
            public void executeEdit() throws Exception {
                for (EditPart editPart : moveParts) {
                    MenuLayoutEditPolicy.this.m_menuPolicy.commandMove(editPart.getModel(), referenceObject);
                }
            }
        };
    }

    @Override
    protected Command getAddCommand(List<EditPart> addParts, Object referenceObject) {
        return this.getMoveCommand(addParts, referenceObject);
    }

    @Override
    protected ILayoutRequestValidator getRequestValidator() {
        return this.VALIDATOR;
    }
}

