/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.JavaEventListener;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetObjectAfter;
import org.eclipse.wb.core.model.broadcast.JavaInfoSetVariable;
import org.eclipse.wb.core.model.broadcast.ObjectInfoChildTree;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.internal.core.databinding.model.IDatabindingsProvider;
import org.eclipse.wb.internal.core.databinding.model.ISynchronizeProcessor;
import org.eclipse.wb.internal.core.model.nonvisual.CollectorObjectInfo;
import org.eclipse.wb.internal.core.model.variable.FieldVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.state.EditorState;

public final class SynchronizeManager {
    private final IDatabindingsProvider m_provider;

    public SynchronizeManager(IDatabindingsProvider provider, JavaInfo javaInfoRoot) {
        this.m_provider = provider;
        javaInfoRoot.addBroadcastListener((Object)new ObjectInfoDelete(){

            public void after(ObjectInfo parent, ObjectInfo child) throws Exception {
                SynchronizeManager.this.synchronizeObserves();
            }
        });
        javaInfoRoot.addBroadcastListener((Object)new JavaEventListener(){

            public void addAfter(JavaInfo parent, JavaInfo child) throws Exception {
                if (EditorState.get((AstEditor)child.getEditor()).isLiveComponent()) {
                    return;
                }
                this.handleCreate(child);
            }

            public void moveAfter(JavaInfo child, ObjectInfo oldParent, JavaInfo newParent) throws Exception {
                SynchronizeManager.this.synchronizeObserves();
            }

            public void replaceChildBefore(JavaInfo parent, JavaInfo oldChild, JavaInfo newChild) throws Exception {
                SynchronizeManager.this.m_provider.deleteBindings(oldChild);
            }

            public void replaceChildAfter(JavaInfo parent, JavaInfo oldChild, JavaInfo newChild) throws Exception {
                this.handleCreate(newChild);
            }

            private void handleCreate(final JavaInfo javaInfo) {
                javaInfo.addBroadcastListener((Object)new JavaInfoSetObjectAfter(){

                    public void invoke(JavaInfo target, Object o) throws Exception {
                        if (javaInfo == target) {
                            target.removeBroadcastListener((Object)this);
                            SynchronizeManager.this.synchronizeObserves();
                        }
                    }
                });
            }
        });
        javaInfoRoot.addBroadcastListener((Object)new JavaInfoSetVariable(){

            public void invoke(JavaInfo javaInfo, VariableSupport oldVariable, VariableSupport newVariable) throws Exception {
                if (oldVariable != null && this.isField(oldVariable) ^ this.isField(newVariable)) {
                    SynchronizeManager.this.synchronizeObserves();
                }
            }

            private boolean isField(VariableSupport variable) {
                return variable instanceof FieldVariableSupport;
            }
        });
    }

    private void synchronizeObserves() throws Exception {
        this.m_provider.synchronizeObserves();
    }

    public static <T, V> void synchronizeObjects(List<V> objects, List<T> newKeyObjects, ISynchronizeProcessor<T, V> processor) throws Exception {
        int beanCount = 0;
        HashMap<T, V> keyObjectToObject = new HashMap<T, V>();
        for (V object : objects) {
            if (!processor.handleObject(object)) continue;
            keyObjectToObject.put(processor.getKeyObject(object), object);
            ++beanCount;
        }
        int keyCount = newKeyObjects.size();
        int index = 0;
        while (index < keyCount) {
            V object;
            T keyObject = newKeyObjects.get(index);
            if (index < beanCount && processor.equals(processor.getKeyObject(object = objects.get(index)), keyObject)) {
                processor.update(object);
            } else {
                object = keyObjectToObject.get(keyObject);
                if (object == null) {
                    object = processor.findObject(keyObjectToObject, keyObject);
                }
                if (object == null) {
                    object = processor.createObject(keyObject);
                    if (object == null) {
                        newKeyObjects.remove(index--);
                        --keyCount;
                    } else {
                        objects.add(index, object);
                    }
                } else {
                    objects.remove(object);
                    objects.add(index, object);
                    processor.update(object);
                }
            }
            ++index;
        }
        int i = index;
        while (i < beanCount) {
            objects.remove(index);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <T extends ObjectInfo> List<T> getChildren(ObjectInfo objectInfo, Class<T> clazz) throws Exception {
        ArrayList<ObjectInfo> childrenInfos = new ArrayList<ObjectInfo>();
        for (ObjectInfo childObjectInfo : objectInfo.getChildren()) {
            boolean[] visible = new boolean[]{childObjectInfo.getPresentation().isVisible()};
            ((ObjectInfoChildTree)objectInfo.getBroadcast(ObjectInfoChildTree.class)).invoke(childObjectInfo, visible);
            if (!visible[0]) continue;
            ObjectInfo objectInfo2 = childObjectInfo;
            if (objectInfo2 instanceof CollectorObjectInfo) {
                void collectorObjectInfo;
                CollectorObjectInfo cfr_ignored_0 = (CollectorObjectInfo)objectInfo2;
                CollectorObjectInfo cfr_ignored_1 = (CollectorObjectInfo)objectInfo2;
                for (ObjectInfo itemObjectInfo : collectorObjectInfo.getItems()) {
                    if (!clazz.isAssignableFrom(itemObjectInfo.getClass())) continue;
                    childrenInfos.add(itemObjectInfo);
                }
                continue;
            }
            if (!clazz.isAssignableFrom(childObjectInfo.getClass())) continue;
            childrenInfos.add(childObjectInfo);
        }
        return childrenInfos;
    }
}

